/*
 *      Copyright (c) 1987 Paul Campbell
 *      All Rights Reserved
 *      THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Paul Campbell
 *      The copyright notice above does not evidence any
 *      actual or intended publication of such source code.
 */

#pragma segment lex
#include <stdio.h>
#include <stdlib.h>
#ifdef MPW
#include <string.h>
#include <osutils.h>
#endif
#ifdef _DOS
#include "ctab.h"
#else
#include "comp.tab.h"
#endif
#include "lex.h"
FILE *fin;

extern int yydebug;
extern int nowarn;
extern int yylval;

extern struct OP *make_string(char *str);
extern int yydebug;
int yyerrcount;
unsigned long yyline;
static char *yyfile;
static char name[257];
static char *yys=NULL;

struct keywords {
	int 	type;
	char 	*name;
};

struct keywords keywords[] = {
	t_found_launch,	"___found_launch",
	t_log_base,	"___log_base",
	t_log_end,	"___log_end",
	t_set_log_full,	"___set_log_full",
	t_arm,		"arm",
	t_beep,		"beep",
	t_break,	"break",
	t_case,		"case",
	t_char,		"char",
	t_class,	"class",
	t_continue,	"continue",
	t_default,	"default",
	t_do,		"do",
	t_double,	"double",
	t_eeload,	"eeload",
	t_eesave,	"eesave",
	t_else,		"else",
	t_enum,		"enum",
	t_extern,	"extern",
	t_fire,		"fire",
	t_float,	"float",
	t_for,		"for",
	t_get,		"get",
	t_goto,		"goto",
	t_halt,		"halt",
	t_idle,		"idle",
	t_if,		"if",
	t_input,	"input",
	t_int,		"int",
	t_interrupt,	"interrupt",
	t_launch,	"launch",
	t_log,		"log",
	t_log_ctl,	"log_ctl",
	t_log_full,	"log_full",
	t_long,		"long",
	t_ltime,	"ltime",
	t_next,		"next",
	t_on,		"on",
	t_output,	"output",
	t_pchr,		"pchr",
	t_phex,		"phex",
	t_pstr,		"pstr",
	t_pval,		"pval",
	t_register,	"register",
	t_return,	"return",
	t_rtime,	"rtime",
	t_safe,		"safe",
	t_set,		"set",
	t_int,		"short",
	t_sizeof,	"sizeof",
	t_state,	"state",
	t_static,	"static",
	t_stime,	"stime",
	t_struct,	"struct",
	t_switch,	"switch",
	t_time,		"time",
	t_timeout,	"timeout",
	t_typedef,	"typedef",
	t_union,	"union",
	t_unsigned,	"unsigned",
	t_void,		"void",
	t_while,	"while",
	0,		"\377",
};

#define next_char()	(yys?(*yys==0?EOF:*yys++):getc(fin))
#define back_char(c) { if (yys)yys--; else ungetc(c, fin); }

struct dict *dict_head = NULL;

struct dict *
find_name(char *name)
{
	register struct dict *dp;
	register int i;
	
	dp = dict_head;
	for (;;) {
		if (dp == NULL)
			return(NULL);
		i = strcmp(name, dp->name);
		if (i == 0)
			return(dp);
		if (i > 0) {
			dp = dp->gt;
		} else {
			dp = dp->lt;
		}
	}
}

struct dict *
add_name(char *name)
{
	register struct dict *dp, *dp2;
	register int i;

	i = strlen(name)+1+sizeof(*dp);
	dp2 = (struct dict *)malloc(strlen(name)+1+sizeof(*dp2));
	strcpy(dp2->name, name);
	dp2->val = 0;
	dp2->type = TYPE_UNKNOWN;
	dp2->loc = LOC_UNKNOWN;
	dp2->lt = NULL;
	dp2->gt = NULL;
	if ((dp = dict_head) == NULL) {
		dict_head = dp2;
	} else {
		for (;;) {
			i = strcmp(name, dp->name);
			if (i == 0) {
				yyerror("Duplicate variable '%s'", (long)name, 0, 0, 0, 0, 0);
				free(dp2);
				return(dp);
			}
			if (i > 0) {
				if (dp->gt == NULL) {
					dp->gt = dp2;
					break;
				}
				dp = dp->gt;
			} else {
				if (dp->lt == NULL) {
					dp->lt = dp2;
					break;
				}
				dp = dp->lt;
			}
		}
	}
	return(dp2);
}

void
ptree(struct dict *dp, int flag)
{
	if (dp == NULL)
		return;
	ptree(dp->lt, flag);
	if (flag)
		printf("%04x: %c %c %s\n", dp->val, *("?CPLGS"+dp->loc), (dp->type > TYPE_LONG_IND_IND ? '?':*("?CWLXYZcwlxyz124357"+dp->type)), dp->name);
	ptree(dp->gt, flag);
}

void
pmap(int flag)
{
	ptree(dict_head, flag);
}

void
stree(struct dict *dp)
{
	if (dp == NULL)
		return;
	stree(dp->lt);
	stree(dp->gt);
	if (dp->loc == LOC_PROC && dp->label->state == 0)
                yyerror("Subroutine referenced but not defined '%s'", (long)dp->name,0,0,0,0,0);
	if (dp->loc == LOC_STATE && dp->label->state == 0)
                yyerror("State referenced but not defined '%s'", (long)dp->name,0,0,0,0,0);
		
}

void
check_states()
{
	stree(dict_head);
}


void
yyinit()
{
/*	ptree(dict_head, 0);*/
}


int
yyopen(char *file)
{
	yyline = 1;
	yyfile = file;
	yyerrcount = 0;
	yys = NULL;
	fin = fopen(file, "r");
	if (fin)
		return(0);
	return(1);
}


int
yyopen_string(char *s)
{
	yyline = 1;
	yyfile = "internal string";
	yyerrcount = 0;
	yys = s;
	fin = NULL;
}

void
yyerror(char *s, long a, long b, long c, long d, long e, long f)
{
	fprintf(stderr, "File	\"%s\"; Line %d # ", yyfile, yyline);
	fprintf(stderr, s, a, b, c, d, e, f);
	fprintf(stderr, "\n");
	yyerrcount++;
}

void 
yywarnline(int err, char *s, long a, long b, long c, long d, long e, long f)
{
	long *x = (long *)&s;

	if (nowarn)
		return;
	fprintf(stderr, "File	\"%s\"; Line %d # Warning: ", yyfile, err);
	fprintf(stderr, s, a,b,c,d,e,f);
	fprintf(stderr, "\n");
}

void 
yyerrline(int err, char *s, long a, long b, long c, long d, long e, long f)
{
	int i = yyline;
	long *x = (long *)&s;
	
	yyline = err;
	yyerror(s, a,b,c,d,e,f);
	yyline = i;
}

void 
yyerrlinex(long err, char *s, long a, long b, long c, long d, long e, long f)
{
	int i = yyline;
	long *x = (long *)&s;
	
	yyline = err;
	yyerror(s, a,b,c,d,e,f);
	yyline = i;
}

void
yyclose()
{
	if (fin) {
		fclose(fin);
		fin = NULL;
	}
	yys = NULL;
}

int
yylex()
{
	register long c, i, j, k;
	struct dict *dp;
	
	for (;;) {
again:	for (;;) {
			c = next_char();
			if (c == ' ' || c == '\t')
				continue;
			if (c == '\n') {
				yyline++;
				continue;
			}
			break;
		}
		if ((c >= 'a' && c <= 'z') ||
			(c >= 'A' && c <= 'Z') ||
			 c == '_') {
			name[0] = c;
			for (i = 1;;i++) {
				c = next_char();
				if ((c >= 'a' && c <= 'z') ||
					(c >= 'A' && c <= 'Z') ||
					(c >= '0' && c <= '9') ||
					 c == '$' ||
					 c == '_') {
					 name[i] = c;
					 continue;
				}
				name[i] = 0;
				break;
			}
names:
			back_char(c);
			for (j = 0; ;j++) {
				if ((k = strcmp(name, keywords[j].name)) == 0) {
					yylval = (long)yyline;
					return(keywords[j].type);
				}
				if (keywords[j].type==0)
					break;
			}
			dp = find_name(name);
			if (dp == NULL)
				dp = add_name(name);
			yylval = (long)dp;
			return(t_symbol);
		} 
		if (c >= '0' && c <= '9') {
			i = 0;
			if (c == '0') {
				c = next_char();
				if (c == 'x' || c == 'X') {
					c = next_char();
					while ((c >= '0' && c <= '9') || (c >= 'A' && c <= 'F') || (c >= 'a' && c <= 'f')) {
						if (c >= '0' && c <= '9') {
							i = (i<<4)+c-'0';
						} else
						if (c >= 'A' && c <= 'F') {
							i = (i<<4)+10+c-'A';
						} else {
							i = (i<<4)+10+c-'a';
						}
						c = next_char();
					}
				} else 
				if (c >= '0' || c <= '7') {
					while (c >= '0' && c <= '7') {
						i = (i<<3)+c-'0';
						c = next_char();
					}
				} 
			} else {
				while (c >= '0' && c <= '9') {
					i = i*10+c-'0';
					c = next_char();
				}
			}
			back_char(c);
			yylval = i;
			return(t_num);
		} 
		yylval = (long)yyline;
		switch (c&0xff) {
		case '|':
				c = next_char();
				if (c == '=')
					return(t_oreq);
				if (c == '|')
					return(t_oror);
				back_char(c);
				c = '|';
				break;

		case '&':
				c = next_char();
				if (c == '=')
					return(t_andeq);
				if (c == '&')
					return(t_andand);
				back_char(c);
				c = '&';
				break;

		case '*':
				c = next_char();
				if (c == '=')
					return(t_muleq);
				back_char(c);
				c = '*';
				break;
		case '^':
				c = next_char();
				if (c == '=')
					return(t_xoreq);
				back_char(c);
				c = '^';
				break;
		case '%':
				c = next_char();
				if (c == '=')
					return(t_modeq);
				back_char(c);
				c = '%';
				break;
		case '!':
				c = next_char();
				if (c == '=')
					return(t_noteq);
				back_char(c);
				c = '!';
				break;
		case '=':
				c = next_char();
				if (c == '=')
					return(t_eqeq);
				back_char(c);
				c = '=';
				break;
		case '<':
				c = next_char();
				if (c == '=')
					return(t_lteq);
				if (c == '<') {
					c = next_char();
					if (c == '=')
						return(t_ltlteq);
					back_char(c);
					return(t_ltlt);
				}
				back_char(c);
				c = '<';
				break;
		case '+':
				c = next_char();
				if (c == '=')
					return(t_pluseq);
				if (c == '+')
					return(t_plusplus);
				back_char(c);
				c = '+';
				break;
		case '-':
				c = next_char();
				if (c == '=')
					return(t_minuseq);
				if (c == '-')
					return(t_minusminus);
				back_char(c);
				c = '-';
				break;

		case '>':
				c = next_char();
				if (c == '=')
					return(t_gteq);
				if (c == '>') {
					c = next_char();
					if (c == '=')
						return(t_gtgteq);
					back_char(c);
					return(t_gtgt);
				}
				back_char(c);
				c = '>';
				break;

		case '\'':
				for (i = 0;;i++) {
					name[i] = c = next_char();
					if (c == '\n' || c == EOF) {
						yyerror("string overflowed line",0,0,0,0,0,0);
						return(t_num);
					}
					if (c == '\'') {
						break;
					}
					if (c == '\\') {
						c = next_char();
						switch (c) {
						case 'n':
							c = 0xa;
							break;
						case 'r':
							c = 0xd;
							break;
						case 't':
							c = '\t';
							break;
						case 'f':
							c = '\f';
							break;
						case 'b':
							c = '\b';
							break;
						}
						name[i] = c;
					}
					if (i >= 3) {
						yyerror("string > 2 chars",0,0,0,0,0,0);
						i = 2;
						break;
					}
				}
				if (i == 1) {
					yylval = name[0]&0xff;
				} else
				if (i == 2) {
					yylval = *(unsigned short *)name;
				} 
				return(t_num);
				
		case '/':
				c = next_char();
				if (c == '=') 
					return(t_diveq);
				if (c == '*') {
					i = yyline;
					for (;;) {
						c = next_char();
						while (c == '*') {
							c = next_char();
							if (c == '/')
								goto out;
						}
						if (c == '\n') {
							yyline++;
						} else
						if (c == EOF) 
							break;
					}
					k = yyline;
					yyline = j;
					yyerror("runaway comment",0,0,0,0,0,0);
					yyline = k;
	out:
					continue;
				} else
				if (c == '/') {
					for (;;) {
						c = next_char();
						if (c == '\n' || c == EOF) 
							break;
					}
					if (c == '\n')
						yyline++;
					continue;
				}
				back_char(c);
				c = '/';
				break;
			
		case '"':
				for (i = 0;;i++) {
					name[i] = c = next_char();
					if (c == '\n' || c == EOF) {
						yyerror("string overflowed line",0,0,0,0,0,0);
						return(t_string);
					}
					if (c == '"') {
						name[i] = 0;
						break;
					}
					if (c == '\\') {
						c = next_char();
						switch (c) {
						case 'n':
							c = 0xa;
							break;
						case 'r':
							c = 0xd;
							break;
						case 't':
							c = '\t';
							break;
						case 'f':
							c = '\f';
							break;
						case 'b':
							c = '\b';
							break;
						}
						name[i] = c;
					}
				}
				yylval = (long)make_string(name);
				return(t_string);
		}
		return(c);
	}
}
