/*
 *      Copyright (c) 1991 Paul Campbell
 *      All Rights Reserved
 *      THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Paul Campbell
 *      The copyright notice above does not evidence any
 *      actual or intended publication of such source code.
 */
 
#define COMPILER 1
static char Copyright[] = "Copyright (c) 1991 Paul Campbell All Rights Reserved";

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "lex.h"
int debug = 0;
static char *prog, *this_file;
FILE *fcode;
char code_file[256];
#ifdef MPW
char *prefix = ":";
#else
char *prefix = "";
#endif
extern int stack_size;
int nowarn = 0;
char *object_output = NULL;
int do_map;
int save_dest = -1;
extern int xdbg;
void start_out();
void write_out();
extern int	launch_channel;
extern int	launch_delta;
extern int	launch_wait;
extern int	launch_initial_wait;
extern int	launch_rel;
extern int	launch_delta_time;

int
main(int argc, char **argv)
{
	int i, quit, c, v;
	char *cp;
	
	yyinit();
	start_out();
	prog = argv[0];
	this_file = NULL;
	for (i = 1;i < argc; i++) {
		if (argv[i][0] == '-') {
			cp = &argv[i][1];
			for (quit = 0;!quit;) {
				switch (*cp++) {
				case 0:
					quit = 1;
					break;
				
				case 'D':
//					yydebug = 1 - yydebug;
					debug = 1 - debug;
					break;
					
				case 'd':
					xdbg = 1 - xdbg;
					break;
					
				case 'w':
					nowarn = 1-nowarn;
					break;
				case 'm':
					do_map = 1-do_map;
					break;
					
				case 'o':
					i++;
					if (i >= argc) {
						fprintf(stderr, "%s: missing argument for -%c\n", prog, cp[-1]);
						exit(2);
					}
					object_output = argv[i];
					break;
				case 'S':
					i++;
					if (i >= argc) {
						fprintf(stderr, "%s: missing argument for -%c\n", prog, cp[-1]);
						exit(2);
					}
					stack_size = strtol(argv[i], NULL, 0);
					break;
				case 's':
					i++;
					if (i >= argc) {
						fprintf(stderr, "%s: missing argument for -%c\n", prog, cp[-1]);
						exit(2);
					}
					save_dest = strtol(argv[i], NULL, 0);
					break;
				case 'l':
					c = *cp++;
					i++;
					if (i >= argc) {
						fprintf(stderr, "%s: missing argument for -%c\n", prog, cp[-1]);
						exit(2);
					}
					v = strtol(argv[i], NULL, 0);
					switch (c) {
					case 'c':
						launch_channel = v;
						break;
					case 'd':
						launch_delta = v;
						break;
					case 'w':
						launch_wait = v;
						break;
					case 'i':
						launch_initial_wait = v;
						break;
					case 'r':
						launch_rel = v;
						break;
					case 't':
						launch_delta_time = v;
						break;
					default:
						fprintf(stderr, "%s: missing argument for -L%c\n", prog, cp[-1]);
						exit(2);
					}
					break;
				default:
					fprintf(stderr, "%s: unknown flag -%c\n", prog, cp[-1]);
					exit(2);
				}
			}
		} else {
			if (this_file) {
				fprintf(stderr, "%s: multiple input files '%s' and '%s'\n", prog, this_file, argv[i]);
				exit(2);
			}
			this_file = argv[i];
		}
	}
	if (this_file == NULL) {
		fprintf(stderr, "%s: no input file\n", prog);
		exit(2);
	}
	if (yyopen(this_file)) {
		fprintf(stderr, "%s: can't open '%s'\n", prog, this_file);
		exit(2);
	}
	if (object_output) {
		strcpy(code_file, object_output);
	} else {
		strcpy(code_file, prefix);
		strcat(code_file, this_file);
		i = strlen(code_file);
		if (i > 2 && code_file[i-1] == 'r' && code_file[i-2] == '.') {
			code_file[i-1] = 'x';
			code_file[i]   = 0;
		} else {
			code_file[i] = '.';
			code_file[i+1] = 'x';
			code_file[i+2] = 0;
		}
	}
	fcode = fopen(code_file, "w");
	if (fcode == NULL) {
		fprintf(stderr, "%s: can't create '%s'\n", prog, code_file);
		exit(2);
	}
	init_states();
	yydone(yyparse());
	test_states();
	write_out();
	fclose(fcode);
	if (debug || do_map)
		pmap(1);
	return(0);
}

void
int_error(char *s, long a, long b, long c, long d, long e)
{
	fprintf(stderr, "internal compiler error: ");
	fprintf(stderr, s, a, b, c, d, e);
	fprintf(stderr, "\n");
	exit(2);
}

void
yydone(int x)
{
	yyclose();
	if (x || yyerrcount > 0) {
		fprintf(stderr, "%s: %d error%s in '%s', compile failed\n", prog, yyerrcount, (yyerrcount==1?"":"s"), this_file);
		exit(2);
	}
}
