/*
 *      Copyright (c) 1991 Paul Campbell
 *      All Rights Reserved
 *      THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Paul Campbell
 *      The copyright notice above does not evidence any
 *      actual or intended publication of such source code.
 */
#define COMPILER 1
#pragma segment code
#include <stdio.h>
#include <stdlib.h>
#ifdef MPW
#include <osutils.h>
#endif
#include "lex.h"
#include "code.h"

extern int debug;
extern int in_states;
int need_log = 0;

extern struct OP *constant();
extern struct OP *types();
extern void empty_stack();

extern struct OP *build1();

struct dict *proc;
struct dict *param_list = NULL;
int	global_base = 0;

static struct label *case_next, *case_last, *case_default;
static struct label *c0[100];
static struct label *c1[100];
static struct label *c2[100];
static int c3[100];
static int	case_type, case_sp=0;;
static void
push_case(int type)
{
	c0[++case_sp] = case_next;
	c1[case_sp] = case_last;
	c2[case_sp] = case_default;
	c3[case_sp] = case_type;
	case_type = type;
	case_next = NULL;
	case_last = NULL;
	case_default = new_label();
}

static void
pop_case()
{
	case_next = c0[case_sp];
	case_last = c1[case_sp];
	case_default = c2[case_sp];
	case_type = c3[case_sp--];
}

void
start_case(struct OP *p)
{
	int t;

	if (debug)
		tree_print("case1", p, 0);
	p = types(constant(p), TYPE_UNKNOWN);
	if (debug)
		tree_print("case2", p, 0);
	empty_stack();
	t = p->tp;
	exp(p);	
	if (!SCALAR_TYPE(p->tp))
		yyerror("invalid case type", 0,0,0,0,0,0);
	tree_free(p);
	push_case(t);
}

void
set_default()
{
	if (case_default == NULL)
		return;
	if (case_default->state) 
		yyerror("multiple case defaults", 0,0,0,0,0,0);
	use_label(case_default);
}

void
emit_case(struct OP *p, int flag)
{
	long v;

	p = constant(p);
	if (p && p->op != O_CONST) {
		yyerror("case selection should be constant", 0,0,0,0,0,0);
		v = 0;
	} else {
		v = p->o.c.val;
	}
	if (flag) {
		if (LONG_TYPE(case_type)) {
			out_jmp_const_4(P_JEQV_L, v, case_next);
		} else {
			out_jmp_const(P_JEQV, v, case_next);	
		}
		
	} else {
		if (LONG_TYPE(case_type)) {
			out_jmp_const_4(P_JNEV_L, v, case_last);
		} else {
			out_jmp_const(P_JNEV, v, case_last);	
		}
	}
	if (!flag && case_next) {
		use_label(case_next);
		case_next = NULL;
	}
	tree_free(p);
}

void
case_begin()
{
	if (case_last)
		use_label(case_last);
	case_last = new_label();
	case_next = new_label();
}

void
end_case()
{	
	if (!case_default->state)
		use_label(case_default);
	if (case_last)
		set_label(case_last, case_default);
	pop_case();
}



static struct label *continue_stack[100];
static int continue_sp=0;
void
change_continue_label(struct label *l)
{
	continue_stack[continue_sp] = l;
}
void
push_continue_label(struct label *l)
{
	continue_stack[++continue_sp] = l;
}
struct label *
pop_continue_label()
{
	return(continue_stack[continue_sp--]);
}

struct label *
continue_label()
{
	if (continue_sp <= 0) {
		yyerror("Invalid 'continue' statement", 0,0,0,0,0,0);
		return(0);
	}
	return(continue_stack[continue_sp]);
}

static struct label *break_stack[100];
static int break_sp=0;
void
push_break_label(struct label *l)
{
	break_stack[++break_sp] = l;
}
struct label *
pop_break_label()
{
	return(break_stack[break_sp--]);
}

struct label *
break_label()
{
	if (break_sp <= 0) {
		yyerror("Invalid 'break' statement", 0,0,0,0,0,0);
		return(0);
	}
	return(break_stack[break_sp]);
}

void
do_exp(struct OP *p)
{
	if (debug)
		tree_print("exp1", p, 0);
	p = types(constant(p), TYPE_UNKNOWN);
	if (debug)
		tree_print("exp2", p, 0);
	empty_stack();
	exp(p);	
	tree_free(p);
}

void
do_return(struct OP *p)
{
	if (in_states) {
		yyerror("return statement outside of a subroutine", 0,0,0,0,0,0);
		if (p)
			tree_free(p);
		return;
	}
	if (debug)
		tree_print("return1", p, 0);
	if (p == NULL) 
		p = make_constant(0);
	p = types(constant(p), proc->type);
	if (debug)
		tree_print("return2", p, 0);
	empty_stack();
	exp(p);
	out_const(P_RET, proc->val);
	tree_free(p);
}

void
do_assign(struct OP *p)
{
	if (debug)
		tree_print("assign1", p, 0);
	p = types(constant(p), TYPE_UNKNOWN);
	if (debug)
		tree_print("assign2", p, 0);
	empty_stack();
	exp(p);
	tree_free(p);
}


struct label *
new_label()
{
	struct label *l;
	static int x=0;

	l = (struct label *)malloc(sizeof(*l));
	l->state = 0;
	l->waiting = NULL;
	l->tag = x++;
	l->val = 0;
	return(l);
}

void
use_label(struct label *l)
{
	struct fixup *f, *ff;

	l->state = 1;
	l->val = pc;
	f = l->waiting;
	l->waiting = NULL;
	tag_label(l);
	while (f) {
		ff = f;
		fixup(l->tag, f->offset, l->val);
		f = f->next;
		free(ff);
	}
}

void
set_label(struct label *l, struct label *l2)
{
	struct fixup *f, *ff;

	l->state = 1;
	l->val = l2->val;
	f = l->waiting;
	l->waiting = NULL;
	retag_label(l, l2);
	while (f) {
		ff = f;
		fixup(l->tag, f->offset, l2->val);
		f = f->next;
		free(ff);
	}
}

void
out_label(struct label *l)
{
	struct fixup *f;

	if (l->state) {
		out_lab(l);
	} else {
		f = (struct fixup *)malloc(sizeof(*f));
		f->offset = pc;
		f->next = l->waiting;
		l->waiting = f;
		out_lab(l);
	}
}

void
done_label(struct label *l)
{
	if (l->waiting)
		int_error("done_label - failed", 0,0,0,0,0);
	free(l);
}

void
do_cond(int type, struct OP *p, struct label *l)
{
	if (debug)
		tree_print("do_cond", p, 0);
	p = types(constant(p), TYPE_WORD);
	empty_stack();
	if (p->op != O_CONST)
		exp(p);
	if (p->tp == O_LONG)
		out(P_LSHORTEN);
	if (type) {
		if (p->op == O_CONST) {
			if (p->o.c.val) 
				out_jmp(P_JMP, l);
		} else
		out_jmp(P_J_NE, l);
	} else {
		if (p->op == O_CONST) {
			if (!p->o.c.val) 
				out_jmp(P_JMP, l);
		} else
		out_jmp(P_J_EQ, l);
	}
	tree_free(p);
}

void
do_uncond(struct label *l)
{
	if (l)
		out_jmp(P_JMP, l);
}

int
get_lsize(struct OP *p, int type, int flag)
{
	if (p == NULL)
		return(0);
	if (p->op == O_LIST) 
		return(get_lsize(p->op1, type, flag)+get_lsize(p->op2, type, flag));
        if (p->op == O_STAR) 
		return(2);
	if (p->op == O_INDEX)
		return(p->op2->o.c.val*(CHAR_TYPE(type)? 1 : LONG_TYPE(type)?4 : 2) + (flag && CHAR_TYPE(type)? p->op2->o.c.val&1 : 0));
	if (p->op == O_NAME)
		return(flag && CHAR_TYPE(type)?2: SIZE_TYPE(type));
	return(get_lsize(p->op1,
		(p->op==O_CHAR ? TYPE_CHAR :
		 p->op==O_WORD ? TYPE_WORD :
		 p->op==O_LONG ? TYPE_LONG :
		 p->op==O_UCHAR ? TYPE_UCHAR :
		 p->op==O_UWORD ? TYPE_UWORD :
		 p->op==O_ULONG ? TYPE_ULONG :
		 p->op==O_CHAR_IND ? TYPE_CHAR_IND :
		 p->op==O_LONG_IND ? TYPE_LONG_IND :
		 p->op==O_WORD_IND ? TYPE_WORD_IND : 
		 p->op==O_UCHAR_IND ? TYPE_UCHAR_IND :
		 p->op==O_ULONG_IND ? TYPE_ULONG_IND :
		 p->op==O_UWORD_IND ? TYPE_UWORD_IND : TYPE_UNKNOWN), flag));
}

int 
declare_locals(int addr, struct OP *p, int type, int flag)
{
        if (p == NULL)
                return(addr);
        if (p->op == O_LIST) {
		addr = declare_locals(addr, p->op1, type, flag);
		return(declare_locals(addr, p->op2, type, flag));
	}
        if (p->op == O_STAR) 
                return(declare(type+TYPE_INC, p->op1->o.n.d, 1, 0, LOC_LOCAL, addr));
        if (p->op == O_INDEX) 
                return((flag && CHAR_TYPE(type) ? p->op2->o.c.val&1:0) + declare(type, p->op1->o.n.d, p->op2->o.c.val, 1, LOC_LOCAL, addr));
        if (p->op == O_NAME) 
                return((flag && CHAR_TYPE(type) ? 1:0) + declare(type, p->o.n.d, 1, 0, LOC_LOCAL, addr));
        return(declare_locals(addr, p->op1, 
		(p->op==O_CHAR ? TYPE_CHAR :
		 p->op==O_WORD ? TYPE_WORD :
		 p->op==O_LONG ? TYPE_LONG :
		 p->op==O_UCHAR ? TYPE_UCHAR :
		 p->op==O_UWORD ? TYPE_UWORD :
		 p->op==O_ULONG ? TYPE_ULONG :
		 p->op==O_CHAR_IND ? TYPE_CHAR_IND :
		 p->op==O_LONG_IND ? TYPE_LONG_IND :
		 p->op==O_WORD_IND ? TYPE_WORD_IND : 
		 p->op==O_UCHAR_IND ? TYPE_UCHAR_IND :
		 p->op==O_ULONG_IND ? TYPE_ULONG_IND :
		 p->op==O_UWORD_IND ? TYPE_UWORD_IND : TYPE_UNKNOWN), flag));
}


void
enter_proc(int type, struct dict *name, struct OP *params, struct OP *locals)
{
	int	locals_sizes, param_sizes;
	
	proc = name;
	if (name->loc == LOC_UNKNOWN) {
		name->loc = LOC_PROC;
		name->type = type;
		name->label = new_label();
	} else 
	if (name->loc != LOC_PROC ||  name->type != type) {
		tree_free(params);
		yyerror("Duplicate variable declaration '%s'", (long)name->name,0,0,0,0,0);
		param_list = NULL;
		return;
	}
	log_code("subroutine", name);
	use_label(name->label);
	param_sizes = get_lsize(params, 0, 1);
	locals_sizes = get_lsize(locals, 0, 0);
	name->val = (locals_sizes==0?(param_sizes==0?0xffff:0):locals_sizes);			// amount to cut back
	param_list = NULL;
	(void)declare_locals(0, locals, 0, 0);
	(void)declare_locals(4+locals_sizes, params, 0, 1);
	out_const(P_ENTER, name->val);
	tree_free(locals);
	tree_free(params);
}

void
forward_proc(int type, struct dict *name)
{
	if (name->loc == LOC_UNKNOWN) {
		name->loc = LOC_PROC;
		name->type = type;
		name->label = new_label();
	} else 
	if (name->loc != LOC_PROC ||  name->type != type) {
		yyerror("Duplicate variable declaration '%s'", (long)name->name,0,0,0,0,0);
	}
}

void
exit_proc()
{
	struct dict *dp;
	
	do_return(NULL);
	for (dp = param_list; dp; dp = dp->param_next) {
		dp->type = dp->type_save;
		dp->val = dp->val_save;
		dp->loc = dp->loc_save;
		dp->array = dp->array_save;
		dp->size = dp->size_save;
	}
	param_list = NULL;
}

int
declare(int type, struct dict *name, int size, int array, int loc, int val)
{
	int s;
	
	if (loc == LOC_LOCAL) {
		if (name->loc == LOC_LOCAL) {
			yyerror("Duplicate variable declaration '%s'", (long)name->name,0,0,0,0,0);
			return(val);
		}
		name->type_save = name->type;
		name->val_save = name->val;
		name->loc_save = name->loc;
		name->size_save = name->size;
		name->array_save = name->array;
		name->param_next = param_list;
		param_list = name;
	} else
	if (name->loc != LOC_UNKNOWN) {
		yyerror("Duplicate variable declaration '%s'", (long)name->name,0,0,0,0,0);
		return(val);
	}
	name->size = size;
	name->type = type;
	name->array = array;
	name->loc = loc;
	s = SIZE_TYPE(type);
	if (loc == LOC_GLOBAL) {
		name->val = global_base;
		global_base += size*s;
	} else 
	if (loc == LOC_LOCAL) {
		name->val = val;
	} 
	return(val+s*size);
}

void
dec_const(struct dict *name, struct OP *p)
{
	if (p == NULL || name == NULL)
		return;
	if (name->loc != LOC_UNKNOWN) {
		yyerror("Duplicate variable declaration '%s'", (long)name->name,0,0,0,0,0);
		return;
	}
	p = constant(p);
	if (p->op != O_CONST) {
		yyerror("Constant declaration not constant '%s'", (long)name->name,0,0,0,0,0);
		return;
	}
	name->loc = LOC_CONST;
	name->type = TYPE_WORD;
	name->val = p->o.c.val;
}


void
do_print_str(struct OP *p)
{
	p = types(constant(p), TYPE_CHAR_IND);
	empty_stack();
	exp(p);
	out(P_PSTR);
	tree_free(p);
}

void
do_print_val(struct OP *p)
{
	if (debug)
		tree_print("pval1", p, 0);
	p = types(constant(p), TYPE_UNKNOWN);
	if (debug)
		tree_print("pval2", p, 0);
	empty_stack();
	if (p->op == O_CONST)
		p->tp = TYPE_LONG;
	exp(p);
	if (!LONG_TYPE(p->tp)) 
		out(UNSIGNED_TYPE(p->tp) ? P_WIDENU : P_WIDEN);
	out(UNSIGNED_TYPE(p->tp)?P_PVALU: P_PVAL);
	tree_free(p);
}

void
do_print_chr(struct OP *p)
{
	p = types(constant(p), TYPE_WORD);
	empty_stack();
	exp(p);
	out(P_PCHR);
	tree_free(p);
}

void
do_print_hex(struct OP *p)
{
	if (debug)
		tree_print("hex1", p, 0);
	p = constant(p);
	if (debug)
		tree_print("hex1a", p, 0);
	p = types(p, TYPE_UNKNOWN);
	if (debug)
		tree_print("hex2", p, 0);
	empty_stack();
	exp(p);
	out(LONG_TYPE(p->tp)?P_PHEXL: P_PHEX);
	tree_free(p);
}

void
do_found_launch()
{
	out(P_FOUND_LAUNCH);
}

void
do_fire(struct OP *p)
{
	p = types(constant(p), TYPE_WORD);
	empty_stack();
	exp(p);
	out(P_FIRE);
	tree_free(p);
}

void
do_arm(struct OP *p)
{
	p = types(constant(p), TYPE_WORD);
	empty_stack();
	exp(p);
	out(P_ARM);
	tree_free(p);
}

void
do_safe(struct OP *p)
{
	p = types(constant(p), TYPE_WORD);
	empty_stack();
	exp(p);
	out(P_SAFE);
	tree_free(p);
}

void
do_beep(struct OP *p)
{
	p = types(constant(p), TYPE_WORD);
	empty_stack();
	exp(p);
	out(P_BEEP);
	tree_free(p);
}

void
do_log(struct OP *p1, struct OP *p2)
{
	static struct dict *log_dp = NULL;

	need_log = 1;
	if (log_dp == NULL) {
		log_dp = find_name("___log");
		if (log_dp == NULL) {
			log_dp = add_name("___log");
			forward_proc(TYPE_WORD, log_dp);
		}
	}
	do_exp(build2(O_CALL, (struct OP *)yyline,
			build1(O_STAR, (struct OP *)yyline, build_name(log_dp)),
			build2(O_PLIST, (struct OP *)yyline, p1, p2)));
}

void
do_set_log_full(struct OP *p1)
{
	empty_stack();
	p1 = types(constant(p1), TYPE_WORD);
	exp(p1);
	out(P_SET_LOG_FULL);
	tree_free(p1);
}

void
do_set(struct OP *p1, struct OP *p2)
{
	p2 = types(constant(p2), TYPE_WORD);
	empty_stack();
	exp(p2);
	p1 = types(constant(p1), TYPE_WORD);
	exp(p1);
	out(P_SET);
	tree_free(p1);
	tree_free(p2);
}

void
do_log_ctl(struct OP *p1, struct OP *p2)
{
	static struct dict *log_ctl_dp = NULL;
	need_log = 1;
	if (log_ctl_dp == NULL) {
		log_ctl_dp = find_name("___log_ctl");
		if (log_ctl_dp == NULL) {
			log_ctl_dp = add_name("___log_ctl");
			forward_proc(TYPE_WORD, log_ctl_dp);
		}
	}
	do_exp(build2(O_CALL, (struct OP *)yyline,
			build1(O_STAR, (struct OP *)yyline, build_name(log_ctl_dp)),
			build2(O_PLIST, (struct OP *)yyline, p1, p2)));
}

void
do_eesave(struct OP *p1, struct OP *p2, struct OP *p3)
{
	p3 = types(constant(p3), TYPE_CHAR_IND);
	empty_stack();
	exp(p3);
	p2 = types(constant(p2), TYPE_CHAR_IND);
	exp(p2);
	p1 = types(constant(p1), TYPE_WORD);
	exp(p1);
	out(P_EESAVE);
	tree_free(p1);
	tree_free(p2);
	tree_free(p3);
}

void
do_eeload(struct OP *p1, struct OP *p2, struct OP *p3)
{
	p3 = types(constant(p3), TYPE_CHAR_IND);
	empty_stack();
	exp(p3);
	p2 = types(constant(p2), TYPE_CHAR_IND);
	exp(p2);
	p1 = types(constant(p1), TYPE_WORD);
	exp(p1);
	out(P_EELOAD);
	tree_free(p1);
	tree_free(p2);
	tree_free(p3);
}

void 
do_halt()
{
	out(P_HALT);
}
