struct code_hdr {
		unsigned 	char	magic;		// always 0xc5
		unsigned 	char	cmd;		// 0 - do nothing, just load
							// 1 - run
							// 2 - save
		unsigned	char	dest;		// save set to save in
		unsigned	char	code_size[2];	// number of bytes of code
		unsigned	char	string_size[2];	// number of bytes of strings
		unsigned	char	global_size[2];	// number of bytes of globals
		unsigned	char	stack_size[2];	// number of bytes of stack
};

#define MAGIC	0xc5

#define	P_HALT		0		// halt
#define	P_UBYTE_L	1		// load a local unsigned byte
#define	P_UBYTE_G	2		// load a global unsigned byte
#define	P_J_NE		3		// jump if TOS ne 0 
#define	P_J_EQ		4		// jump if TOS eq 0 
#define	P_GE		5		// tos is replaced with truth value for tos-1 >= tos
#define	P_GT		6		// tos is replaced with truth value for tos-1 > tos
#define	P_LE		7		// tos is replaced with truth value for tos-1 <= tos
#define	P_LT		8		// tos is replaced with truth value for tos-1 < tos
#define	P_NE		9		// tos is replaced with truth value for tos-1 != tos
#define	P_EQ		10		// tos is replaced with truth value for tos-1 == tos
#define	P_NOT		11		// tos is replaced with truth value for tos == 0
#define	P_SUB		12		// tos is replaced with value for tos-1 - tos
#define	P_ADD		13		// tos is replaced with value for tos-1 + tos
#define	P_MUL		14		// tos is replaced with value for tos-1 * tos
#define	P_DIV		15		// tos is replaced with value for tos-1 / tos
#define	P_MOD		16		// tos is replaced with value for tos-1 % tos
#define	P_OR		17		// tos is replaced with value for tos-1 | tos
#define	P_XOR		18		// tos is replaced with value for tos-1 ^ tos
#define	P_AND		19		// tos is replaced with value for tos-1 & tos
#define	P_SHL		20		// tos is replaced with value for tos-1 << tos
#define	P_SHR		21		// tos is replaced with value for tos-1 >> tos
#define	P_JMP		22		// jump unconditionally
#define	P_COMP		23		// tos is replaced with ~tos 1's complement)
#define	P_CALL		24		// call subroutine
#define	P_CALLI		25		// call-indirect subroutine (from TOS - TOS is popped)
#define	P_COPYN		26		// N+1 words are popped from TOS, old TOS is pushed back on
#define	P_CUTN		27		// N words are popped from TOS
#define P_CONST		28		// push a constant value
#define P_ADDR_L	29		// push the address of a local value  (2 byte offset)
#define P_ADDR_G	30		// push the address of a global value  (2 byte offset)
#define P_BYTE_L	31		// push a local byte value  (2 byte offset)
#define P_BYTE_G	32		// push a global byte value  (2 byte offset)
#define P_WORD_L	33		// push a local word value  (2 byte offset)
#define P_WORD_G	34		// push a global word value  (2 byte offset)
#define P_SBYTE_L	35		// store a local byte value  (2 byte offset)
#define P_SBYTE_G	36		// store a global byte value  (2 byte offset)
#define P_SWORD_L	37		// store a local word value  (2 byte offset)
#define P_SWORD_G	38		// store a global word value  (2 byte offset)
#define P_LOAD_B	39		// tos is replaced by byte from indirection of old tos value
#define P_LOAD_W	40		// tos is replaced by word from indirection of old tos value
#define P_DUP		41		// duplicate top of stack
#define P_STORE_B	42		// *tos = tos-1 (byte) tos/tos-1 are discarded
#define P_STORE_W	43		// *tos = tos-1 (word) tos/tos-1 are discarded
#define P_ADDR_P	44		// push the address of a code address (relative) (2 byte offset)
#define	P_ZERO		45		// pushes 0
#define	P_ONE		46		// pushes 1
#define	P_ENTER		47		// allocates space for local variables (subtracts sp by 2 byte offset)
#define	P_RET		48		// recovers space for local variables (subtracts sp by 2 byte offset)
#define	P_ADDR_S	49		// push the address of a string (2 byte offset)
#define	P_POLL		50		// call into environment for busy work
#define	P_INTERRUPT	51		// push true if interrupt N has occured (and clear the flag)(2 byte number)
#define	P_SAVE_TIME	52		// saves current time
#define	P_CMP_TIME	53		// pushes true if current time is N > than the last saved one (2 byte constant)
#define	P_INPUT		54		// pushes false if no input char available, and the chare and true it it is
#define	P_OUTPUT	55		// pushes truth value - true if we can send a character without stalling
#define	P_LAUNCH	56		// pushes truth value - true if we have launched
#define	P_ARM		57		// pops tos and passes it to the arming mechanism
#define	P_SAFE		58		// pops tos and passes it to the safing mechanism
#define	P_FIRE		59		// pops tos and uses it to activate a pyro channel
#define	P_TIME		60		// pushes absolute time
#define	P_LTIME		61		// pushes time since launch event
#define	P_SET_LOG_FULL	62		// pops TOS is log full value
#define	P_SET_POLL	63		// pops TOS is log address value
#define	P_BEEP		64		// pops TOS value and uses it to control the beeper (if any)
#define	P_PSTR		65		// pops TOS value and uses it as the address of a string to print
#define	P_PHEX		66		// pops TOS value and uses it as a hex value to print
#define	P_PVAL		67		// pops TOS value and uses it as a decimal value to print
#define	P_PCHR		68		// pops TOS value and uses it as a character value to print
#define	P_EESAVE	69		// pops 3 TOS values saves data to eeprom tos is eeprom address, tos-1 main mem address tos-2 is count
#define	P_EELOAD	70		// pops 3 TOS values loads data from eeprom tos is main mem address, tos-1 eeprom address tos-2 is count
#define	P_GET		71		// get value from external source (tos gives value and is replaced with old one)
#define	P_SET		72		// set value to external source (tos is the value tos-1 points to the source, both are removed)
#define	P_POP		73		// discards the tos
#define	P_GE_L		74
#define	P_GT_L		75
#define	P_LE_L		76
#define	P_LT_L		77
#define	P_NE_L		78
#define	P_EQ_L		79
#define	P_NOT_L		80
#define	P_SUB_L		81
#define	P_ADD_L		82
#define	P_MUL_L		83
#define	P_DIV_L		84
#define	P_MOD_L		85
#define	P_OR_L		86
#define	P_XOR_L		87
#define	P_AND_L		88
#define	P_SHL_L		89
#define	P_SHR_L		90
#define	P_COMP_L	91
#define	P_CONST_L	92
#define	P_LONG_L	93
#define	P_LONG_G	94
#define	P_SLONG_L	95
#define	P_SLONG_G	96
#define	P_LOAD_L	97
#define	P_DUP_L		98
#define	P_STORE_L	99
#define	P_ZERO_L	100
#define	P_ONE_L		101
#define	P_WIDEN		102
#define	P_SHORTEN	103
#define	P_PVALU		104
#define	P_PHEXL		105
#define	P_POP_L		106
#define	P_EQ_C		107
#define	P_EQ_L_C	108
#define	P_ADD_C		109
#define	P_ADD_L_C	110
#define	P_INDEX2	111
#define	P_INDEX4	112
#define	P_LSHORTEN	113
#define	P_RTIME		114
#define	P_LOG_FULL	115
#define	P_LOG_BASE	116
#define	P_LOG_END	117
#define	P_JEQV		118
#define	P_JEQV_L	119
#define	P_JNEV		120
#define	P_JNEV_L	121
#define	P_WIDENU	122
#define	P_LOAD_UB	123
#define	P_FOUND_LAUNCH	124
#define	P_MULU		125
#define	P_DIVU		126
#define	P_MULU_L	127
#define	P_DIVU_L	128
#define	P_GEU		129
#define	P_GEU_L		130
#define	P_GTU		131
#define	P_GTU_L		132
#define	P_LEU		133
#define	P_LEU_L		134
#define	P_LTU		135
#define	P_LTU_L		136
#define	P_SET_TRAMPOLINE	137
#define	P_SET_EXTRA	138
#define	P_STIME		139
