%{
/*
 *      Copyright (c) 1991 Paul Campbell
 *      All Rights Reserved
 *      THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Paul Campbell
 *      The copyright notice above does not evidence any
 *      actual or intended publication of such source code.
 */

#define COMPILER 1
#include <stdio.h>
#include <stdlib.h>
#ifdef MPW
#include <string.h>
#include <osutils.h>
char *alloca (long size);
void bcopy(char *s,char *d,unsigned long l);
#endif
#include "lex.h"
#pragma segment parser
static int the_type;
static int proc_type;
extern unsigned long yyline;
void
yyerror1(char *s)
{
	yyerror(s, 0, 0,0,0,0,0);
}
void
yyerror2(char *s,long a)
{
	yyerror(s, a, 0,0,0,0,0);
}
extern void push_continue_label(struct label *l);
extern void change_continue_label(struct label *l);
extern struct label *pop_continue_label();
extern struct label *continue_label();
extern void push_break_label(struct label *l);
extern struct label *pop_break_label();
extern struct label *break_label();

#define yyerror yyerror1
%}
%token t_pluseq t_minuseq t_andeq t_oreq t_xoreq t_muleq t_modeq t_diveq t_goto
%token t_if t_else t_while t_for t_char t_int t_symbol t_num t_log_full t_sizeof
%token t_andand t_oror t_gtgt t_ltlt t_return t_extern t_string t_set_log_full
%token t_on t_output t_input t_idle t_timeout t_interrupt t_set t_get t_lteq t_gteq
%token t_next t_log t_fire t_arm t_beep t_time t_ltime t_launch t_eesave t_found_launch
%token t_pval t_phex t_pchr t_pstr t_state t_safe t_log_ctl t_eeload t_eqeq t_noteq
%token t_minusminus t_plusplus t_halt t_long t_do t_rtime t_log_base t_log_end t_stime
%token t_break t_unsigned t_union t_void t_struct t_static t_continue t_gtgteq
%token t_case t_switch t_class t_typedef t_register t_default t_enum t_ltlteq
%token t_float t_double
%start	s
%%

s:	
	|	sl sts					{ got_states = 1; }
	|	sl 					{ got_states = 0; }
	|	sts					{ got_states = 1; }
	;
	
sl:		ss
	|	error
	|	sl ss
	;
	
ss:		decs
	|	const
	|	proc
	;

const:		t_symbol '=' exp ';'			{ dec_const((struct dict *)$1, (struct OP *)$3); }
	;
	
decs:		type decl ';'
	;
	
xtype:		t_char					{ the_type = TYPE_CHAR; $$ = O_CHAR; }
	|	t_int					{ the_type = TYPE_WORD; $$ = O_WORD; }
	|	t_long					{ the_type = TYPE_LONG; $$ = O_LONG; }
	;
	
type:		xtype					{ $$ = $1; }
	|	t_unsigned type				{ if (the_type == TYPE_WORD) {
								the_type = TYPE_UWORD;
								$$ = O_UWORD;
							  } else
							  if (the_type == TYPE_CHAR) {
								the_type = TYPE_UCHAR;
								$$ = O_UCHAR;
							  } else {
								the_type = TYPE_ULONG;
								$$ = O_ULONG;
							  } }
	;
	
ttype:		type					{ $$ = $1; }
	|	type '*'				{ if ($1 == O_UCHAR) {
								the_type = TYPE_UCHAR_IND; $$ = O_UCHAR_IND;
							  } else 
							  if ($1 == O_ULONG) {
								the_type = TYPE_ULONG_IND; $$ = O_ULONG_IND;
							  } else
							  if ($1 == O_UWORD) {
								the_type = TYPE_UWORD_IND; $$ = O_UWORD_IND;
							  } else
							  if ($1 == O_CHAR) {
								the_type = TYPE_CHAR_IND; $$ = O_CHAR_IND;
							  } else 
							  if ($1 == O_LONG) {
								the_type = TYPE_LONG_IND; $$ = O_LONG_IND;
							  } else {
								the_type = TYPE_WORD_IND; $$ = O_WORD_IND;
							  }}
	;

decl:		dec
	|	decl ',' dec
	;
	

dec:		t_symbol				{ (void)declare(the_type, (struct dict *)$1, 1,  0, LOC_GLOBAL, 0); }
	|	t_symbol '[' t_num ']'			{ (void)declare(the_type, (struct dict *)$1, $3, 1, LOC_GLOBAL, 0); }
	|	'*' t_symbol '[' t_num ']'		{ (void)declare(the_type+TYPE_INC, (struct dict *)$2, $4,  1, LOC_GLOBAL, 0); }
	|	'*' t_symbol				{ (void)declare(the_type+TYPE_INC, (struct dict *)$2, 1,  0, LOC_GLOBAL, 0); }
	;
	
proc:				  t_symbol '(' plist_e ')' '{' {proc_type = TYPE_WORD; }
					pdec 		{ enter_proc(proc_type, (struct dict *)$1, (struct OP *)$3, (struct OP *)$7); }
					slist		{ exit_proc(); }
				  '}'
	|	t_void	 	  t_symbol '(' plist_e ')' '{' {proc_type = TYPE_WORD;}
					pdec		{ enter_proc(proc_type, (struct dict *)$2, (struct OP *)$4, (struct OP *)$8); }
					slist		{ exit_proc(); }
				  '}'
	|	type	 	  t_symbol '(' plist_e ')' '{' {proc_type = the_type;}
					pdec		{ enter_proc(proc_type, (struct dict *)$2, (struct OP *)$4, (struct OP *)$8); }	
					slist		{ exit_proc(); }
				  '}'
	|	type	'*'	  t_symbol '(' plist_e ')' '{' {proc_type = the_type+TYPE_INC;}
					pdec		{ enter_proc(proc_type, (struct dict *)$3, (struct OP *)$5, (struct OP *)$9); }
					slist		{ exit_proc(); }
				  '}'
	|	t_extern	  t_symbol '('  ')' ';'	{ forward_proc(TYPE_WORD, (struct dict *)$2); }
	|	t_extern t_void	  t_symbol '('  ')' ';'	{ forward_proc(TYPE_WORD,  (struct dict *)$3); }	
	|	t_extern type	  t_symbol '('  ')' ';'	{ forward_proc(the_type,  (struct dict *)$3); }	
	|	t_extern type '*' t_symbol '('  ')' ';'	{ forward_proc(the_type+TYPE_INC,  (struct dict *)$4); }	
	;

pdec:							{ $$ = NULL; }
	|	dlist					{ $$ = $1; }
	;

dlist:		ldec ';'				{ $$ = $1; }
	|	dlist ldec ';' 				{ $$ = (long)build2(O_LIST, (struct OP *)$3, (struct OP *)$1, (struct OP *)$2); }
	;

ldec:		type  nlist				{ $$ = (long)build1($1, (struct OP *)yyline, (struct OP *)$2); }
	;

nlist:		n					{ $$ = $1; }
	|	nlist ',' n				{ $$ = (long)build2(O_LIST, (struct OP *)$2, (struct OP *)$1, (struct OP *)$3);}
	;
n:		t_symbol				{ $$ = (long)build_name((struct dict *)$1); }
	|	'*' t_symbol				{ $$ = (long)build1(O_STAR, (struct OP *)$1, build_name((struct dict *)$2)); }
	|	t_symbol '[' t_num ']'			{ $$ = (long)build2(O_INDEX, (struct OP *)$2, build_name((struct dict *)$1), make_constant($1)); }
	;

plist_e:						{ $$ = NULL; }
	|	plist					{ $$ = $1; }
	;
	
plist:		p					{ $$ = $1; }
	|	p ',' plist				{ $$ = (long)build2(O_LIST, (struct OP *)$2, (struct OP *)$1, (struct OP *)$3); }
	;
	
p:		type t_symbol				{ $$ = (long)build1((unsigned short)$1, (struct OP *)yyline, (struct OP *)build_name((struct dict *)$2)); }
	|	type '*' t_symbol			{ $$ = (long)build1((unsigned short)$1, (struct OP *)yyline, build1(O_STAR, (struct OP *)$2, build_name((struct dict *)$3))); }
	|	type t_symbol '[' t_num ']'		{ $$ = (long)build1((unsigned short)$1, (struct OP *)$3, 
								build2(O_INDEX, (struct OP *)$3, build_name((struct dict *)$2), make_constant($4))); }
	;
	
statement:	';'					{ $$ = 0; }
	|	t_break ';'				{ do_uncond(break_label()); }
	|	t_continue ';'				{ do_uncond(continue_label()); }
	|	t_halt ';'				{ do_halt(); }
	|	t_fire '(' exp ')' ';'			{ do_fire((struct OP *)$3); $$ = 1; }
	|	t_arm '(' exp ')' ';'			{ do_arm((struct OP *)$3); $$ = 1; }
	|	t_safe '(' exp ')' ';'			{ do_safe((struct OP *)$3); $$ = 1; }
	|	t_beep '(' exp ')' ';'			{ do_beep((struct OP *)$3); $$ = 1; }
	|	t_log '(' exp ',' exp ')' ';'		{ do_log((struct OP *)$3, (struct OP *)$5); $$ = 1; }
	|	t_log_ctl '(' exp ',' exp ')' ';'	{ do_log_ctl((struct OP *)$3, (struct OP *)$5); $$ = 1; }
	|	t_set_log_full '(' exp ')' ';'		{ do_set_log_full((struct OP *)$3); $$ = 1; }
	|	t_set '(' exp ',' exp ')' ';'		{ do_set((struct OP *)$3, (struct OP *)$5); $$ = 1; }
	| 	t_eesave '(' exp ',' exp ',' exp ')' ';'{ do_eesave((struct OP *)$3, (struct OP *)$5, (struct OP *)$7); $$ = 1; }
	| 	t_eeload '(' exp ',' exp ',' exp ')' ';'{ do_eeload((struct OP *)$3, (struct OP *)$5, (struct OP *)$7); $$ = 1; }
	|	t_pstr '(' exp ')' ';'			{ do_print_str((struct OP *)$3); $$ = 1; }
	|	t_pval '(' exp ')' ';'			{ do_print_val((struct OP *)$3); $$ = 1; }
	|	t_pchr '(' exp ')' ';'			{ do_print_chr((struct OP *)$3); $$ = 1; }
	|	t_phex '(' exp ')' ';'			{ do_print_hex((struct OP *)$3); $$ = 1; }
	|	t_found_launch '(' ')' ';'		{ do_found_launch(); $$ = 1; }
	|	assignx ';'				{ $$ = 1; }						
	|	'{' slist '}'				{ $$ = 1; }
	|	t_next t_symbol ';'			{ next_state((struct dict *)$2); }
	|	t_return ';'				{ do_return(NULL); $$ = 1; }					
	|	t_return exp ';'			{ do_return((struct OP *)$2); $$ = 1; }					
	|	t_if I2 '(' exp ')' I3
			statement			{ use_label((struct label *)$2); $$ = 1; }
	|	t_if I2 '(' exp ')' I3
			statement 
			t_else 	I2			{ do_uncond((struct label *)$9); use_label((struct label *)$2); }
			statement			{ use_label((struct label *)$9); $$ = 1; }
	
	|  	t_while I1b '(' exp ')' I2		{ do_cond(0, (struct OP *)$4, (struct label *)$6); }
			statement			{ do_uncond((struct label *)$2); use_label((struct label *)$6); use_label(pop_break_label());$$ = 1; }
	|	t_do I1b
			statement
		t_while '(' exp ')'			{ do_cond(1, (struct OP *)$6, (struct label *)$2); use_label(pop_break_label()); }
								
	|	t_for '(' statement   I1a
			exp_e ';' I2 I2			{ if ($5) { do_cond(1, (struct OP *)$5, (struct label *)$7); do_uncond((struct label *)$8);} else { do_uncond((struct label *)$7);} }
			I1  assign_e ')' 		{ if ($11) change_continue_label((struct label *)$10); if ($5) do_uncond((struct label *)$4); use_label((struct label *)$7); }
			statement			{ if ($5 && $11 == NULL) { do_uncond((struct label *)$4); } else { do_uncond((struct label *)$10); } use_label((struct label *)$8); use_label(pop_break_label());(void)pop_continue_label();$$ = 1; }
	|	t_switch  '(' exp ')' '{'		{ push_break_label(new_label()); start_case((struct OP *)$3); }
		case_list
		'}'					{ end_case(); use_label(pop_break_label()); }
	;
	
I1:							{ $$ = (long)new_label(); use_label((struct label *)$$); }
	;
I1a:							{ $$ = (long)new_label(); use_label((struct label *)$$); push_continue_label((struct label *)$$); push_break_label(new_label());}
	;
I1b:							{ $$ = (long)new_label(); use_label((struct label *)$$); push_break_label(new_label());}
	;
I2:							{ $$ = (long)new_label(); }
	;
I3:							{ do_cond(0, (struct OP *)$-1, (struct label *)$-3); }
	;

case_list:	cases
	|	case_list cases
	;

cases:		t_default { set_default(); } ':' slist_e
	|	{case_begin();} case					
	;

case:		t_case exp ':' {emit_case((struct OP *)$2, 1); } case	
	|	t_case exp ':' {emit_case((struct OP *)$2, 0); } slist	
	;

sts:		state
	|	sts state
	;
	
state:		t_state t_symbol			{ start_state((struct dict *)$2); }
			':' slist_e			{ mid_state(); }
			 event_list_e			{ end_state(); }
	;

slist_e:
	|	slist
	;
	
event_list_e:						{ end_halt(); }
	|	event_list
	;

event_list:	event
	|	event_list event
	;
	
event:		t_on ev ':' slist			{ end_event(); }
	;
	
ev:		t_output				{ event_output(); }
	|	t_idle					{ event_idle(); }
	|	t_log_full				{ event_log_full(); }
	|	t_launch				{ event_launch(); need_launch = 1;}
	|	t_input t_symbol			{ event_input((struct dict *)$2); }
	|	t_timeout exp				{ event_timeout((struct OP *)$2); }
	|	exp					{ event_exp((struct OP *)$1); }
	|	t_interrupt t_num			{ event_int($1); }
	;
	
assign_e:						{ $$ = 0; }
	|	assignx					{ $$ = 1; }
	;
assignx:	assign
	|	assign ',' assignx
	;

mult:		t_pluseq 				{ $$ = O_ADD; }
	|	t_minuseq 				{ $$ = O_SUB; }
	|	t_diveq 				{ $$ = O_SUB; }
	|	t_muleq 				{ $$ = O_SUB; }
	|	t_modeq 				{ $$ = O_MOD; }
	|	t_xoreq 				{ $$ = O_XOR; }
	|	t_oreq  				{ $$ = O_OR; }
	|	t_andeq 				{ $$ = O_AND; }
	|	t_gtgteq 				{ $$ = O_GTGT; }
	|	t_ltlteq 				{ $$ = O_LTLT; }
	;

ainc:		t_plusplus				{ $$ = O_ADD; }
	|	t_minusminus				{ $$ = O_SUB; }
	;
		
	
assign:		exp '=' exp			{ $$ = (long)build2(O_ASSIGN, (struct OP *)$2, (struct OP *)$1, (struct OP *)$3);
							  do_assign((struct OP *)$$);}
	|	exp mult exp			{ $$ = (long)build2(O_ASSIGN, (struct OP *)yyline, dup_tree((struct OP *)$1), build2($2, (struct OP *)yyline, (struct OP *)$1, (struct OP *)$3));
							  do_assign((struct OP *)$$);}
	|	exp					{ do_exp((struct OP *)$1); }
	;
	
exp_e:							{ $$ = NULL; }
	|	exp					{ $$ = $1; }
	;
	
elist_e:						{ $$ = NULL; }
	|	elist					{ $$ = $1; }
	;
	
elist:		exp					{ $$ = $1; }
	|	exp ',' elist				{ $$ = (long)build2(O_PLIST, (struct OP *)$2, (struct OP *)$1, (struct OP *)$3);}
	;
	
slist:		statement
	|	slist statement
	;

exp:		e0 '?' exp ':' exp			{ $$ = (long)build3(O_CHOOSE, (struct OP *)$2, (struct OP *)$1, (struct OP *)$3, (struct OP *)$5); }
	|	e0					{ $$ = $1; }
	;
	
e0:		e1 t_oror e0				{ $$ = (long)build2(O_OROR, (struct OP *)$2, (struct OP *)$1, (struct OP *)$3);}
	|	e1					{ $$ = $1; }
	;

e1:		e2 t_andand e1				{ $$ = (long)build2(O_ANDAND, (struct OP *)$2, (struct OP *)$1, (struct OP *)$3);}
	|	e2					{ $$ = $1; }
	;


e2:		e2 '<' e3				{ $$ = (long)build2(O_LT, (struct OP *)$2, (struct OP *)$1, (struct OP *)$3);}
	|	e2 t_lteq e3				{ $$ = (long)build2(O_LE, (struct OP *)$2, (struct OP *)$1, (struct OP *)$3);}
	|	e2 '>' e3				{ $$ = (long)build2(O_GT, (struct OP *)$2, (struct OP *)$1, (struct OP *)$3);}
	|	e2 t_gteq e3				{ $$ = (long)build2(O_GE, (struct OP *)$2, (struct OP *)$1, (struct OP *)$3);}
	|	e2 t_noteq e3				{ $$ = (long)build2(O_NE, (struct OP *)$2, (struct OP *)$1, (struct OP *)$3);}
	|	e2 t_eqeq e3				{ $$ = (long)build2(O_EQ, (struct OP *)$2, (struct OP *)$1, (struct OP *)$3);}
	|	e3					{ $$ = $1; }
	;

e3:		e4 '|' e3				{ $$ = (long)build2(O_OR, (struct OP *)$2, (struct OP *)$1, (struct OP *)$3);}
	|	e4					{ $$ = $1; }
	;

e4:		e5 '&' e4				{ $$ = (long)build2(O_AND, (struct OP *)$2, (struct OP *)$1, (struct OP *)$3);}
	|	e5					{ $$ = $1; }
	;

e5:		e6 '^' e5				{ $$ = (long)build2(O_XOR, (struct OP *)$2, (struct OP *)$1, (struct OP *)$3);}
	|	e6					{ $$ = $1; }
	;

e6:		e7 t_ltlt e6				{ $$ = (long)build2(O_LTLT, (struct OP *)$2, (struct OP *)$1, (struct OP *)$3);}
	|	e7 t_gtgt e6				{ $$ = (long)build2(O_GTGT, (struct OP *)$2, (struct OP *)$1, (struct OP *)$3);}
	|	e7					{ $$ = $1; }
	;

e7:		e7 '+' e8				{ $$ = (long)build2(O_ADD, (struct OP *)$2, (struct OP *)$1, (struct OP *)$3);}
	|	e7 '-' e8				{ $$ = (long)build2(O_SUB, (struct OP *)$2, (struct OP *)$1, (struct OP *)$3);}
	|	e8					{ $$ = $1; }
	;

e8:		e8 '*' e9				{ $$ = (long)build2(O_MUL, (struct OP *)$2, (struct OP *)$1, (struct OP *)$3);}
	|	e8 '/' e9				{ $$ = (long)build2(O_DIV, (struct OP *)$2, (struct OP *)$1, (struct OP *)$3);}
	|	e8 '%' e9				{ $$ = (long)build2(O_MOD, (struct OP *)$2, (struct OP *)$1, (struct OP *)$3);}
	|	e9					{ $$ = $1; }
	;

e9:		e10					{ $$ = $1; }
	|	'+' e9					{ $$ = $2; }
	|	'!' e9					{ $$ = (long)build1(O_NOT, (struct OP *)$1, (struct OP *)$2);}
	|	'-' e9					{ $$ = (long)build1(O_MINUS, (struct OP *)$1, (struct OP *)$2);}
	|	'~' e9					{ $$ = (long)build1(O_TILDE, (struct OP *)$1, (struct OP *)$2);}
	|	'*' e9					{ $$ = (long)build1(O_STAR, (struct OP *)$1, (struct OP *)$2);}
	|	cast e9				{ $$ = (long)build1((short)$1, (struct OP *)yyline, (struct OP *)$2);}	
	|	'&' e9					{ $$ = (long)build1(O_ADDR, (struct OP *)$1, (struct OP *)$2); }
	;

e10:		e11 '(' elist_e ')'			{ $$ = (long)build2(O_CALLV, (struct OP *)$2, (struct OP *)$1, (struct OP *)$3); }
	|	e11 '[' exp ']'				{ $$ = (long)build2(O_INDEX, (struct OP *)$2, (struct OP *)$1, (struct OP *)$3); }
	|	e11					{ $$ = $1; }
	;


e11:		'(' exp ')'				{ $$ = $2; }
	|	t_symbol ainc				{ $$ = (long)build1(($2==O_ADD?O_STAR_INC:O_STAR_DEC), (struct OP *)yyline, build_name((struct dict *)$1)); }
	|	ainc t_symbol 				{ $$ = (long)build1(($1==O_ADD?O_STAR_INC_P:O_STAR_DEC_P), (struct OP *)yyline, build_name((struct dict *)$2)); }
	|	t_get '(' exp ')'			{ $$ = (long)build1(O_GET, (struct OP *)$1, (struct OP *)$3);}
	|	t_symbol				{ $$ = (long)build1(O_STAR, (struct OP *)yyline, build_name((struct dict *)$1)); }
	|	t_num					{ $$ = (long)make_constant($1); }
	|	t_time					{ $$ = (long)build0(O_TIME, (struct OP *)$1); }
	|	t_ltime					{ $$ = (long)build0(O_LTIME, (struct OP *)$1); }
	|	t_rtime					{ $$ = (long)build0(O_RTIME, (struct OP *)$1); }
	|	t_stime					{ $$ = (long)build0(O_STIME, (struct OP *)$1); }
	|	t_log_base				{ $$ = (long)build0(O_LOG_BASE, (struct OP *)$1); }
	|	t_log_end				{ $$ = (long)build0(O_LOG_END, (struct OP *)$1); }
	|	t_string				{ $$ = $1; }
	|	t_sizeof '(' exp ')'			{ $$ = (long)build1(O_SIZEOF, (struct OP *)$1, (struct OP *)$3);}
	|	t_sizeof '(' ttype ')'			{ if (LONG_TYPE($3)) {
								$$ = (long)make_constant(4);
							  } else
							  if (CHAR_TYPE($3)) {
								$$ = (long)make_constant(1);
							  } else {
								$$ = (long)make_constant(4);
							  }}
							
	| 	error					{ $$ = NULL; }
	;

cast:		'(' ttype ')'				{ $$ = $2; }
	;
	
