/*
 *      Copyright (c) 1991 Paul Campbell
 *      All Rights Reserved
 *      THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Paul Campbell
 *      The copyright notice above does not evidence any
 *      actual or intended publication of such source code.
 */
#define COMPILER 1
#pragma segment exp
#include <stdio.h>
#include <stdlib.h>
#include "lex.h"

extern FILE *fcode;

extern struct OP *make_constant();
extern struct OP *build1();
extern struct OP *build2();

struct OP *
constant(struct OP *p)
{
	struct OP *pp;
	
	if (yyerrcount)
		return(p);
	if (p == NULL)
		return(p);
	switch (p->op) {
	case O_SIZEOF:	
		p->op1 = types(constant(p->op1), TYPE_UNKNOWN);
		if (p->op1 == NULL)
			return(p);
		if (p->op1->op1->op == O_STAR &&
		    p->op1->op1->op1->op == O_NAME &&
		    p->op1->op1->op1->o.n.d->array) {
			pp = make_constant(p->op1->op1->op1->o.n.d->size*
					SIZE_TYPE(p->op1->op1->op1->o.n.d->type));
		} else {
			pp = make_constant(SIZE_TYPE(p->op1->tp));
		}
		tree_free(p);
		p = pp;
		break;
	case O_ASSIGN:
		p->op1 = constant(p->op1);
		p->op2 = constant(p->op2);
		if (p && p->op1->op != O_STAR && p->op1->op != O_INDEX) {
			//tree_print("assign - const", p, 0);
			yyerror("Invalid LHS of assignment",0,0,0,0,0,0);
		}
		break;
	case O_OROR:
		p->op1 = constant(p->op1);
		p->op2 = constant(p->op2);
		if (p->op1->op == O_CONST) {
			if (p->op1->o.c.val != 0) {
				pp = p->op1;
				tree_free(p->op2);
				free(p);
				p = pp;
			} else {
				pp = p->op2;
				free(p->op1);
				free(p);
				p = pp;
			}
		} else
		if (p->op2->op == O_CONST) {
			if (p->op2->o.c.val == 0) {
				pp = p->op1;
				free(p->op2);
				free(p);
				p = pp;
			}
		}
		break;
	case O_ANDAND:
		p->op1 = constant(p->op1);
		p->op2 = constant(p->op2);
		if (p->op1->op == O_CONST) {
			if (p->op1->o.c.val == 0) {
				pp = p->op1;
				tree_free(p->op2);
				free(p);
				p = pp;
			} else {
				pp = p->op2;
				free(p->op1);
				free(p);
				p = pp;
			}
		} else
		if (p->op2->op == O_CONST) {
			if (p->op2->o.c.val != 0) {
				pp = p->op1;
				free(p->op2);
				free(p);
				p = pp;
			}
		}
		break;
	case O_CHOOSE:
		p->op1 = constant(p->op1);
		p->op2 = constant(p->op2);
		p->op3 = constant(p->op3);
		if (p->op1->op == O_CONST) {
			if (p->op1->o.c.val) {
				pp = p->op2;
				tree_free(p->op3);
			} else {
				pp = p->op1;
				tree_free(p->op2);
			}
			p->op2 = NULL;
			p->op3 = NULL;
			tree_free(p);
			p = pp;
		}
		break;
	case O_LT:
		p->op1 = constant(p->op1);
		p->op2 = constant(p->op2);
		if (p->op1->op == O_CONST && p->op2->op == O_CONST) {
			p->op1->o.c.val = p->op1->o.c.val < p->op2->o.c.val;
			pp = p->op1;
			free(p->op2);
			free(p);
			p = pp;
		}
		break;
	case O_LE:
		p->op1 = constant(p->op1);
		p->op2 = constant(p->op2);
		if (p->op1->op == O_CONST && p->op2->op == O_CONST) {
			p->op1->o.c.val = p->op1->o.c.val <= p->op2->o.c.val;
			pp = p->op1;
			free(p->op2);
			free(p);
			p = pp;
		}
		break;
	case O_GT:
		p->op1 = constant(p->op1);
		p->op2 = constant(p->op2);
		if (p->op1->op == O_CONST && p->op2->op == O_CONST) {
			p->op1->o.c.val = p->op1->o.c.val > p->op2->o.c.val;
			pp = p->op1;
			free(p->op2);
			free(p);
			p = pp;
		}
		break;
	case O_GE:
		p->op1 = constant(p->op1);
		p->op2 = constant(p->op2);
		if (p->op1->op == O_CONST && p->op2->op == O_CONST) {
			p->op1->o.c.val = p->op1->o.c.val >= p->op2->o.c.val;
			pp = p->op1;
			free(p->op2);
			free(p);
			p = pp;
		}
		break;
	case O_NE:
		p->op1 = constant(p->op1);
		p->op2 = constant(p->op2);
		if (p->op1->op == O_CONST && p->op2->op == O_CONST) {
			p->op1->o.c.val = p->op1->o.c.val != p->op2->o.c.val;
			pp = p->op1;
			free(p->op2);
			free(p);
			p = pp;
		}
		break;
	case O_EQ:
		p->op1 = constant(p->op1);
		p->op2 = constant(p->op2);
		if (p->op1->op == O_CONST && p->op2->op == O_CONST) {
			p->op1->o.c.val = p->op1->o.c.val == p->op2->o.c.val;
			pp = p->op1;
			free(p->op2);
			free(p);
			p = pp;
		}
		break;
	case O_OR:
		p->op1 = constant(p->op1);
		p->op2 = constant(p->op2);
		if (p->op1->op == O_CONST) {
			if (p->op2->op == O_CONST) {
				p->op1->o.c.val = p->op1->o.c.val | p->op2->o.c.val;
				pp = p->op1;
				free(p->op2);
				free(p);
				p = pp;
			} else
			if (p->op1->o.c.val == 0) {
				pp = p->op2;
				free(p->op1);
				free(p);
			}
		} else 
		if (p->op2->op == O_CONST) {
			if (p->op2->o.c.val == 0) {
				pp = p->op1;
				free(p->op2);
				free(p);
			}
		}
		break;
	case O_AND:
		p->op1 = constant(p->op1);
		p->op2 = constant(p->op2);
		if (p->op1->op == O_CONST) {
			if (p->op2->op == O_CONST) {
				p->op1->o.c.val = p->op1->o.c.val & p->op2->o.c.val;
				pp = p->op1;
				free(p->op2);
				free(p);
				p = pp;
			}
		} 
		break;
	case O_XOR:
		p->op1 = constant(p->op1);
		p->op2 = constant(p->op2);
		if (p->op1->op == O_CONST) {
			if (p->op2->op == O_CONST) {
				p->op1->o.c.val = p->op1->o.c.val ^ p->op2->o.c.val;
				pp = p->op1;
				free(p->op2);
				free(p);
				p = pp;
			} else
			if (p->op1->o.c.val == 0) {
				pp = p->op2;
				free(p->op1);
				free(p);
				p = pp;
			}
		} else 
		if (p->op2->op == O_CONST) {
			if (p->op2->o.c.val == 0) {
				pp = p->op1;
				free(p->op2);
				free(p);
				p = pp;
			}
		}
		break;
	case O_LTLT:
		p->op1 = constant(p->op1);
		p->op2 = constant(p->op2);
		if (p->op1->op == O_CONST) {
			if (p->op1->o.c.val == 0) {
				pp = p->op1;
				tree_free(p->op2);
				free(p);
				p = pp;
			} else
			if (p->op2->op == O_CONST) {
				p->op1->o.c.val = p->op1->o.c.val << p->op2->o.c.val;
				pp = p->op1;
				free(p->op2);
				free(p);
				p = pp;
			} 
		} else 
		if (p->op2->op == O_CONST) {
			if (p->op2->o.c.val == 0) {
				pp = p->op1;
				tree_free(p->op2);
				free(p);
				p = pp;
			} else
			if (p->op2->o.c.val < 0) {
				yywarnline(p->line, "<< by negative number",0,0,0,0,0,0);
			}
		}
		break;
	case O_GTGT:
		p->op1 = constant(p->op1);
		p->op2 = constant(p->op2);
		if (p->op1->op == O_CONST) {
			if (p->op1->o.c.val == 0) {
				pp = p->op1;
				tree_free(p->op2);
				free(p);
				p = pp;
			} else
			if (p->op2->op == O_CONST) {
				p->op1->o.c.val = p->op1->o.c.val >> p->op2->o.c.val;
				pp = p->op1;
				free(p->op2);
				free(p);
				p = pp;
			} 
		} else 
		if (p->op2->op == O_CONST) {
			if (p->op2->o.c.val == 0) {
				pp = p->op1;
				tree_free(p->op2);
				free(p);
				p = pp;
			} else
			if (p->op2->o.c.val < 0) {
				yywarnline(p->line, ">> by negative number",0,0,0,0,0,0);
			}
		}
		break;
	case O_ADD:
		//tree_print("add - const", p, 0);
		p->op1 = constant(p->op1);
		p->op2 = constant(p->op2);
		if (p->op1->op == O_CONST) {
			if (p->op1->o.c.val == 0) {
				pp = p->op2;
				free(p->op1);
				free(p);
				p = pp;
			} else
			if (p->op2->op == O_CONST) {
				p->op1->o.c.val = p->op1->o.c.val + p->op2->o.c.val;
				pp = p->op1;
				free(p->op2);
				free(p);
				p = pp;
			} 
		} else 
		if (p->op2->op == O_CONST) {
			if (p->op2->o.c.val == 0) {
				pp = p->op1;
				free(p->op2);
				free(p);
				p = pp;
			}
		}
		break;
	case O_SUB:
		p->op1 = constant(p->op1);
		p->op2 = constant(p->op2);
		if (p->op1->op == O_CONST) {
			if (p->op2->op == O_CONST) {
				p->op1->o.c.val = p->op1->o.c.val - p->op2->o.c.val;
				pp = p->op1;
				free(p->op2);
				free(p);
				p = pp;
			} 
		} else 
		if (p->op2->op == O_CONST) {
			if (p->op2->o.c.val == 0) {
				pp = p->op1;
				free(p->op2);
				free(p);
				p = pp;
			}
		}
		break;
	case O_MUL:
		p->op1 = constant(p->op1);
		p->op2 = constant(p->op2);
		if (p->op1->op == O_CONST) {
			if (p->op2->op == O_CONST) {
				p->op1->o.c.val = p->op1->o.c.val * p->op2->o.c.val;
				pp = p->op1;
				free(p->op2);
				free(p);
				p = pp;
			} else 
			if (p->op1->o.c.val == 0) {
				pp = p->op1;
				tree_free(p->op2);
				free(p);
				p = pp;
			} else
			if (p->op1->o.c.val == 1) {
				pp = p->op2;
				free(p->op1);
				free(p);
				p = pp;
			} else
			if (p->op1->o.c.val == 2) {
				p->op1->o.c.val = 1;
				p->op = O_LTLT;
				pp = p->op2;
				p->op2 = p->op1;
				p->op1 = pp;
				p = constant(p);
			} else
			if (p->op1->o.c.val == 4) {
				p->op1->o.c.val = 2;
				p->op = O_LTLT;
				pp = p->op2;
				p->op2 = p->op1;
				p->op1 = pp;
				p = constant(p);
			} else
			if (p->op1->o.c.val == 8) {
				p->op1->o.c.val = 3;
				p->op = O_LTLT;
				pp = p->op2;
				p->op2 = p->op1;
				p->op1 = pp;
				p = constant(p);
			} else
			if (p->op1->o.c.val == 16) {
				p->op1->o.c.val = 4;
				p->op = O_LTLT;
				pp = p->op2;
				p->op2 = p->op1;
				p->op1 = pp;
				p = constant(p);
			} else
			if (p->op1->o.c.val == 32) {
				p->op1->o.c.val = 5;
				p->op = O_LTLT;
				pp = p->op2;
				p->op2 = p->op1;
				p->op1 = pp;
				p = constant(p);
			} else
			if (p->op1->o.c.val == 64) {
				p->op1->o.c.val = 6;
				p->op = O_LTLT;
				pp = p->op2;
				p->op2 = p->op1;
				p->op1 = pp;
				p = constant(p);
			}
			
		} else 
		if (p->op2->op == O_CONST) {
			if (p->op2->o.c.val == 0) {
				pp = p->op2;
				tree_free(p->op1);
				free(p);
				p = pp;
			} else
			if (p->op2->o.c.val == 1) {
				pp = p->op1;
				free(p->op2);
				free(p);
				p = pp;
			} else
			if (p->op2->o.c.val == 2) {
				p->op2->o.c.val = 1;
				p->op = O_LTLT;
				p = constant(p);
			} else
			if (p->op2->o.c.val == 4) {
				p->op2->o.c.val = 2;
				p = constant(p);
			} else
			if (p->op2->o.c.val == 8) {
				p->op2->o.c.val = 3;
				p->op = O_LTLT;
				p = constant(p);
			} else
			if (p->op2->o.c.val == 16) {
				p->op2->o.c.val = 4;
				p->op = O_LTLT;
				p = constant(p);
			} else
			if (p->op2->o.c.val == 32) {
				p->op2->o.c.val = 5;
				p->op = O_LTLT;
				p = constant(p);
			} else
			if (p->op2->o.c.val == 64) {
				p->op2->o.c.val = 6;
				p->op = O_LTLT;
				p = constant(p);
			}
		}
		break;
	case O_DIV:
		p->op1 = constant(p->op1);
		p->op2 = constant(p->op2);
		if (p->op1->op == O_CONST) {
			if (p->op2->op == O_CONST) {
				if (p->op2->o.c.val == 0) {
					yywarnline(p->line, "divide by 0",0,0,0,0,0,0);
					p->op1->o.c.val = 0;
				} else {
					p->op1->o.c.val = p->op1->o.c.val / p->op2->o.c.val;
				}
				pp = p->op1;
				free(p->op2);
				free(p);
				p = pp;
			} else 
			if (p->op1->o.c.val == 0) {
				pp = p->op1;
				tree_free(p->op2);
				free(p);
				p = pp;
			} 
		} else 
		if (p->op2->op == O_CONST) {
			if (p->op2->o.c.val == 0) {
				yywarnline(p->line, "divide by 0",0,0,0,0,0,0);
				pp = p->op2;
				tree_free(p->op1);
				free(p);
				p = pp;
			} else
			if (p->op2->o.c.val == 1) {
				pp = p->op1;
				free(p->op2);
				free(p);
				p = pp;
			}
		}
		break;
	case O_MOD:
		p->op1 = constant(p->op1);
		p->op2 = constant(p->op2);
		if (p->op1->op == O_CONST) {
			if (p->op2->op == O_CONST) {
				if (p->op2->o.c.val == 0) {
					yywarnline(p->line, "mod by 0",0,0,0,0,0,0);
					p->op1->o.c.val = 0;
				} else {
					p->op1->o.c.val = p->op1->o.c.val % p->op2->o.c.val;
				}
				pp = p->op1;
				free(p->op2);
				free(p);
				p = pp;
			} else 
			if (p->op1->o.c.val == 0) {
				pp = p->op1;
				tree_free(p->op2);
				free(p);
				p = pp;
			} 
		} else 
		if (p->op2->op == O_CONST) {
			if (p->op2->o.c.val == 0) {
				yywarnline(p->line, "mod by 0",0,0,0,0,0,0);
				pp = p->op2;
				tree_free(p->op1);
				free(p);
				p = pp;
			} else
			if (p->op2->o.c.val == 1) {
				pp = p->op2;
				free(p->op1);
				free(p);
				p = pp;
				p->o.c.val = 0;
			} else
			if (p->op2->o.c.val == 2) {
				pp = p->op1;
				free(p->op2);
				free(p);
				p = build2(O_AND, (struct OP *)(long)pp->line, pp, make_constant(1));
			} else
			if (p->op2->o.c.val == 4) {
				pp = p->op1;
				free(p->op2);
				free(p);
				p = build2(O_AND, (struct OP *)(long)pp->line, pp, make_constant(3));
			} else
			if (p->op2->o.c.val == 8) {
				pp = p->op1;
				free(p->op2);
				free(p);
				p = build2(O_AND, (struct OP *)(long)pp->line, pp, make_constant(7));
			} else
			if (p->op2->o.c.val == 16) {
				pp = p->op1;
				free(p->op2);
				free(p);
				p = build2(O_AND, (struct OP *)(long)pp->line, pp, make_constant(15));
			}
		}
		break;
	case O_MINUS:
		p->op1 = constant(p->op1);
		if (p->op1->op == O_CONST) {
			pp = p->op1;
			pp->o.c.val = -pp->o.c.val;
			free(p);
			p = pp;
		} else 
		if (p->op1->op == O_MINUS) {
			pp = p->op1->op1;
			free(p->op1);
			free(p);
			p = pp;
		}
		if (p->op == O_MINUS) {
			pp = constant(build2(O_SUB, (struct OP *)(long)p->line, make_constant(0), p->op1));
			free(p);
			p = pp;
		}
		break;
	case O_NOT:
		p->op1 = constant(p->op1);
		if (p->op1->op == O_CONST) {
			pp = p->op1;
			p->op1->o.c.val = !p->op1->o.c.val;
			free(p);
			p = pp;
		} else 
		if (p->op1->op == O_NOT) {
			pp = p->op1->op1;
			free(p->op1);
			free(p);
			p = pp;
		} else
		if (p->op1->op == O_NE) {
			p->op1->op = O_EQ;
			pp = p->op1->op1;
			free(p->op1);
			free(p);
			p = pp;
		} else
		if (p->op1->op == O_EQ) {
			p->op1->op = O_NE;
			pp = p->op1->op1;
			free(p->op1);
			free(p);
			p = pp;
		} else
		if (p->op1->op == O_GE) {
			p->op1->op = O_LT;
			pp = p->op1->op1;
			free(p->op1);
			free(p);
			p = pp;
		} else
		if (p->op1->op == O_LT) {
			p->op1->op = O_GE;
			pp = p->op1->op1;
			free(p->op1);
			free(p);
			p = pp;
		} else
		if (p->op1->op == O_LE) {
			p->op1->op = O_GT;
			pp = p->op1->op1;
			free(p->op1);
			free(p);
			p = pp;
		} else
		if (p->op1->op == O_GT) {
			p->op1->op = O_LE;
			pp = p->op1->op1;
			free(p->op1);
			free(p);
			p = pp;
		}
		break;
	case O_TILDE:
		p->op1 = constant(p->op1);
		if (p->op1->op == O_CONST) {
			pp = p->op1;
			p->op1->o.c.val = ~p->op1->o.c.val;
			free(p);
			p = pp;
		} else 
		if (p->op1->op == O_TILDE) {
			pp = p->op1->op1;
			free(p->op1);
			free(p);
			p = pp;
		}
		break;
	case O_INDEX:
		p->op1 = constant(p->op1);
		p->op2 = constant(p->op2);
		if (p->op2->op == O_CONST && p->op1->o.c.val == 0) {
			pp = build1(O_STAR, (struct OP *)(long)p->line, p->op1);
			free(pp);
			p = pp;
		}
		break;
	case O_CALLV:
	case O_CALL:	
		p->op1 = constant(p->op1);
		p->op2 = constant(p->op2);
		break;
	case O_PLIST:
	case O_LIST:
		p->op1 = constant(p->op1);
		p->op2 = constant(p->op2);
		break;
	case O_ADDR:
		p->op1 = constant(p->op1);
		if (p->op1->op == O_STAR) {
			pp = p->op1->op1;
			free(p->op1);
			free(p);
			p = pp;
	//	} else {
	//		yyerror("Invalid use of '&'",0,0,0,0,0,0);
		}
		break;
	case O_GET:
		p->op1 = constant(p->op1);
		break;
	case O_LOG_BASE:
	case O_LOG_END:
	case O_TIME:
	case O_LTIME:
	case O_RTIME:
	case O_STIME:
	case O_STRING:
	case O_CONST:
		break;
	case O_NAME:
		if (p->o.n.d->loc == LOC_CONST) {
			p->o.c.val = p->o.n.d->val;
			p->op = O_CONST;
		}
		break;
	case O_UCHAR_IND:
	case O_UWORD_IND:
	case O_ULONG_IND:
	case O_UCHAR:
	case O_UWORD:
	case O_ULONG:
	case O_CHAR_IND:
	case O_WORD_IND:
	case O_LONG_IND:
	case O_CHAR:
	case O_WORD:
	case O_LONG:
		p->op1 = constant(p->op1);
		break;
	case O_STAR:
		if (p->op1->op == O_NAME && p->op1->o.n.d->loc == LOC_CONST) {
			pp = p->op1;
			free(p);
			p = pp;
			p->o.c.val = p->o.n.d->val;
			p->op = O_CONST;
			break;
		}
		p->op1 = constant(p->op1);
		break;
	case O_STAR_INC:
	case O_STAR_DEC:
	case O_STAR_INC_P:
	case O_STAR_DEC_P:
		if (p->op1->op == O_NAME && p->op1->o.n.d->loc == LOC_CONST) {
			yyerrline(p->line, "Attempt to autoinc/decrement constant '%s'", (long)p->op1->o.n.d->name,0,0,0,0,0);
			break;
		}
		p->op1 = constant(p->op1);
		break;
		
	default:
		int_error("constant: %d", p->op,0,0,0,0);
	}
	return(p);
}

//int coerce[] = {0, 0, 0, 0, O_CHAR, O_WORD};

struct OP *
types(struct OP *p, int type)
{
	int t;
	struct OP *pp;
	
	if (yyerrcount)
		return(p);
	if (p == NULL)
		return(p);
	switch (p->op) {
	case	O_INDEX:
		p->op1 = types(p->op1, TYPE_UNKNOWN);
		p->op2 = types(p->op2, TYPE_WORD);
		if (p->op1->op == O_STAR && p->op1->op1->op == O_NAME && p->op1->op1->o.n.d->array) {
			pp = p->op1;
			p->op1 = p->op1->op1;
			free(pp);
		}

		if (PTR_TYPE(p->op1->tp)) {
			pp = types(constant(build1(O_STAR, (struct OP *)(long)p->line, build2(O_ADD, (struct OP *)(long)p->line, p->op1, p->op2))), TYPE_UNKNOWN);
			free(p);
			p = pp;
		} else {
			//tree_print("index - types 1", p, 0);
			yyerrline(p->line, "Invalid indexed type", 0,0,0,0,0,0);
		}
		break;
	case O_ASSIGN:
		p->op1 = types(p->op1, TYPE_UNKNOWN);
		p->tp = t = (p->op1->tp == TYPE_UNKNOWN ? TYPE_WORD:p->op1->tp);
		p->op2 = types(p->op2, t);
		break;

	case O_OROR:
	case O_ANDAND:
		p->op1 = types(p->op1, TYPE_UNKNOWN);
		p->op2 = types(p->op2, TYPE_UNKNOWN);
		p->tp = TYPE_WORD;
		break;

	case O_CHOOSE:
		p->op1 = types(p->op1, TYPE_UNKNOWN);
		p->op2 = types(p->op2, type);
		p->op3 = types(p->op3, type);
		if (p->op2->tp == p->op3->tp) {
			p->tp = p->op2->tp;
		} else 
		if (PTR_TYPE(p->op3->tp) ||
		    PTR_TYPE(p->op2->tp)) {
		    	yyerror("pointer types can't be mixed for ?:",0,0,0,0,0,0);
		} else
		if (SAME_SIZE_TYPE(p->op2->tp, p->op3->tp)) {
			if (!UNSIGNED_TYPE(p->op3->tp)) {
				p->tp = p->op3->tp;
			} else {
				p->tp = p->op2->tp;
			}
		} else
		if (LONG_TYPE(p->op2->tp)) {
			p->op3 = types(p->op3, p->op2->tp);
			p->tp = p->op2->tp;
		} else
		if (LONG_TYPE(p->op3->tp)) {
			p->op2 = types(p->op2, p->op3->tp);
			p->tp = p->op3->tp;
		} else 
		if (!UNSIGNED_TYPE(p->op2->tp)) {
			p->tp = p->op2->tp;
		} else {
			p->tp = p->op3->tp;
		}
		break;
		
	case O_LT:
	case O_LE:
	case O_GT:
	case O_GE:
	case O_NE:
	case O_EQ:
		p->op1 = types(p->op1, TYPE_UNKNOWN);
		p->op2 = types(p->op2, TYPE_UNKNOWN);
		if (p->op1->tp == TYPE_UNKNOWN) {
			if (p->op2->tp == TYPE_UNKNOWN) {
				p->op1->tp = p->op2->tp = TYPE_WORD;
			} else {
				p->op1->tp = p->op2->tp;
			}
		} else
		if (p->op2->tp == TYPE_UNKNOWN) {
			p->op2->tp = p->op1->tp;
		} 
		if (p->op1->tp != p->op2->tp) {
			if (PTR_TYPE(p->op1->tp) ||
			    PTR_TYPE(p->op2->tp)) {
		    		yyerror("pointer types can't be mixed for comparisons",0,0,0,0,0,0);
			}
			if (LONG_TYPE(p->op1->tp) || LONG_TYPE(p->op2->tp)) {
				if (LONG_TYPE(p->op1->tp)) {
					p->op2 = types(p->op2, p->op1->tp);
				} else {
					p->op1 = types(p->op1, p->op2->tp);
				}
			}
			p->tp = TYPE_WORD;
		} else {
			p->tp = TYPE_WORD;
		}
		break;
	case O_SUB:
	case O_MUL:
	case O_DIV:
	case O_MOD:
	case O_ADD:
	case O_OR:
	case O_AND:
	case O_XOR:
		//tree_print("add - types 1", p, 0);
		p->op1 = types(p->op1, TYPE_UNKNOWN);
		//tree_print("add - types 1a", p, 0);
		p->op2 = types(p->op2, TYPE_UNKNOWN);
		//tree_print("add - types 2", p, 0);
		if (PTR_TYPE(p->op1->tp) ||
		    PTR_TYPE(p->op2->tp))
		if (p->op != O_SUB && p->op != O_ADD) {
			yyerror("pointer types be used with logical or multiplicative operations",0,0,0,0,0,0);
			break;
		}
		if (p->op1->tp == TYPE_UNKNOWN) {
			p->op1 = types(p->op1, (p->op2->tp == TYPE_LONG?TYPE_LONG:TYPE_WORD));	
		} 
		if (p->op2->tp == TYPE_UNKNOWN) {
			p->op2 = types(p->op2, (p->op1->tp == TYPE_LONG?TYPE_LONG:TYPE_WORD));	
		} 
		if (p->op1->tp != p->op2->tp) {
			if (PTR_TYPE(p->op1->tp) &&
			    PTR_TYPE(p->op2->tp)) {
		    		yyerror("pointer types can't be mixed for additive operations",0,0,0,0,0,0);
				break;
			}
			if (PTR_TYPE(p->op1->tp)) {
			    	t = p->op1->tp;
			    	if (p->op1->tp == TYPE_CHAR_IND || p->op1->tp == TYPE_UCHAR_IND) {
			    		p->op2 = types(p->op2, TYPE_WORD);
				} else
			    	if (p->op1->tp == TYPE_LONG_IND || p->op1->tp == TYPE_ULONG_IND ) {
			    		p->op2 = types(constant(build2(O_LTLT, (struct OP *)(long)p->op2->line, p->op2, make_constant(2))), TYPE_WORD);
				} else {
			    		p->op2 = types(constant(build2(O_LTLT, (struct OP *)(long)p->op2->line, p->op2, make_constant(1))), TYPE_WORD);
				}
			} else
			if (PTR_TYPE(p->op2->tp)) {
			    	t = p->op2->tp;
			    	if (p->op2->tp == TYPE_CHAR_IND || p->op2->tp == TYPE_UCHAR_IND) {
			    		p->op1 = types(p->op1, TYPE_WORD);
				} else
			    	if (p->op2->tp == TYPE_LONG_IND || p->op2->tp == TYPE_ULONG_IND) {
			    		p->op1 = types(constant(build2(O_LTLT, (struct OP *)(long)p->op1->line, p->op1, make_constant(2))), TYPE_WORD);
				} else {
			    		p->op1 = types(constant(build2(O_LTLT, (struct OP *)(long)p->op1->line, p->op1, make_constant(1))), TYPE_WORD);
				}
			} else {
				if (LONG_TYPE(p->op1->tp)) {
			    		p->op2 = types(p->op2, p->op1->tp);	
				} else
				if (LONG_TYPE(p->op2->tp)) {
			    		p->op1 = types(p->op1, p->op2->tp);	
				} 
				if (!UNSIGNED_TYPE(p->op2->tp)) {
					t = p->op2->tp;
				} else {
					t = p->op1->tp;
				}
			}
		} else {	
			if (PTR_TYPE(p->op1->tp)) {
				if (p->op != O_SUB) {
					yyerror("addition of pointers is meaningless",0,0,0,0,0,0);
					t = p->op1->tp;
				} else {
					t = TYPE_WORD;
					if (p->tp == TYPE_UNKNOWN) 
					if (p->op1->tp == TYPE_WORD_IND || p->op1->tp == TYPE_UWORD_IND) {
						p->tp = TYPE_WORD;
			    			p = constant(build2(O_GTGT, (struct OP *)(long)p->line, p, make_constant(1)));
					} else
					if (p->op1->tp == TYPE_LONG_IND || p->op1->tp == TYPE_ULONG_IND) {
						p->tp = TYPE_WORD;
			    			p = constant(build2(O_GTGT, (struct OP *)(long)p->line, p, make_constant(2)));
					} 
				}
			} else {
				t = p->op1->tp;
			}
		}
		p->tp = t;
		break;
	case O_LTLT:
	case O_GTGT:
		p->op1 = types(p->op1, TYPE_UNKNOWN);
		p->op2 = types(p->op2, TYPE_WORD);
		if (PTR_TYPE(p->op1->tp) ||
		    PTR_TYPE(p->op2->tp)) {
			yyerror("pointer types be used with shift operations",0,0,0,0,0,0);
			break;
		}
		p->tp = p->op1->tp;
		break;
	case O_NOT:
		p->op1 = types(p->op1, TYPE_UNKNOWN);
		p->tp = TYPE_WORD;
		break;
	case O_TILDE:
		p->op1 = types(p->op1, TYPE_UNKNOWN);
		if (PTR_TYPE(p->op1->tp)) {
			yyerror("pointer types be used with logical operations",0,0,0,0,0,0);
			break;
		}
		p->tp = p->op1->tp;
		break;
	case O_ADDR:
		p->op1 = types(p->op1, TYPE_UNKNOWN);	
		if (p->op1->op == O_STAR) {
			pp = p->op1->op1;
			free(p->op1);
			free(p);
			p = pp;
		} else {
			p->tp = p->op1->tp+TYPE_INC;
		}
		break;
	case O_CALLV:
	case O_CALL:
		p->op1 = types(p->op1, TYPE_UNKNOWN);
		p->op2 = types(p->op2, TYPE_UNKNOWN);
		if (p->op1->op == O_STAR && p->op1->op1->op == O_NAME) {
			p->tp = p->op1->op1->o.n.d->type;
		} else {
			p->tp = TYPE_WORD;
		}
		break;
	case O_PLIST:
		p->op1 = types(p->op1, TYPE_UNKNOWN);
		p->op2 = types(p->op2, TYPE_UNKNOWN);
		p->tp = TYPE_UNKNOWN;
		return(p);
	case O_LIST:
		p->op1 = types(p->op1, TYPE_UNKNOWN);
		p->op2 = types(p->op2, TYPE_UNKNOWN);
		p->tp = TYPE_UNKNOWN;
		return(p);
	case O_NAME:
		//tree_print("name - types 1", p, 0);
		if (p->o.n.d->loc == LOC_UNKNOWN ||
		    p->o.n.d->loc == LOC_STATE) {
		    	yyerror("Undefined variable '%s'",(long)p->o.n.d->name,0,0,0,0,0);
		}
		if (p->o.n.d->loc == LOC_PROC) {
		    	p->tp = TYPE_PROC_IND;
		} else {
			p->tp = p->o.n.d->type+TYPE_INC;
		}
		break;
	case O_CONST:
		p->tp = type;
		break;
	case O_GET:
		p->op1 = types(p->op1, TYPE_WORD);
		p->tp = TYPE_WORD;
		break;
	case O_TIME:
	case O_LTIME:
	case O_RTIME:
	case O_STIME:
		p->tp = TYPE_ULONG;
		break;
	case O_LOG_BASE:
	case O_LOG_END:
		p->tp = TYPE_UCHAR_IND;
		break;
	case O_STRING:
		p->tp = TYPE_CHAR_IND;
		break;
	case O_UCHAR_IND:
		pp = types(p->op1, TYPE_UNKNOWN);
		free(p);
		p = pp;
		p->tp = TYPE_UCHAR_IND;
		break;
	case O_CHAR_IND:
		pp = types(p->op1, TYPE_UNKNOWN);
		free(p);
		p = pp;
		p->tp = TYPE_CHAR_IND;
		break;
	case O_UCHAR:
		pp = types(p->op1, TYPE_UNKNOWN);
		free(p);
		p = pp;
		p->tp = TYPE_UCHAR;
		break;
	case O_CHAR:
		pp = types(p->op1, TYPE_UNKNOWN);
		free(p);
		p = pp;
		p->tp = TYPE_CHAR;
		break;
	case O_UWORD_IND:
		pp = types(p->op1, TYPE_UNKNOWN);
		free(p);
		p = pp;
		p->tp = TYPE_UWORD_IND;
		break;
	case O_WORD_IND:
		pp = types(p->op1, TYPE_WORD);
		free(p);
		p = pp;
		p->tp = TYPE_WORD_IND;
		break;
	case O_UWORD:
		pp = types(p->op1, TYPE_UNKNOWN);
		free(p);
		p = pp;
		p->tp = TYPE_UWORD;
		break;
	case O_WORD:
		pp = types(p->op1, TYPE_UNKNOWN);
		free(p);
		p = pp;
		p->tp = TYPE_WORD;
		break;
	case O_ULONG:
		pp = types(p->op1, TYPE_ULONG);
		free(p);
		p = pp;
		p->tp = TYPE_ULONG;
		break;
	case O_LONG:
		pp = types(p->op1, TYPE_LONG);
		free(p);
		p = pp;
		p->tp = TYPE_LONG;
		break;
	case O_ULONG_IND:
		pp = types(p->op1, TYPE_UNKNOWN);
		free(p);
		p = pp;
		p->tp = TYPE_ULONG_IND;
		break;
	case O_LONG_IND:
		pp = types(p->op1, TYPE_UNKNOWN);
		free(p);
		p = pp;
		p->tp = TYPE_LONG_IND;
		break;
	case O_STAR:
	case O_STAR_INC:
	case O_STAR_DEC:
	case O_STAR_INC_P:
	case O_STAR_DEC_P:
		//tree_print("* - types 1", p, 0);
		p->op1 = types(p->op1, TYPE_UNKNOWN);
		//tree_print("* - types 2", p, 0);
		if (PTR_TYPE(p->op1->tp)) {
			p->tp = p->op1->tp-TYPE_INC;
		} else {
			yyerror("pointer type must be used with '*'",0,0,0,0,0,0);
			if (p->op1->tp == TYPE_UNKNOWN) {
				p->op1->tp = TYPE_CHAR_IND;
			}
			p->tp = TYPE_CHAR;
		}
		//tree_print("* - types 3", p, 0);
		break;
	case O_SHORTEN:
	case O_WIDEN:
	case O_WIDENU:
		return(p);
	default:
		int_error("types: %d", p->op,0,0,0,0);
	}
	if (p->tp == type)
		return(p);
	if (type == TYPE_UNKNOWN) 
		return(p);
	if (LONG_TYPE(type)) {
		if (p->op != O_CONST && p->op != O_STRING)
			p = build1((type==TYPE_LONG?O_WIDEN:O_WIDENU), (struct OP *)(long)p->line, p);
		p->tp = type;
	} else
	if (LONG_TYPE(p->tp)) {
		if (p->op != O_CONST && p->op != O_STRING)
			p = build1(O_SHORTEN, (struct OP *)(long)p->line, p);
		p->tp = type;
	} 
	return(p);
}

