%{
/*
 *      Copyright (c) 1998 Paul Campbell
 *      All Rights Reserved
 *      THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Paul Campbell
 *      The copyright notice above does not evidence any
 *      actual or intended publication of such source code.
 */

#include <stdio.h>
#include <stdlib.h>
#ifdef MPW
#include <string.h>
#include <osutils.h>
#pragma segment ctl
#endif
#include "action.h"
unsigned long this_time;
int yylex();
void set_timescale(unsigned long t);
void save_action(unsigned long t);
void yyerror(char *s, long a, long b, long c, long d, long e, long f);
yyerror1(char *s)
{
	yyerror(s, 0, 0,0,0,0,0);
}
#define yyerror yyerror1
%}
%token t_timescale t_num t_float t_input t_interrupt t_symbol
%token t_channel t_string
%start	s
%%

s:		options	stim
	;

options:	
	|	optionl
	;

optionl:	option 
	|	option optionl
	;

option:		t_timescale t_num ';'			{ set_timescale($2); }
	;

fnum:		t_float		{ $$ = $1; }
	|	t_num		{ $$ = $1; }
	;

stim:		st
	|	st stim
	;

st:		time ':' {this_time = $1;} actionn {save_action(this_time);}
	;

time:		fnum			{ $$ = $1; }
	|	'+' fnum		{ $$ = this_time+$2; }
	;

actionn:	
	|	actions
	;

actions:	action 
	|	action actions
	;

action:		t_input t_string			{ this_action->input = (char *)$2; }
	|	t_interrupt t_num			{ this_action->interrupt |= 1<<$2; }
	|	t_channel chan '=' t_num		{ this_action->chan[$2] = $4; this_action->type[$2] = 1; }
	|	t_channel chan '-' '>' t_num		{ this_action->chan[$2] = $5; this_action->type[$2] = 2; }
	;

chan:		t_num					{ if ($1 < 0 || $1 >=16) { yyerror("Invalid channel number"); $$ = 16; } else {$$ = $1;} }
	;
