/*
 *      Copyright (c) 1991 Paul Campbell
 *      All Rights Reserved
 *      THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Paul Campbell
 *      The copyright notice above does not evidence any
 *      actual or intended publication of such source code.
 */
#pragma segment data
#include "lex.h"

char tree_size[] = {
	0,
	2,		/* O_PLIST	*/
	2,		/* O_ASSIGN	*/
	2,		/* O_LIST	*/
	2,		/* O_OROR	*/
	2,		/* O_ANDAND	*/
	2,		/* O_LT		*/
	2,		/* O_LE		*/
	2,		/* O_GT		*/
	2,		/* O_GE		*/
	2,		/* O_NE		*/
	2,		/* O_EQ		*/
	2,		/* O_OR		*/
	2,		/* O_AND	*/
	2,		/* O_XOR	*/
	2,		/* O_LTLT	*/
	2,		/* O_GTGT	*/
	2,		/* O_ADD	*/
	2,		/* O_SUB	*/
	2,		/* O_MUL	*/
	2,		/* O_DIV	*/
	1,		/* O_MINUS	*/
	1,		/* O_NOT	*/
	1,		/* O_TILDE	*/
	2,		/* O_INDEX	*/
	2,		/* O_CALL	*/
	-1,		/* FREE		*/
	1,		/* O_STAR 	*/
	2,		/* O_CALLV	*/
	1,		/* O_GET	*/
	-1,		/* O_STRING	*/
	-1,		/* O_CONST	*/
	-1,		/* O_NAME	*/
	2,		/* O_MOD	*/
	1,		/* O_CHAR	*/
	1,		/* O_WORD	*/
	1,		/* O_ADDR	*/
	1,		/* O_CHAR_IND	*/
	1,		/* O_WORD_IND	*/
	0,		/* O_TIME	*/
	0,		/* O_LTIME	*/
	1,		/* O_STAR_INC 	*/
	1,		/* O_STAR_DEC 	*/
	1,		/* O_STAR_INC_P */
	1,		/* O_STAR_DEC_P	*/
	1,		/* O_LONG	*/
	1,		/* O_LONG_IND	*/
	1,		/* O_WIDEN	*/
	1,		/* O_SHORTEN	*/
	3,		/* O_CHOOSE	*/
	0,		/* O_RTIME	*/
	1,		/* O_SIZEOF	*/
	0,		/* O_LOG_BASE	*/
	0,		/* O_LOG_END	*/
	1,		/* O_UCHAR	*/
	1,		/* O_UCHAR_IND	*/
	1,		/* O_UWORD	*/
	1,		/* O_UWORD_IND	*/
	1,		/* O_ULONG	*/
	1,		/* O_ULONG_IND	*/
	1,		/* O_WIDENU	*/
	0,		/* O_STIME		*/
};

int max_op = sizeof(tree_size)/sizeof(tree_size[0]);

char *tree_name[] = {
	"!!BAD!!",
	"plist",		/* O_PLIST		*/
	"=",			/* O_ASSIGN		*/
	"list",			/* O_LIST		*/
	"||",			/* O_OROR		*/
	"&&",			/* O_ANDAND		*/
	"<",			/* O_LT			*/
	"<=",			/* O_LE			*/
	">",			/* O_GT			*/
	">=",			/* O_GE			*/
	"!=",			/* O_NE			*/
	"==",			/* O_EQ			*/
	"|",			/* O_OR			*/
	"&",			/* O_AND		*/
	"^",			/* O_XOR		*/
	"<<",			/* O_LTLT		*/
	">>",			/* O_GTGT		*/
	"+",			/* O_ADD		*/
	"-",			/* O_SUB		*/
	"*",			/* O_MUL		*/
	"/",			/* O_DIV		*/
	"U-",			/* O_MINUS		*/
	"!",			/* O_NOT		*/
	"~",			/* O_TILDE		*/
	"[]",			/* O_INDEX		*/
	"call()",		/* O_CALL		*/
	"FREE	",		/* FREE			*/
	"*",			/* O_STAR 		*/
	"callv()",		/* O_CALLV		*/
	"get()",		/* O_GET		*/
	"string",		/* O_STRING		*/
	"const",		/* O_CONST		*/
	"name",			/* O_NAME		*/
	"%",			/* O_MOD		*/
	"char",			/* O_CHAR		*/
	"word",			/* O_WORD		*/
	"addr",			/* O_ADDR		*/
	"char*",		/* O_CHAR_IND		*/
	"word*",		/* O_WORD_IND		*/
	"time",			/* O_TIME		*/
	"ltime",		/* O_LTIME		*/
	"*++",			/* O_STAR_INC 		*/
	"*--",			/* O_STAR_DEC 		*/
	"++*",			/* O_STAR_INC_P 	*/
	"--*",			/* O_STAR_DEC_P		*/
	"long",			/* O_LONG_IND		*/
	"long*",		/* O_LONG_IND		*/
	"widen",		/* O_WIDEN		*/
	"shorten",		/* O_SHORTEN		*/
	"choose",		/* O_CHOOSE		*/
	"rtime",		/* O_RTIME		*/
	"sizeof",		/* O_SIZEOF		*/
	"___log_base",		/* O_LOG_BASE		*/
	"___log_end",		/* O_LOG_END		*/
	"uchar",		/* O_UCHAR		*/
	"uchar_ind",		/* O_UCHAR_IND		*/
	"uword",		/* O_UWORD		*/
	"uword_ind",		/* O_UWORD_IND		*/
	"ulong",		/* O_ULONG		*/
	"ulong_ind",		/* O_ULONG_IND		*/
	"widenu",		/* O_WIDENU		*/
	"stime",		/* O_STIME		*/
};


char *op_name[] = {
        "HALT",
        "UBYTE_L",
        "UBYTE_G",
        "J_NE",
        "J_EQ",
        "GE",
        "GT",
        "LE",
        "LT",
        "NE",
        "EQ",
        "NOT",
        "SUB",
        "ADD",
        "MUL",
        "DIV",
        "MOD",
        "OR",
        "XOR",
        "AND",
        "SHL",
        "SHR",
        "JMP",
        "COMP",
        "CALL",
        "CALLI",
        "COPYN",
        "CUTN",
        "CONST",
        "ADDR_L",
        "ADDR_G",
        "BYTE_L",
        "BYTE_G",
        "WORD_L",
        "WORD_G",
        "SBYTE_L",
        "SBYTE_G",
        "SWORD_L",
        "SWORD_G",
        "LOAD_B",
        "LOAD_W",
        "DUP",
        "STORE_B",
        "STORE_W",
        "ADDR_P",
        "ZERO",
        "ONE",
        "ENTER",
	"EXIT",
	"ADDR_S",
	"POLL",
	"INTERRUPT",
	"SAVE_TIME",
	"CMP_TIME",
	"INPUT",
	"OUTPUT",
	"LAUNCH",
	"ARM",
	"SAFE",
	"FIRE",
	"TIME",
	"LTIME",
	"SET_LOG_FULL",
	"SET_LOG_POLL",
	"BEEP",
	"PSTR",
	"PHEX",
	"PVAL",
	"PCHR",
	"EESAVE",
	"EELOAD",
	"GET",
	"SET",
	"POP",
        "GE_L",
        "GT_L",
        "LE_L",
        "LT_L",
        "NE_L",
        "EQ_L",
        "NOT_L",
        "SUB_L",
        "ADD_L",
        "MUL_L",
        "DIV_L",
        "MOD_L",
        "OR_L",
        "XOR_L",
        "AND_L",
        "SHL_L",
        "SHR_L",
        "COMP_L",
        "CONST_L",
        "LONG_L",
        "LONG_G",
        "SLONG_L",
        "SLONG_G",
        "LOAD_L",
        "DUP_L",
        "STORE_L",
        "ZERO_L",
        "ONE_L",
        "WIDEN",
        "SHORTEN",
        "PVALU",
        "PHEXL",
        "POP_L",
	"EQ_C",
	"EQ_L_C",
	"ADD_C",
	"ADD_L_C",
	"INDEX2",
	"INDEX4",
	"LSHORTEN",
	"RTIME",
	"LOG_FULL",
	"LOG_BASE",
	"LOG_END",
	"JEQV",
	"JEQV_L",
	"JNEV",
	"JNEV_L",
	"WIDENU",
	"LOAD_UB",
	"FOUND_LAUNCH",
	"MULU",
	"DIVU",
	"MULU_L",
	"DIVU_L",
	"GEU",
	"GEU_L",
	"GTU",
	"GTU_L",
	"LEU",
	"LEU_L",
	"LTU",
	"LTU_L",
	"SET_LOG_TRAMPOLINE",
	"SET_LOG_EXTRA",
	"STIME",
};

int max_xop = sizeof(op_name)/sizeof(op_name[0]);

char op_type[] = {
        0,
        4,
        4,
        1,
        1,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        1,
        0,
        1,
        1,
        2,
        2,
        2,
        4,
        4,
        4,
        4,
        4,
        4,
        4,
        4,
        4,
        4,
        4,
        4,
        0,
        4,
        4,
        1,
        0,
        0,
        2,
	2,
	3,
	0,
	2,
	0,
	2,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	1,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        5,
        2,
        2,
        2,
        2,
        2,
        0,
        2,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
	2,
	4,
	2,	
	4,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	5,	
	5,
	5,
	5,
	0,
	4,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	1,
	1,
	0,
};
