/*
 *      Copyright (c) 1991 Paul Campbell
 *      All Rights Reserved
 *      THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Paul Campbell
 *      The copyright notice above does not evidence any
 *      actual or intended publication of such source code.
 */
#define COMPILER 1
#pragma segment exp
#include <stdio.h>
#include <stdlib.h>
#include "lex.h"
#include "code.h"

extern FILE *fcode;
extern int debug;
extern struct OP *make_constant();
long extra_depth = 0;
extern char *sss;


int
count_depth(struct OP *p)
{	
	if (p == NULL)
		return(0);
	if (p->op == O_PLIST)
		return(count_depth(p->op1)+count_depth(p->op2));
	return(LONG_TYPE(p->tp)?2:1);
}

static unsigned char stack[1000];
static int sp;

void
empty_stack()
{
	sp = 0;
	stack[sp] = 0xff;
}

void
pop_stack(int c, int count)
{
	while (count > 0) {
		sp--;
		//printf("pop_stack[%d] = %d\n", sp, stack[sp]);
		if (c)
		if (stack[sp] == 0) {
			out(P_POP);
		} else 
		if (stack[sp] == 1) {
			out(P_POP_L);
		}
		count--;
	}
}

void
push_stack(int type, int c)
{
	if (c)
	if (stack[sp] == 0) {
		out(P_DUP);
	} else 
	if (stack[sp] == 1) {
		out(P_DUP_L);
	}
	sp++;
	stack[sp] = (LONG_TYPE(type)?1:0);
	//printf("push_stack[%d] = %d->%d\n", sp-1, stack[sp-1], stack[sp]);
}

void
exp(struct OP *p)
{
	struct OP *pp;
	struct label *l1, *l2;
	int i;
	long v;
		
	if (yyerrcount)
		return;
	if (p == NULL)
		return;
	switch (p->op) {
	case O_OROR:
		exp(p->op1);
		l1 = new_label();
		if (LONG_TYPE(p->op1->tp))
			out(P_LSHORTEN);
		out_jmp(P_J_NE, l1);
		pop_stack(1, 1);
		exp(p->op2);
		if (LONG_TYPE(p->op2->tp))
			out(P_LSHORTEN);
		use_label(l1);
		break;
		
	case O_ANDAND:
		exp(p->op1);
		l1 = new_label();
		if (LONG_TYPE(p->op1->tp))
			out(P_LSHORTEN);
		out_jmp(P_J_EQ, l1);
		pop_stack(1, 1);
		exp(p->op2);
		if (LONG_TYPE(p->op2->tp))
			out(P_LSHORTEN);
		use_label(l1);
		break;

	case O_CHOOSE:
		exp(p->op1);
		l1 = new_label();
		l2 = new_label();
		if (LONG_TYPE(p->op1->tp))
			out(P_LSHORTEN);
		out_jmp(P_J_EQ, l1);
		pop_stack(1, 1);
		exp(p->op2);
		pop_stack(0, 1);
		out_jmp(P_JMP, l2);
		use_label(l1);
		exp(p->op3);
		use_label(l2);
		break;

		
	case O_ADD:
	case O_SUB:
		if (p->op == O_ADD && p->op1->op == O_CONST) {
			pp = p->op2;
			p->op2 = p->op1;
			p->op1 = pp;
		}
		if (p->op == O_SUB && p->op2->op == O_CONST) {
			p->op = O_ADD;
			p->op2->o.c.val = -p->op2->o.c.val;
		}
		exp(p->op1);
		if (p->op == O_ADD && p->op2->op == O_CONST) {
			if (LONG_TYPE(p->op1->tp)) {
				out_const4(P_ADD_L_C, p->op2->o.c.val);
			} else {
				out_const(P_ADD_C, p->op2->o.c.val);
			}
			pop_stack(0, 1);
			push_stack(p->tp, 0);
		} else {
			exp(p->op2);
			if (p->op == O_ADD) {
				out(LONG_TYPE(p->tp)?P_ADD_L:P_ADD);
			} else {
				out(LONG_TYPE(p->tp)?P_SUB_L:P_SUB);
			}
			pop_stack(0, 1);
			pop_stack(0, 1);
			push_stack(p->tp, 0);
		}
		break;
	
	case O_LTLT:
		exp(p->op1);
		if (!LONG_TYPE(p->tp) && p->op2->op == O_CONST) {
			if (p->op2->o.c.val == 0)
				break;
			if (p->op2->o.c.val == 1) {
				out(P_INDEX2);
				pop_stack(0, 1);
				push_stack(p->tp, 0);
				break;
			}
			if (p->op2->o.c.val == 2) {
				out(P_INDEX4);
				pop_stack(0, 1);
				push_stack(p->tp, 0);
				break;
			}
				
		}
		exp(p->op2);
		out(LONG_TYPE(p->tp)?P_SHL_L:P_SHL);
		pop_stack(0, 1);
		pop_stack(0, 1);
		push_stack(p->tp, 0);
		break;
	case O_GE:
	case O_GT:
	case O_LE:
	case O_LT:
	case O_MUL:
	case O_DIV:
	case O_MOD:
	case O_AND:
	case O_OR:
	case O_XOR:
	case O_GTGT:
		exp(p->op1);
		exp(p->op2);
		switch (p->op) {
		case O_GE:
			out(!UNSIGNED_TYPE(p->op1->tp)||!UNSIGNED_TYPE(p->op2->tp)?(LONG_TYPE(p->op1->tp)?P_GE_L:P_GE):(LONG_TYPE(p->op1->tp)?P_GEU_L:P_GEU));
			break;
		case O_GT:
			out(!UNSIGNED_TYPE(p->op1->tp)||!UNSIGNED_TYPE(p->op2->tp)?(LONG_TYPE(p->op1->tp)?P_GT_L:P_GT):(LONG_TYPE(p->op1->tp)?P_GTU_L:P_GTU));
			break;
		case O_LE:
			out(!UNSIGNED_TYPE(p->op1->tp)||!UNSIGNED_TYPE(p->op2->tp)?(LONG_TYPE(p->op1->tp)?P_LE_L:P_LE):(LONG_TYPE(p->op1->tp)?P_LEU_L:P_LEU));
			break;
		case O_LT:
			out(!UNSIGNED_TYPE(p->op1->tp)||!UNSIGNED_TYPE(p->op2->tp)?(LONG_TYPE(p->op1->tp)?P_LT_L:P_LT):(LONG_TYPE(p->op1->tp)?P_LTU_L:P_LTU));
			break;
		case O_MUL:
			out(UNSIGNED_TYPE(p->tp)?(LONG_TYPE(p->tp)?P_MULU_L:P_MULU):(LONG_TYPE(p->tp)?P_MUL_L:P_MUL));
			break;
		case O_DIV:
			out(UNSIGNED_TYPE(p->tp)?(LONG_TYPE(p->tp)?P_DIVU_L:P_DIVU):(LONG_TYPE(p->tp)?P_DIV_L:P_DIV));
			break;
		case O_MOD:
			out(LONG_TYPE(p->tp)?P_MOD_L:P_MOD);
			break;
		case O_OR:
			out(LONG_TYPE(p->tp)?P_OR_L:P_OR);
			break;
		case O_XOR:
			out(LONG_TYPE(p->tp)?P_XOR_L:P_XOR);
			break;
		case O_AND:
			out(LONG_TYPE(p->tp)?P_AND_L:P_AND);
			break;
		case O_GTGT:
			out(LONG_TYPE(p->tp)?P_SHR_L:P_SHR);
			break;
		}
		pop_stack(0, 1);
		pop_stack(0, 1);
		push_stack(p->tp, 0);
		break;
	case O_NE:
		if (p->op1->op == O_CONST && p->op1->o.c.val == 0 && !LONG_TYPE(p->op2->tp)) {
			exp(p->op2);
		} else
		if (p->op2->op == O_CONST && p->op2->o.c.val == 0 && !LONG_TYPE(p->op1->tp)) {
			exp(p->op1);
		} else {
			exp(p->op1);
			exp(p->op2);
			out(P_NE);
			pop_stack(0, 1);
			pop_stack(0, 1);
			push_stack(p->tp, 0);
		}
		break;
	case O_EQ:
		if (p->op1->op == O_CONST) {
			pp = p->op1;
			p->op1 = p->op2;
			p->op2 = pp;
		}
		if (p->op2->op == O_CONST && p->op2->o.c.val == 0 && !LONG_TYPE(p->op1->tp)) {
			exp(p->op1);
			out(P_NOT);
			pop_stack(0, 1);
			push_stack(p->tp, 0);
		} else 
		if (p->op2->op == O_CONST) {
			exp(p->op1);
			if (LONG_TYPE(p->op1->tp)) {
				out_const4(P_EQ_L_C, p->op2->o.c.val);
			} else {
				out_const(P_EQ_C, p->op2->o.c.val);
			}
			pop_stack(0, 1);
			push_stack(p->tp, 0);
		} else{
			exp(p->op1);
			exp(p->op2);
			out(P_EQ);
			pop_stack(0, 1);
			pop_stack(0, 1);
			push_stack(p->tp, 0);
		}
		break;
		
		
	case O_NOT:
		exp(p->op1);	
		out(LONG_TYPE(p->op1->tp)?P_NOT_L:P_NOT);
		break;
	case O_TILDE:
		exp(p->op1);	
		out(LONG_TYPE(p->tp)?P_COMP_L:P_COMP);
		break;
	case O_CALLV:	
	case O_CALL:	
		if (p->op1->op != O_STAR) {
			yyerror("Call of non-procedure", 0,0,0,0,0,0);
			return;
		}
		if (p->op1->op1->op == O_NAME) {
			if (p->op1->op1->o.n.d->loc != LOC_PROC) {
				yyerror("Call of non-procedure '%s'", (long)p->op1->op1->o.n.d->name,0,0,0,0,0);
				return;
			}
			l1 = p->op1->op1->o.n.d->label;
			exp(p->op2);
			push_stack(TYPE_WORD, 1);
			out_jmp(P_CALL, l1);
			pop_stack(0, 1);
			i = count_depth(p->op2);
			if (p->op == O_CALLV) {
				if (i != 0) {
					out_const(P_COPYN, 2*i);
					pop_stack(0, i);
				}
				push_stack(p->tp, 0);
			} else {
				out_const(P_CUTN, 2*i);
				if (i != 0)
					pop_stack(0, i);
			}
		} else {
			exp(p->op2);
			exp(p->op1->op1);
			out(P_CALLI);
			pop_stack(0, 1);
			i = count_depth(p->op2);
			if (p->op == O_CALLV) {
				if (i != 0) {
					out_const(P_COPYN, 2*i);
					pop_stack(0, i);
				}
				push_stack(p->tp, 0);
			} else {
				out_const(P_CUTN, 2*i);
				if (i != 0)
					pop_stack(0, i);
			}
		}
		break;
			
	case O_LIST:
		if (p == NULL)
			break;
		if (p->op1 != NULL)
			exp(p->op1);
		if (p->op2 != NULL)
			exp(p->op2);
		break;
	case O_PLIST:
		if (p == NULL)
			break;
		if (p->op2 != NULL) {
			exp(p->op2);
		}
		if (p->op1 != NULL) {
			exp(p->op1);
		}
		break;
	case O_NAME:
		push_stack(p->tp, 1);
		if (p->o.n.d->loc == LOC_PROC) {
			out_jmp(P_ADDR_P, p->o.n.d->label);
		} else 
		if (p->o.n.d->loc == LOC_LOCAL) {
			out_const(P_ADDR_L, p->o.n.d->val);
		} else {
			out_const(P_ADDR_G, p->o.n.d->val);
		}
		break;
	case O_STRING:
		push_stack(p->tp, 1);
		out_const(P_ADDR_S, p->o.s.val);
		break;
	case O_CONST:
		push_stack(p->tp, 1);
		if (p->o.c.val == 0) {
			out(LONG_TYPE(p->tp)?P_ZERO_L:P_ZERO);
		} else 
		if (p->o.c.val == 1) {
			out(LONG_TYPE(p->tp)?P_ONE_L:P_ONE);
		} else {
			if (LONG_TYPE(p->tp)) {
				out_const4(P_CONST_L, p->o.c.val);
			} else {
				out_const(P_CONST, p->o.c.val);
			}
		}
		break;
	case O_LOG_BASE:
		push_stack(p->tp, 1);
		out(P_LOG_BASE);
		break;
	case O_LOG_END:
		push_stack(p->tp, 1);
		out(P_LOG_END);
		break;
	case O_TIME:
		push_stack(p->tp, 1);
		out(P_TIME);
		break;
	case O_LTIME:
		push_stack(p->tp, 1);
		out(P_LTIME);
		break;
	case O_STIME:
		push_stack(p->tp, 1);
		out(P_STIME);
		break;
	case O_RTIME:
		push_stack(p->tp, 1);
		out(P_RTIME);
		break;
	case O_GET:
		exp(p->op1);
		out(P_GET);
		pop_stack(0, 1);
		push_stack(p->tp, 0);
		break;
	case O_CHAR:
		exp(p->op1);
		break;
	case O_WORD:
		exp(p->op1);
		break;
	case O_LONG:
		exp(p->op1);
		break;
	case O_ADDR:
		if (p->op1->op == O_STAR) {
			exp(p->op1->op1);
		} else {
			yyerror("invalid use of '&'", 0,0,0,0,0,0);
		}
		break;
	case O_STAR:
	case O_STAR_INC:
	case O_STAR_DEC:
	case O_STAR_INC_P:
	case O_STAR_DEC_P:
		if (p->op1->op == O_ADDR) {
			exp(p->op1->op1);
		} else 
		if (p->op1->op == O_NAME && p->op1->o.n.d->loc != LOC_PROC) {
			push_stack(p->tp, 1);
			if (p->op1->o.n.d->loc == LOC_LOCAL) {
				if (LONG_TYPE(p->tp)) {
					out_const(P_LONG_L, p->op1->o.n.d->val);
				} else 	
				if (p->tp == TYPE_CHAR) {
					out_const(P_BYTE_L, p->op1->o.n.d->val);
				} else 	
				if (p->tp == TYPE_UCHAR) {
					out_const(P_UBYTE_L, p->op1->o.n.d->val);
				} else {	
					out_const(P_WORD_L, p->op1->o.n.d->val);
				}
			} else {
				if (LONG_TYPE(p->tp)) {
					out_const(P_LONG_G, p->op1->o.n.d->val);
				} else 	
				if (p->tp == TYPE_UCHAR) {
					out_const(P_UBYTE_G, p->op1->o.n.d->val);
				} else 	
				if (p->tp == TYPE_CHAR) {
					out_const(P_BYTE_G, p->op1->o.n.d->val);
				} else {	
					out_const(P_WORD_G, p->op1->o.n.d->val);
				}
			}
			if (p->op != O_STAR) {
				if (p->op == O_STAR_INC || p->op == O_STAR_DEC)
					push_stack(p->tp, 1);
				if (SCALAR_TYPE(p->op1->o.n.d->type)) {
					v = 1;
				} else 
				if (LONG_TYPE(p->op1->o.n.d->type-TYPE_INC)) {
					v = 4;
				} else 
				if (CHAR_TYPE(p->op1->o.n.d->type-TYPE_INC)) {
					v = 1;
				} else {
					v = 2;
				}
				if (p->op == O_STAR_DEC || p->op == O_STAR_DEC_P)
					v = -v;
				if (LONG_TYPE(p->op1->tp)) {
					out_const4(P_ADD_L_C, v);
				} else {
					out_const(P_ADD_C, v);
				}
				pop_stack(0, 1);
				push_stack(p->tp, 0);
				if (p->op1->o.n.d->loc == LOC_LOCAL) {
					if (LONG_TYPE(p->op1->o.n.d->type)) {
						out_const(P_SLONG_L, p->op1->o.n.d->val);
					} else 
					if (CHAR_TYPE(p->op1->o.n.d->type)) {
						out_const(P_SBYTE_L, p->op1->o.n.d->val);
					} else {	
						out_const(P_SWORD_L, p->op1->o.n.d->val);
					}
				} else {
					if (LONG_TYPE(p->op1->o.n.d->type)) {
						out_const(P_SLONG_G, p->op1->o.n.d->val);
					} else 	
					if (CHAR_TYPE(p->op1->o.n.d->type)) {
						out_const(P_SBYTE_G, p->op1->o.n.d->val);
					} else {	
						out_const(P_SWORD_G, p->op1->o.n.d->val);
					}
				}
				if (p->op == O_STAR_INC || p->op == O_STAR_DEC) 
					pop_stack(1, 1);
				}
			
		} else
		if (p->op1->op == O_ADD && p->op1->op1->op == O_NAME &&
		    p->op1->op1->o.n.d->loc != LOC_PROC && p->op1->op2->op == O_CONST) {
			push_stack(p->tp, 1);
			if (p->op1->op1->o.n.d->loc == LOC_LOCAL) {
				if (LONG_TYPE(p->tp)) {
					out_const(P_LONG_L, p->op1->op1->o.n.d->val+p->op1->op2->o.c.val);
				} else 	
				if (p->tp == TYPE_UCHAR) {
					out_const(P_UBYTE_L, p->op1->op1->o.n.d->val+p->op1->op2->o.c.val);
				} else 	
				if (p->tp == TYPE_CHAR) {
					out_const(P_BYTE_L, p->op1->op1->o.n.d->val+p->op1->op2->o.c.val);
				} else {	
					out_const(P_WORD_L, p->op1->op1->o.n.d->val+p->op1->op2->o.c.val);
				}
			} else {
				if (LONG_TYPE(p->tp)) {
					out_const(P_LONG_G, p->op1->op1->o.n.d->val+p->op1->op2->o.c.val);
				} else 	
				if (p->tp == TYPE_UCHAR) {
					out_const(P_UBYTE_G, p->op1->op1->o.n.d->val+p->op1->op2->o.c.val);
				} else 	
				if (p->tp == TYPE_CHAR) {
					out_const(P_BYTE_G, p->op1->op1->o.n.d->val+p->op1->op2->o.c.val);
				} else {	
					out_const(P_WORD_G, p->op1->op1->o.n.d->val+p->op1->op2->o.c.val);
				}
			}
		} else {
			if (p->op1->op == O_ADD && p->op1->op1->op == O_CONST) {
				pp = p->op1->op1;
				p->op1->op1 = p->op1->op2;
				p->op1->op1 = pp;
			} else
			if (p->op1->op == O_SUB && p->op1->op2->op == O_CONST) {
				p->op1->op = O_ADD;
				p->op1->op2->o.c.val = -p->op1->op2->o.c.val;
			} 
			if (p->op1->op == O_ADD && p->op1->op2->op == O_CONST) {
				exp(p->op1->op1);
				if (LONG_TYPE(p->tp)) {
					out_const(P_LOAD_L, p->op1->op2->o.c.val);
				} else 
				if (p->tp == TYPE_UCHAR) {
					out_const(P_LOAD_UB, p->op1->op2->o.c.val);
				} else 
				if (p->tp == TYPE_CHAR) {
					out_const(P_LOAD_B, p->op1->op2->o.c.val);
				} else {
					out_const(P_LOAD_W, p->op1->op2->o.c.val);
				}
			} else {
				exp(p->op1);
				if (LONG_TYPE(p->tp)) {
					out_const(P_LOAD_L, 0);
				} else 
				if (p->tp == TYPE_UCHAR) {
					out_const(P_LOAD_UB, 0);
				} else 
				if (p->tp == TYPE_CHAR) {
					out_const(P_LOAD_B, 0);
				} else {
					out_const(P_LOAD_W, 0);
				}
			}
			pop_stack(0, 1);
			push_stack(p->tp, 0);
		}
		break;
	case O_ASSIGN:
		exp(p->op2);
		if (p->op1->op1->op == O_NAME) {
			p = p->op1;
			if (p->op1->o.n.d->loc == LOC_PROC) {
				yyerror("invalid LHS of assignment", 0,0,0,0,0,0);
			} else
			if (p->op1->o.n.d->loc == LOC_LOCAL) {
				if (LONG_TYPE(p->op1->o.n.d->type)) {
					out_const(P_SLONG_L, p->op1->o.n.d->val);
				} else 	
				if (CHAR_TYPE(p->op1->o.n.d->type)) {
					out_const(P_SBYTE_L, p->op1->o.n.d->val);
				} else {	
					out_const(P_SWORD_L, p->op1->o.n.d->val);
				}
			} else {
				if (LONG_TYPE(p->op1->o.n.d->type)) {
					out_const(P_SLONG_G, p->op1->o.n.d->val);
				} else 	
				if (CHAR_TYPE(p->op1->o.n.d->type)) {
					out_const(P_SBYTE_G, p->op1->o.n.d->val);
				} else {	
					out_const(P_SWORD_G, p->op1->o.n.d->val);
				}
			}
			pop_stack(0, 1);
		} else
		if (p->op1->op1->op == O_ADD && p->op1->op1->op1->op == O_NAME && p->op1->op1->op2->op == O_CONST) {
			p = p->op1;
			if (p->op1->op1->o.n.d->loc == LOC_PROC) {
				yyerror("invalid LHS of assignment", 0,0,0,0,0,0);
			} else
			if (p->op1->op1->o.n.d->loc == LOC_LOCAL) {
				if (LONG_TYPE(p->op1->op1->o.n.d->type)) {
					out_const(P_SLONG_L, p->op1->op1->o.n.d->val+p->op1->op2->o.c.val);
				} else 	
				if (CHAR_TYPE(p->op1->op1->o.n.d->type)) {
					out_const(P_SBYTE_L, p->op1->op1->o.n.d->val+p->op1->op2->o.c.val);
				} else {	
					out_const(P_SWORD_L, p->op1->op1->o.n.d->val+p->op1->op2->o.c.val);
				}
			} else {
				if (LONG_TYPE(p->op1->op1->o.n.d->type)) {
					out_const(P_SLONG_G, p->op1->op1->o.n.d->val+p->op1->op2->o.c.val);
				} else 	
				if (CHAR_TYPE(p->op1->op1->o.n.d->type)) {
					out_const(P_SBYTE_G, p->op1->op1->o.n.d->val+p->op1->op2->o.c.val);
				} else {	
					out_const(P_SWORD_G, p->op1->op1->o.n.d->val+p->op1->op2->o.c.val);
				}
			}
			pop_stack(0, 1);
		} else {
			if (p->op1->op1->op == O_ADD &&  p->op1->op1->op1->op == O_CONST) {
				pp = p->op1->op1->op2;
				p->op1->op1->op2 = p->op1->op1->op1;
				p->op1->op1->op1 = pp;
			} else
			if (p->op1->op1->op == O_SUB &&  p->op1->op1->op2->op == O_CONST) {
				p->op1->op1->op2->o.c.val = - p->op1->op1->op2->o.c.val;
				p->op1->op1->op = O_ADD;
			} 
			if (p->op1->op1->op == O_ADD &&  p->op1->op1->op2->op == O_CONST) {
				exp(p->op1->op1->op1);
				if (LONG_TYPE(p->tp)) {
					out_const(P_STORE_L, p->op1->op1->op2->o.c.val);
				} else 
				if (CHAR_TYPE(p->tp)) {
					out_const(P_STORE_B, p->op1->op1->op2->o.c.val);
				} else {
					out_const(P_STORE_W, p->op1->op1->op2->o.c.val);
				}	
			} else {
				exp(p->op1->op1);
				if (LONG_TYPE(p->tp)) {
					out_const(P_STORE_L, 0);
				} else 
				if (CHAR_TYPE(p->tp)) {
					out_const(P_STORE_B, 0);
				} else {
					out_const(P_STORE_W, 0);
				}	
			}
			pop_stack(0, 1);
			pop_stack(0, 1);
		}
		break;
	case O_WIDENU:
		exp(p->op1);
		out(P_WIDENU);
		pop_stack(0, 1);
		push_stack(p->tp, 0);
		break;
	case O_WIDEN:
		exp(p->op1);
		out(P_WIDEN);
		pop_stack(0, 1);
		push_stack(p->tp, 0);
		break;
	case O_SHORTEN:
		exp(p->op1);
		out(P_SHORTEN);
		pop_stack(0, 1);
		push_stack(p->tp, 0);
		break;
	default:
		int_error("exp: %d", p->op,0,0,0,0);
	}
	return;
}
