#include <stdio.h>
#include "lex.h"
#include "code.h"

int need_launch;
extern int need_log;
int	launch_channel = 1;
int	launch_delta = 100;
int	launch_wait;
int	launch_initial_wait = 1000;
int	launch_rel = 0;
int	launch_delta_time = 100;

static void
yystring(char *code)
{
	yyopen_string(code);
	yydone(yyparse());
}

static char *logging_code;
static char *launch_logging_code;
static char *launch_only_code;
static char *logging_only_code;

extern char *int0, *int1, *int2, *int3;
extern int load_int();
int
code_intrinsics()
{
	char *cp, buffer[4096], *p, *pp;
	FILE *f;
	int i;
	
	if (!need_log && !need_launch)
		return(0);
		
	load_int();
	logging_code = int0;
	launch_logging_code = int1;
	launch_only_code = int2;
	logging_only_code = int3;
	if (need_log) {
		yystring(logging_code);
		if (need_launch) {
			cp = launch_logging_code;
		} else {
			cp = logging_only_code;
		}

	} else
	if (need_launch) {
		cp = launch_only_code;
	}
	sprintf(buffer, cp, launch_channel, 
			launch_delta,
			launch_wait,
			launch_initial_wait,
			launch_rel,
			launch_delta_time);
	yystring(buffer);
	return(1);
}

void
add_intrinsics(struct label *l)
{
	struct dict *dp;
	dp = find_name("___poll");
	if (dp == NULL) 
		int_error("can't find ___poll", 0,0,0,0,0);
	out_jmp(P_SET_POLL, dp->label);
	out_jmp(P_SET_TRAMPOLINE, l);
	dp = find_name("___extra");
	if (dp == NULL) 
		int_error("can't find ___extra", 0,0,0,0,0);
	out_jmp(P_SET_EXTRA, dp->label);
}
