/*
 *      Copyright (c) 1987 Paul Campbell
 *      All Rights Reserved
 *      THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Paul Campbell
 *      The copyright notice above does not evidence any
 *      actual or intended publication of such source code.
 */

#define	TYPE_INC	7
#define	TYPE_UNSIGNED	3

#define	TYPE_UNKNOWN		0
#define	TYPE_CHAR		1
#define	TYPE_WORD		2
#define	TYPE_LONG		3
#define	TYPE_UCHAR		(TYPE_CHAR+TYPE_UNSIGNED)
#define	TYPE_UWORD		(TYPE_WORD+TYPE_UNSIGNED)
#define	TYPE_ULONG		(TYPE_LONG+TYPE_UNSIGNED)
#define	TYPE_PROC		7
#define	TYPE_CHAR_IND		(TYPE_CHAR+TYPE_INC)
#define	TYPE_WORD_IND		(TYPE_WORD+TYPE_INC)
#define	TYPE_LONG_IND		(TYPE_LONG+TYPE_INC)
#define	TYPE_UCHAR_IND		(TYPE_UCHAR+TYPE_INC)
#define	TYPE_UWORD_IND		(TYPE_UWORD+TYPE_INC)
#define	TYPE_ULONG_IND		(TYPE_ULONG+TYPE_INC)
#define	TYPE_PROC_IND		(TYPE_PROC+TYPE_INC)
#define	TYPE_CHAR_IND_IND	(TYPE_CHAR+TYPE_INC+TYPE_INC)
#define	TYPE_WORD_IND_IND	(TYPE_WORD+TYPE_INC+TYPE_INC)
#define	TYPE_LONG_IND_IND	(TYPE_LONG+TYPE_INC+TYPE_INC)
#define	TYPE_UCHAR_IND_IND	(TYPE_UCHAR+TYPE_INC+TYPE_INC)
#define	TYPE_UWORD_IND_IND	(TYPE_UWORD+TYPE_INC+TYPE_INC)
#define	TYPE_ULONG_IND_IND	(TYPE_ULONG+TYPE_INC+TYPE_INC)
#define	TYPE_PROC_IND_IND	(TYPE_PROC+TYPE_INC_TYPE_INC)

#define	PROC_TYPE(x)		((x)==TYPE_PROC)
#define	CHAR_TYPE(x)		((x)==TYPE_CHAR || (x) == TYPE_UCHAR)
#define	WORD_TYPE(x)		((x)==TYPE_WORD || (x) == TYPE_UWORD)
#define	LONG_TYPE(x)		((x)==TYPE_LONG || (x) == TYPE_ULONG)
#define	SCALAR_TYPE(x)		((x)>=TYPE_CHAR && (x) <= TYPE_ULONG)
#define	PTR_TYPE(x)		((x)>=TYPE_CHAR_IND)
#define	UNSIGNED_TYPE(x)	(((x)>=TYPE_UCHAR && (x) <= TYPE_ULONG) || (x) >= TYPE_CHAR_IND)
#define	SIZE_TYPE(x)		(LONG_TYPE(x)?4:CHAR_TYPE(x)?1:2)
#define	SAME_SIZE_TYPE(x, y)	(SCALAR_TYPE(x)&&SCALAR_TYPE(y)&&((x)==(y) || (x)==((y)+TYPE_UNSIGNED) || (y)==((x)+TYPE_UNSIGNED)))

#define	LOC_UNKNOWN		0
#define	LOC_CONST		1
#define	LOC_PROC		2
#define	LOC_LOCAL		3
#define	LOC_GLOBAL		4
#define	LOC_STATE		5

#define O_PLIST		1 
#define O_ASSIGN	2 
#define O_LIST		3 
#define O_OROR		4 
#define O_ANDAND	5	 
#define O_LT		6	 
#define O_LE		7	 
#define O_GT		8	 
#define O_GE		9	 
#define O_NE		10	 
#define O_EQ		11	 
#define O_OR		12	 
#define O_AND		13 
#define O_XOR		14
#define O_LTLT		15
#define O_GTGT		16 
#define O_ADD		17 
#define O_SUB		18 
#define O_MUL		19 
#define O_DIV		20 
#define O_MINUS		21 
#define O_NOT		22 
#define O_TILDE		23 
#define O_INDEX		24 
#define O_CALL		25 
#define O_STAR 		27 
#define O_CALLV		28 
#define O_GET		29 
#define O_STRING	30	 
#define O_CONST		31 
#define O_NAME		32 
#define O_MOD		33 
#define O_CHAR		34 
#define O_WORD		35 
#define O_ADDR		36 
#define O_CHAR_IND	37
#define O_WORD_IND	38
#define O_TIME		39
#define O_LTIME		40
#define O_STAR_INC	41 
#define O_STAR_DEC	42 
#define O_STAR_INC_P	43 
#define O_STAR_DEC_P	44 
#define O_LONG		45 
#define O_LONG_IND	46
#define O_WIDEN		47
#define O_SHORTEN	48
#define O_CHOOSE	49
#define O_RTIME		50
#define O_SIZEOF	51
#define O_LOG_BASE	52
#define O_LOG_END	53
#define O_UCHAR		54 
#define O_UCHAR_IND	55
#define O_UWORD		56 
#define O_UWORD_IND	57
#define O_ULONG		58 
#define O_ULONG_IND	59
#define O_WIDENU	60
#define O_STIME		61

struct OHDR {
	unsigned char	Oop;
	unsigned char	Otp;
	unsigned short	Osz;
	unsigned short	Oline;
};


struct OP1 {
	struct	OP 	*o1;
};

struct OP2 {
	struct	OP 	*o1;
	struct	OP 	*o2;
};

struct OP3 {
	struct	OP 	*o1;
	struct	OP 	*o2;
	struct	OP 	*o3;
};

struct OP4 {
	struct	OP 	*o1;
	struct	OP 	*o2;
	struct	OP 	*o3;
	struct	OP 	*o4;
};

struct OPN {
	struct dict *d;
};

struct OPC {
	long val;
};

struct OPS {
	unsigned short	val;
};

struct OP {
	struct OHDR		oh;
	union {
		struct OP1 o1;
		struct OP2 o2;
		struct OP3 o3;
		struct OP4 o4;
		struct OPN n;
		struct OPC c;
		struct OPS s;
	}o;
};
#define HDR_SZ ((long)(&((struct OP *)0)->o.o1))

#define	op		oh.Oop
#define	tp		oh.Otp
#define	sz		oh.Osz
#define	line		oh.Oline
#define	op1		o.o4.o1
#define	op2		o.o4.o2
#define	op3		o.o4.o3
#define	op4		o.o4.o4

extern char *tree_name[];
extern char tree_size[];
extern int max_op;

struct dict {
	struct dict 	*lt;
	struct dict	*gt;
	unsigned char	valid;
	unsigned char	type;
	unsigned char	type_save;
	struct dict 	*param_next;
	unsigned short	size;
	unsigned short	size_save;
	unsigned short	val;
	unsigned short	val_save;
	unsigned char	loc;
	unsigned char	loc_save;
	unsigned char	array;
	unsigned char	array_save;
	struct label	*label;
	struct label	*label2;
	char		name[1];
};

struct fixup {
	unsigned short	offset;
	struct fixup	*next;
};

struct label {
	unsigned char 	state;
	unsigned short 	val;
	unsigned short 	tag;
	struct fixup	*waiting;
};

void yyerror(char *s, long a, long b, long c, long d, long e, long f);
void yywarnline(int err, char *s, long a, long b, long c, long d, long e, long f);
void yyerrline(int err, char *s, long a, long b, long c, long d, long e, long f);
void yyerrlinex(long err, char *s, long a, long b, long c, long d, long e, long f);
void emit1(unsigned char c1);
void emit2(unsigned char c1, unsigned char c2);
void emit3(unsigned char c1, unsigned char c2, unsigned char c3);
void set_val( struct dict *dp, unsigned short val, unsigned char b);
struct label *new_label();
int yylex();
void set_addr();
void dump_done();
void pmap(int flag);
void yyinit();
void yyrewind();
int yyopen(char *file);
int yyparse();
void yyclose();
void set_addr();
struct OP * constant(struct OP *p);
struct OP * types(struct OP *p, int type);
void first_state(struct OP *p);
void next_state(struct dict *p);
void start_state(struct dict *p);
void last_state();
void mid_state();
void end_state();
void end_halt();
void exit_state();
void event_int(int v);
void event_exp(struct OP *p);
void event_timeout(struct OP *p);
void event_input(struct dict *dp);
void event_idle();
void event_output();
void end_event();
void exp(struct OP *p);
void do_exp(struct OP *p);
void do_return(struct OP *p);
void do_assign(struct OP *p);
void use_label(struct label *l);
void set_label(struct label *l, struct label *l2);
void do_cond(int type, struct OP *p, struct label *l);
void do_uncond(struct label *l);
void enter_proc(int type, struct dict *name, struct OP *params, struct OP *locals);
void forward_proc(int type, struct dict *name);
void exit_proc();
int declare(int type, struct dict *name, int size, int array, int loc, int val);
void dec_const(struct dict *name, struct OP *p);
struct OP * build0(unsigned short type, struct OP *ln);
struct OP * build1(unsigned short type, struct OP *ln, struct OP *p1);
struct OP * build2(unsigned short type, struct OP *ln, struct OP *p1, struct OP *p2);
struct OP * build3(unsigned short type, struct OP *ln, struct OP *p1, struct OP *p2, struct OP *p3);
struct OP * build4(unsigned short type, struct OP *ln, struct OP *p1, struct OP *p2, struct OP *p3, struct OP *p4);
struct OP * build_name(struct dict *name);
struct OP * make_constant(long l);
struct OP * make_string(char *str);
void err_space();
void tree_free(struct OP *trp);
void tree_print(char *name, struct OP *trp, int ind);
void int_error(char *s, long a, long b, long c, long d, long e);
int alloc_reg();
void free_reg(int i);
int alloc_c();
int save_acc();
int save_r2();
int save_r3();
int save_c();
void free_c(int r);
void yydone(int x);
int code_instrinsics();
void do_found_launch();
void add_instrinsics(struct label *l);
extern int need_logging, need_launch;
int  yyopen_string(char *s);
extern int yyerrcount, yydebug;
extern int pc;
void out(int o);
void fixup(int tag, int offset, int pc);
void out_jmp(int o, struct label *l);
void out_lab(struct label *l) ;
void out_2(int val);
void out_4(long val);
void out_const(int o, int val);
void tag_label(struct label *l);
void event_launch();
void do_print_str(struct OP *p);
void do_print_val(struct OP *p);
void do_print_chr(struct OP *p);
void do_print_hex(struct OP *p);
void do_fire(struct OP *p);
void do_arm(struct OP *p);
void do_safe(struct OP *p);
void do_beep(struct OP *p);
struct OP *dup_tree(struct OP *p);
void do_log(struct OP *p1, struct OP *p2);
void do_set(struct OP *p1, struct OP *p2);
void do_log_ctl(struct OP *p1, struct OP *p2);
void do_eesave(struct OP *p1, struct OP *p2, struct OP *p3);
void do_eeload(struct OP *p1, struct OP *p2, struct OP *p3);
void retag_label(struct label *l, struct label *l2);
void log_code(char *type, struct dict *name);
void init_states();
void test_states();
void check_states();
void do_halt();
struct dict *find_name(char *name);
struct dict *add_name(char *name);
extern unsigned long yyline;
void do_set_log_full(struct OP *p1);
void start_case(struct OP *p);
void default_case(long val, int flag);
void emit_case(struct OP *p, int flag);
void case_begin();
void end_case();
void out_jmp_const(int o, long val, struct label *l);
void out_jmp_const_4(int o, long val, struct label *l);
void set_dafault();
extern int got_states;
