/*
 *      Copyright (c) 1991 Paul Campbell
 *      All Rights Reserved
 *      THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Paul Campbell
 *      The copyright notice above does not evidence any
 *      actual or intended publication of such source code.
 */
#define COMPILER 1
#pragma segment code
#include <stdio.h>
#include <stdlib.h>
#ifdef MPW
#include <osutils.h>
#endif
#include "lex.h"
#include "code.h"

extern int debug;
extern FILE *fcode;
int pc = 0;
extern char *op_name[];
void out_label(struct label *l);
static unsigned char *buff;
extern int	global_base;
char *sss;
extern int save_dest;
int sss_ind = 0;
int stack_size = 512;

#define	OC(x)	buff[pc++] = (x)

int xdbg = 0;
static int last_jmp = 0;
int last_uncond = 0;	// peephold for unconditionals

void
start_out()
{
	sss = (char *)malloc(64*1024);
	buff = (unsigned char *)malloc(64*1024);
}

void
out(int o)
{
	if (last_jmp)
		return;
	last_jmp = o == P_HALT;
	if (xdbg)
		printf("%04x:	%s\n", pc, op_name[o]);
	OC(o);
}

void
fixup(int tag, int offset, int pc)
{
	if (xdbg)
		printf("					fixed up L%d reference at %04x to point to %04x\n", 
			tag, offset, pc);
	buff[offset] = (pc-offset);
	buff[offset+1] = (pc-offset)>>8;

}

void
out_jmp(int o, struct label *l)
{
	if (last_jmp)
		return;
	last_jmp = o == P_JMP;
	if (xdbg)
		printf("%04x:	%s ", pc, op_name[o]);
	OC(o);
	out_label(l);
}

void
out_jmp_const(int o, long val, struct label *l)
{
	if (last_jmp)
		return;
	last_jmp = o == P_JMP;
	if (xdbg)
		printf("%04x:	%s ", pc, op_name[o]);
	OC(o);
	out_label(l);
	out_2(val);
}

void
out_jmp_const_4(int o, long val, struct label *l)
{
	if (last_jmp)
		return;
	last_jmp = o == P_JMP;
	if (xdbg)
		printf("%04x:	%s ", pc, op_name[o]);
	OC(o);
	out_label(l);
	out_4(val);
}

void
out_lab(struct label *l) 
{
	unsigned short v;

	if (xdbg)
		printf("L%d\n", l->tag);
	v = l->val-pc;
	OC(v);
	OC(v>>8);
	
}

void
out_2(int val)
{
	if (xdbg)
		printf("0x%x\n", val);
	OC(val);
	OC(val>>8);
}

void
out_4(long val)
{
	if (xdbg)
		printf("0x%x\n", val);
	OC(val);
	OC(val>>8);
	OC(val>>16);
	OC(val>>24);
}

void
out_const(int o, int val)
{
	if (last_jmp)
		return;
	last_jmp = o == P_RET;
	if (xdbg)
		printf("%04x:	%s ", pc, op_name[o]);
	OC(o);
	out_2(val);
}

void
out_const4(int o, int val)
{
	if (last_jmp)
		return;
	last_jmp = 0;
	if (xdbg)
		printf("%04x:	%s ", pc, op_name[o]);
	OC(o);
	out_4(val);
}

void
tag_label(struct label *l)
{
	last_jmp = 0;
	if (xdbg)
                printf("%04x:L%d:\n",pc,l->tag);
}

void
retag_label(struct label *l, struct label *l2)
{
	if (xdbg)
                printf("L%d=L%d\n",l->tag,l2->tag);
}

void 
log_code(char *type, struct dict *name)
{
	if (xdbg)
                printf("%s %s\n",type, name->name);
}



void
write_out()
{	
	int i, j, k, s;
	unsigned short addr_pc;
	struct code_hdr *hp;
	
	for (i = 0; i < sss_ind; i++)
		OC(sss[i]);
	addr_pc = 0;
	for (i = 0; i < pc; ) {
		j = pc - i;
		if (j > 32)
			j = 32;
		s = (j + (addr_pc&0xff) + ((addr_pc>>8)&0xff))&0xff;
		fprintf(fcode, "!%02X%04X00",j&0xff,addr_pc);
		for (k = 0; k < j; k++, i++) {
			s += buff[i]&0xff;
			fprintf(fcode, "%02X", buff[i]&0xff);
		}
		s = (256 - (s&0xff))&0xff;
		fprintf(fcode, "%02X%c%c", s, 13, 10);
		addr_pc += j;
	}
	hp = (struct code_hdr *)&buff[0];
	hp->magic = MAGIC;
	hp->cmd = (save_dest>= 0 ? 2 : 1);
	hp->dest = save_dest;
	hp->stack_size[0] = (stack_size);
	hp->stack_size[1] = (stack_size)>>8;
	hp->code_size[0] = (pc-sss_ind);
	hp->code_size[1] = (pc-sss_ind)>>8;
	hp->string_size[0] = sss_ind;
	hp->string_size[1] = sss_ind>>8;
	hp->global_size[0] = global_base;
	hp->global_size[1] = global_base>>8;
	fprintf(fcode, "!%02X000001", sizeof(*hp));
	s = 1;
	i = 0;
	for (k = 0; k < sizeof(*hp); k++, i++) {
		s += buff[i]&0xff;
		fprintf(fcode, "%02X", buff[i]&0xff);
	}
	s = (256 - (s&0xff))&0xff;
	fprintf(fcode, "%02X%c%c", s, 13, 10);
}
