#include <stdio.h>
#include <stdlib.h>
#include "code.h"

unsigned char *mem;
struct code_hdr hdr;
char *prog;
extern int max_xop;
extern char *op_name[];
extern char op_type[];
#define BASE	0x8000
#define TOP	0xfff0
char	logging = 0, inl = 0;
char	need_call_uv, need_POP, need_POPFP, need_PUSHFP, need_POP45, need_POP01, need_PUSH;
char	need_GE, need_GT, need_LT, need_LE, need_WIDEN, need_WIDENU;
char	need_GEU, need_GTU, need_LTU, need_LEU;
char	need_EQ, need_EQC, need_NE, need_LAUNCH;
char	need_OR, need_AND, need_XOR;
char	need_SHL, need_SHR, need_INDEX, need_ARM, need_SAFE;
int	lab=0;
char 	need_HALT, need_MUL, need_DIV, need_DIV_4_core, need_DIVU, need_POLL, need_INTR, need_PHEXL, need_DIV_2_core,
    	need_SAVE_TIME, need_CMP_TIME, need_INPUT, need_PVAL_core, need_MULU, need_MUL4_core,
    	need_FIRE, need_TIME, need_LTIME, need_LOG, need_RTIME,
    	need_LOG_CTL, need_BEEP, need_PSTR, need_PHEX, need_PVAL, need_PCHR,
    	need_EESAVE, need_EELOAD, need_GET, need_SET;
int stack_size = 512;

void debug(int x) {}
int postlude();
int postlude2();
int postlude3();
#ifdef MPW
#pragma segment t1
#endif

unsigned char 
get_8(FILE *f)
{
	int c = '\n';
	int r;
	
	while (c == '\n' || c == '\r' || c == '!')
		c = fgetc(f);
	if (c >= 'a' && c <= 'f') {
		r = (c-'a'+10)<<4;
	} else
	if (c >= 'A' && c <= 'F') {
		r = (c-'A'+10)<<4;
	} else {
		r = (c-'0')<<4;
	} 
	c = fgetc(f);
	if (c >= 'a' && c <= 'f') {
		r |= (c-'a'+10);
	} else
	if (c >= 'A' && c <= 'F') {
		r |= (c-'A'+10);
	} else {
		r |= (c-'0');
	} 
	return(r);
}

void
load_code(char *name)
{
	FILE *fin;
	long len, addr, tag, sum;
	unsigned char *pnt;
	
	if (name == NULL) {
		fprintf(stderr, "%s: Couldn't open input file\n", prog);
		exit(2);
	}
	fin = fopen(name, "r");
	if (fin == NULL) {
		fprintf(stderr, "%s: Couldn't open input file '%s'\n", prog, name);
		exit(2);
	}
	for (;;) {
		len = get_8(fin);
		addr = (get_8(fin))<<8;
		addr |= get_8(fin);
		tag = get_8(fin);
		if (tag == 1) {
			pnt = (unsigned char *)&hdr;
			if (len > sizeof(hdr))
				len - sizeof(hdr);
		} else {
			pnt = &mem[(BASE+addr)&0xffff];
		}
		while (len--)
			*pnt++ = get_8(fin);
		sum = get_8(fin);
		if (tag)
			break;
	}
	
	fclose(fin);
}

FILE *fcode;

char	need_SUB, need_NOT, need_ADD, need_ADDC;
char need_STORE;
void
STORE(int sz, int offset)	// dpl/dph has offset in it
{
	if (inl) {
		if (offset == 0) {
			fprintf(fcode, "	mov	dpl, r2\n");
			fprintf(fcode, "	mov	dph, r3\n");
		} else {
			fprintf(fcode, "	mov	a, r2\n");
			fprintf(fcode, "	add	a, dpl\n");
			fprintf(fcode, "	mov	dpl, a\n");
			fprintf(fcode, "	mov	a, r3\n");
			fprintf(fcode, "	addc	a, dph\n");
			fprintf(fcode, "	mov	dph, a\n");
		}
		if (sz >= 2 && offset == 0)
			fprintf(fcode, "	mov	a, r4\n");
		fprintf(fcode, "	movx	@dptr, a\n");
		if (sz >= 2) {
			fprintf(fcode, "	inc	dptr\n");
			fprintf(fcode, "	mov	a, r5\n");
			fprintf(fcode, "	movx	@dptr, a\n");
			if (sz >= 4) {
				fprintf(fcode, "	inc	dptr\n");
				fprintf(fcode, "	mov	a, r6\n");
				fprintf(fcode, "	movx	@dptr, a\n");
				fprintf(fcode, "	inc	dptr\n");
				fprintf(fcode, "	mov	a, r7\n");
				fprintf(fcode, "	movx	@dptr, a\n");
			}
		}
	} else {
		need_STORE |= (offset==0?sz<<4:sz);
		if (offset != 0)
			fprintf(fcode, "	mov	dptr, #0x%x\n", offset&0xffff);
		fprintf(fcode, "	lcall	STORE%s_%d\n", (offset==0?"0":""),sz);
	}
}

char need_LD_GLOBAL;
void
LD_GLOBAL(int sz, int offset)	// dpl/dph has offset in it
{
	int l1;

	if (inl) {
		fprintf(fcode, "	movx	a, @dptr\n");
		fprintf(fcode, "	mov	r2, a\n");
		if (sz == 1) {
			l1 = lab++;
			fprintf(fcode, "	jnb	acc.7, A%04x\n", l1);
			fprintf(fcode, "		mov	r3, #0xff\n");
			fprintf(fcode, "		sjmp	B%04x\n", l1);
			fprintf(fcode, "A%04x:\n", l1);
			fprintf(fcode, "		mov	r3, #0x0\n");
			fprintf(fcode, "B%04x:\n", l1);
		} else
		if (sz == 8) {	
			fprintf(fcode, "	mov	r3, #0\n");
		} else
		if (sz == 2) {	
			fprintf(fcode, "	inc	dptr\n");
			fprintf(fcode, "	movx	a, @dptr\n");
			fprintf(fcode, "	mov	r3, a\n");
		} else {
			fprintf(fcode, "	inc	dptr\n");
			fprintf(fcode, "	movx	a, @dptr\n");
			fprintf(fcode, "	mov	r3, a\n");
			fprintf(fcode, "	inc	dptr\n");
			fprintf(fcode, "	movx	a, @dptr\n");
			fprintf(fcode, "	mov	r0, a\n");
			fprintf(fcode, "	inc	dptr\n");
			fprintf(fcode, "	movx	a, @dptr\n");
			fprintf(fcode, "	mov	r1, a\n");
		}
	} else {
		need_LD_GLOBAL |= sz;
		fprintf(fcode, "	mov	dptr, #(LGP+0x%x)\n", offset);
		fprintf(fcode, "	lcall	LD_GLOBAL_%d\n", sz);
	}
}

char need_ST_GLOBAL;
void
ST_GLOBAL(int sz, int offset)	// dpl/dph has offset in it
{
	if (inl) {
		fprintf(fcode, "	mov	a, r2\n");
		fprintf(fcode, "	movx	@dptr, a\n");
		if (sz == 2) {	
			fprintf(fcode, "	inc	dptr\n");
			fprintf(fcode, "	mov	a, r3\n");
			fprintf(fcode, "	movx	@dptr, a\n");
		} else {
			fprintf(fcode, "	inc	dptr\n");
			fprintf(fcode, "	mov	a, r3\n");
			fprintf(fcode, "	movx	@dptr, a\n");
			fprintf(fcode, "	inc	dptr\n");
			fprintf(fcode, "	mov	a, r0\n");
			fprintf(fcode, "	movx	@dptr, a\n");
			fprintf(fcode, "	inc	dptr\n");
			fprintf(fcode, "	mov	a, r1\n");
			fprintf(fcode, "	movx	@dptr, a\n");
		}
	} else {
		need_ST_GLOBAL |= sz;
		fprintf(fcode, "	mov	dptr, #(LGP+0x%x)\n", offset);
		fprintf(fcode, "	lcall	ST_GLOBAL_%d\n", sz);
	}
}

char need_ST_LOCAL;
void
ST_LOCAL(int sz, int offset)	// dpl/dph has offset in it
{
	if (inl) {
		fprintf(fcode, "	mov	a, fp_lo\n");
		fprintf(fcode, "	add	a, dpl\n");
		fprintf(fcode, "	mov	dpl, a\n");
		fprintf(fcode, "	mov	a, fp_hi\n");
		fprintf(fcode, "	addc	a, dph\n");
		fprintf(fcode, "	mov	dph, a\n");

		fprintf(fcode, "	mov	a, r2\n");
		fprintf(fcode, "	movx	@dptr, a\n");
		if (sz == 2) {	
			fprintf(fcode, "	inc	dptr\n");
			fprintf(fcode, "	mov	a, r3\n");
			fprintf(fcode, "	movx	@dptr, a\n");
		} else {
			fprintf(fcode, "	inc	dptr\n");
			fprintf(fcode, "	mov	a, r3\n");
			fprintf(fcode, "	movx	@dptr, a\n");
			fprintf(fcode, "	inc	dptr\n");
			fprintf(fcode, "	mov	a, r0\n");
			fprintf(fcode, "	movx	@dptr, a\n");
			fprintf(fcode, "	inc	dptr\n");
			fprintf(fcode, "	mov	a, r1\n");
			fprintf(fcode, "	movx	@dptr, a\n");
		}
	} else {
		need_ST_LOCAL |= sz;
		fprintf(fcode, "	mov	dptr, #0x%x\n", offset&0xffff);
		fprintf(fcode, "	lcall	ST_LOCAL_%d\n", sz);
	}
}

char need_LD_LOCAL;
void
LD_LOCAL(int sz, int offset)	// dpl/dph has offset in it
{
	int l1;

	if (inl) {
		fprintf(fcode, "	mov	a, fp_lo\n");
		fprintf(fcode, "	add	a, dpl\n");
		fprintf(fcode, "	mov	dpl, a\n");
		fprintf(fcode, "	mov	a, fp_hi\n");
		fprintf(fcode, "	addc	a, dph\n");
		fprintf(fcode, "	mov	dph, a\n");

		fprintf(fcode, "	movx	a, @dptr\n");
		fprintf(fcode, "	mov	r2, a\n");
		if (sz == 1) {
			l1 = lab++;
			fprintf(fcode, "	jnb	acc.7, A%04x\n", l1);
			fprintf(fcode, "		mov	r3, #0xff\n");
			fprintf(fcode, "		sjmp	B%04x\n", l1);
			fprintf(fcode, "A%04x:\n", l1);
			fprintf(fcode, "		mov	r3, #0x0\n");
			fprintf(fcode, "B%04x:\n", l1);
		} else
		if (sz == 8) {	
			fprintf(fcode, "	mov	r3, #0\n");
		} else
		if (sz == 2) {	
			fprintf(fcode, "	inc	dptr\n");
			fprintf(fcode, "	movx	a, @dptr\n");
			fprintf(fcode, "	mov	r3, a\n");
		} else {
			fprintf(fcode, "	inc	dptr\n");
			fprintf(fcode, "	movx	a, @dptr\n");
			fprintf(fcode, "	mov	r3, a\n");
			fprintf(fcode, "	inc	dptr\n");
			fprintf(fcode, "	movx	a, @dptr\n");
			fprintf(fcode, "	mov	r0, a\n");
			fprintf(fcode, "	inc	dptr\n");
			fprintf(fcode, "	movx	a, @dptr\n");
			fprintf(fcode, "	mov	r1, a\n");
		}
	} else {
		need_LD_LOCAL |= sz;
		fprintf(fcode, "	mov	dptr, #0x%x\n", offset&0xffff);
		fprintf(fcode, "	lcall	LD_LOCAL_%d\n", sz);
	}
}

char need_LOAD;
void
LOAD(int sz, int offset)
{
	int l1;

	if (inl) {
		if (offset == 0) {
			fprintf(fcode, "	mov	dpl, r2\n");
			fprintf(fcode, "	mov	dph, r3\n");
		} else {
			fprintf(fcode, "	mov	a, r2\n");
			fprintf(fcode, "	add	a, dpl\n");
			fprintf(fcode, "	mov	dpl, a\n");
			fprintf(fcode, "	mov	a, r3\n");
			fprintf(fcode, "	addc	a, dph\n");
			fprintf(fcode, "	mov	dph, a\n");
		}
		fprintf(fcode, "	movx	a, @dptr\n");
		fprintf(fcode, "	mov	r2, a\n");
		if (sz == 1) {
			l1 = lab++;
			fprintf(fcode, "	jnb	acc.7, A%04x\n", l1);
			fprintf(fcode, "		mov	r3, #0xff\n");
			fprintf(fcode, "		sjmp	B%04x\n", l1);
			fprintf(fcode, "A%04x:\n", l1);
			fprintf(fcode, "		mov	r3, #0x0\n");
			fprintf(fcode, "B%04x:\n", l1);
		} else
		if (sz == 8) {	
			fprintf(fcode, "	mov	r3, #0\n");
		} else
		if (sz == 2) {	
			fprintf(fcode, "	inc	dptr\n");
			fprintf(fcode, "	movx	a, @dptr\n");
			fprintf(fcode, "	mov	r3, a\n");
		} else {
			fprintf(fcode, "	inc	dptr\n");
			fprintf(fcode, "	movx	a, @dptr\n");
			fprintf(fcode, "	mov	r3, a\n");
			fprintf(fcode, "	inc	dptr\n");
			fprintf(fcode, "	movx	a, @dptr\n");
			fprintf(fcode, "	mov	r0, a\n");
			fprintf(fcode, "	inc	dptr\n");
			fprintf(fcode, "	movx	a, @dptr\n");
			fprintf(fcode, "	mov	r1, a\n");
		}
	} else {
		need_LOAD |= (offset==0?sz<<4:sz);
		if (offset != 0)
			fprintf(fcode, "	mov	dptr, #0x%x\n", offset&0xffff);
		fprintf(fcode, "	lcall	LOAD%s_%d\n", (offset==0?"0":""),sz);
	}
}

void
NOT(int sz)
{
	int l1;
	if (inl) {
		fprintf(fcode, "	mov	a, r2\n");
		fprintf(fcode, "	orl	a, r3\n");
		if (sz) {
			fprintf(fcode, "	orl	a, r0\n");
			fprintf(fcode, "	orl	a, r1\n");
		}
		fprintf(fcode, "	jnz	V%04x\n",l1=lab++);
		fprintf(fcode, "	mov	r2, #0xff\n");
		fprintf(fcode, "	sjmp	W%04x\n",l1);
		fprintf(fcode, "V%04x:\n", l1);
		fprintf(fcode, "	mov	r2, #0\n");
		fprintf(fcode, "W%04x:\n", l1);
		fprintf(fcode, "	mov	r3, r2\n");
	} else {
		need_NOT |= (sz?2:1);
		fprintf(fcode, "	lcall	NOT_%d\n", (sz?4:2));
	}
}

void
SUB(int sz)
{
	if (inl) {
		fprintf(fcode, "	mov	dpl, sp_lo\n");
		fprintf(fcode, "	mov	dph, sp_hi\n");

		fprintf(fcode, "	clr	c\n");

		fprintf(fcode, "	movx	a, @dptr\n");
		fprintf(fcode, "	inc	dptr\n");
		fprintf(fcode, "	subb	a, r2\n");
		fprintf(fcode, "	mov	r2, a\n");

		fprintf(fcode, "	movx	a, @dptr\n");
		fprintf(fcode, "	inc	dptr\n");
		fprintf(fcode, "	subb	a, r3\n");
		fprintf(fcode, "	mov	r3, a\n");
		if (sz) {
			fprintf(fcode, "	movx	a, @dptr\n");
			fprintf(fcode, "	inc	dptr\n");
			fprintf(fcode, "	subb	a, r0\n");
			fprintf(fcode, "	mov	r0, a\n");

			fprintf(fcode, "	movx	a, @dptr\n");
			fprintf(fcode, "	inc	dptr\n");
			fprintf(fcode, "	subb	a, r1\n");
			fprintf(fcode, "	mov	r1, a\n");
		}
		fprintf(fcode, "	mov	sp_lo, dpl\n");
		fprintf(fcode, "	mov	sp_hi, dph\n");
	} else {
		need_SUB |= (sz?2:1);
		fprintf(fcode, "	lcall	SUB_%d\n",(sz?4:2));
	}
}
void
ADDC(int sz)
{
	if (inl) {
		fprintf(fcode, "	mov	a, r4\n");
		fprintf(fcode, "	add	a, r2\n");
		fprintf(fcode, "	mov	r2, a\n");

		fprintf(fcode, "	mov	a, r5\n");
		fprintf(fcode, "	addc	a, r3\n");
		fprintf(fcode, "	mov	r3, a\n");
		if (sz) {
			fprintf(fcode, "	mov	a, r6\n");
			fprintf(fcode, "	addc	a, r0\n");
			fprintf(fcode, "	mov	r0, a\n");

			fprintf(fcode, "	mov	a, r7\n");
			fprintf(fcode, "	addc	a, r1\n");
			fprintf(fcode, "	mov	r1, a\n");
		}
	} else {
		need_ADDC |= (sz?2:1);
		fprintf(fcode, "	lcall	ADDC_%d\n",(sz?4:2));
	}
}
void
ADD(int sz)
{
	if (inl) {
		fprintf(fcode, "	mov	dpl, sp_lo\n");
		fprintf(fcode, "	mov	dph, sp_hi\n");

		fprintf(fcode, "	movx	a, @dptr\n");
		fprintf(fcode, "	inc	dptr\n");
		fprintf(fcode, "	add	a, r2\n");
		fprintf(fcode, "	mov	r2, a\n");

		fprintf(fcode, "	movx	a, @dptr\n");
		fprintf(fcode, "	inc	dptr\n");
		fprintf(fcode, "	addc	a, r3\n");
		fprintf(fcode, "	mov	r3, a\n");
		if (sz) {
			fprintf(fcode, "	movx	a, @dptr\n");
			fprintf(fcode, "	inc	dptr\n");
			fprintf(fcode, "	addc	a, r0\n");
			fprintf(fcode, "	mov	r0, a\n");

			fprintf(fcode, "	movx	a, @dptr\n");
			fprintf(fcode, "	inc	dptr\n");
			fprintf(fcode, "	addc	a, r1\n");
			fprintf(fcode, "	mov	r1, a\n");
		}
		fprintf(fcode, "	mov	sp_lo, dpl\n");
		fprintf(fcode, "	mov	sp_hi, dph\n");
	} else {
		need_ADD |= (sz?2:1);
		fprintf(fcode, "	lcall	ADD_%d\n",(sz?4:2));
	}
}

void
WIDENU()
{
	fprintf(fcode, "	mov	r0, #0\n");
	fprintf(fcode, "	mov	r1, #0\n");
}
void
WIDEN()
{
	int l1;
	if (inl) {
		fprintf(fcode, "	mov	a, r3\n");
		fprintf(fcode, "	rlc	a\n");
		fprintf(fcode, "	jc	Y%04x\n",l1=lab++);
		fprintf(fcode, "	mov	r0, #0\n");
		fprintf(fcode, "	sjmp	X%04x\n",l1);
		fprintf(fcode, "Y%04x:\n",l1);
		fprintf(fcode, "	mov	r0, #0xff\n");
		fprintf(fcode, "X%04x:\n",l1);
		fprintf(fcode, "	mov	r1, r0_0\n");
	} else {
		need_WIDEN=1;
		fprintf(fcode, " 	lcall	WIDEN\n");
	}
}
void
SHL(int sz)
{
	int l1;
	if (inl) {
		fprintf(fcode, "	mov	a, r4\n");
		fprintf(fcode, "	jz	W%04x\n",l1=lab++);
		fprintf(fcode, "V%04x:\n", l1);
		fprintf(fcode, "	mov	a, r2\n");
		fprintf(fcode, "	add	a, r2\n");
		fprintf(fcode, "	mov	r2, a\n");
		fprintf(fcode, "	mov	a, r3\n");
		fprintf(fcode, "	addc	a, r3\n");
		fprintf(fcode, "	mov	r3, a\n");
		if (sz) {
			fprintf(fcode, "	mov	a, r0\n");
			fprintf(fcode, "	addc	a, r0\n");
			fprintf(fcode, "	mov	r0, a\n");
			fprintf(fcode, "	mov	a, r1\n");
			fprintf(fcode, "	addc	a, r1\n");
			fprintf(fcode, "	mov	r1, a\n");
		}
		fprintf(fcode, "	djnz	r4, V%04x\n",l1);
		fprintf(fcode, "W%04x:\n", l1);
	} else {
		need_SHL |= (sz?2:1);
		fprintf(fcode, "	lcall	SHL_%d\n", (sz?4:2));
	}
}
void
INDEX(int sz)
{
	if (inl) {
		fprintf(fcode, "	mov	a, r2\n");
		fprintf(fcode, "	add	a, r2\n");
		fprintf(fcode, "	mov	r2, a\n");
		fprintf(fcode, "	mov	a, r3\n");
		fprintf(fcode, "	addc	a, r3\n");
		fprintf(fcode, "	mov	r3, a\n");
		if (sz) {
			fprintf(fcode, "	mov	a, r2\n");
			fprintf(fcode, "	addc	a, r2\n");
			fprintf(fcode, "	mov	r2, a\n");
			fprintf(fcode, "	mov	a, r3\n");
			fprintf(fcode, "	addc	a, r3\n");
			fprintf(fcode, "	mov	r3, a\n");
		}
	} else {
		need_INDEX |= (sz?2:1);
		fprintf(fcode, "	lcall	INDEX_%d\n", (sz?4:2));
	}
}

void
SHR(int sz)
{
	int l1;
	if (inl) {
		fprintf(fcode, "	mov	a, r4\n");
		fprintf(fcode, "	jz	W%04x\n",l1=lab++);
		fprintf(fcode, "V%04x:\n", l1);
		fprintf(fcode, "	clr	c\n");
		if (sz) {
			fprintf(fcode, "	mov	a, r1\n");
			fprintf(fcode, "	rrc	a\n");
			fprintf(fcode, "	mov	r1, a\n");
			fprintf(fcode, "	mov	a, r0\n");
			fprintf(fcode, "	rrc	a\n");
			fprintf(fcode, "	mov	r0, a\n");
		}
		fprintf(fcode, "	mov	a, r3\n");
		fprintf(fcode, "	rrc	a\n");
		fprintf(fcode, "	mov	r3, a\n");
		fprintf(fcode, "	mov	a, r2\n");
		fprintf(fcode, "	rrc	a\n");
		fprintf(fcode, "	mov	r2, a\n");
		fprintf(fcode, "	djnz	r4, V%04x\n",l1);
		fprintf(fcode, "W%04x:\n", l1);
	} else {
		need_SHR |= (sz?2:1);
		fprintf(fcode, "	lcall	SHR_%d\n", (sz?4:2));
	}
}

void
OR(int sz)
{
	if (inl) {
		fprintf(fcode, "	mov	dpl, sp_lo\n");
		fprintf(fcode, "	mov	dph, sp_hi\n");

		fprintf(fcode, "	movx	a, @dptr\n");
		fprintf(fcode, "	inc	dptr\n");
		fprintf(fcode, "	orl	a, r2\n");
		fprintf(fcode, "	mov	r2, a\n");

		fprintf(fcode, "	movx	a, @dptr\n");
		fprintf(fcode, "	inc	dptr\n");
		fprintf(fcode, "	orl	a, r3\n");
		fprintf(fcode, "	mov	r3, a\n");
		if (sz) {
			fprintf(fcode, "	movx	a, @dptr\n");
			fprintf(fcode, "	inc	dptr\n");
			fprintf(fcode, "	orl	a, r0\n");
			fprintf(fcode, "	mov	r0, a\n");

			fprintf(fcode, "	movx	a, @dptr\n");
			fprintf(fcode, "	inc	dptr\n");
			fprintf(fcode, "	orl	a, r1\n");
			fprintf(fcode, "	mov	r1, a\n");
		}
		fprintf(fcode, "	mov	sp_lo, dpl\n");
		fprintf(fcode, "	mov	sp_hi, dph\n");
	} else {
		need_OR |= (sz?2:1);
		fprintf(fcode, "	lcall	OR_%d\n",(sz?4:2));
	}
}
void
XOR(int sz)
{
	if (inl) {
		fprintf(fcode, "	mov	dpl, sp_lo\n");
		fprintf(fcode, "	mov	dph, sp_hi\n");

		fprintf(fcode, "	movx	a, @dptr\n");
		fprintf(fcode, "	inc	dptr\n");
		fprintf(fcode, "	xrl	a, r2\n");
		fprintf(fcode, "	mov	r2, a\n");

		fprintf(fcode, "	movx	a, @dptr\n");
		fprintf(fcode, "	inc	dptr\n");
		fprintf(fcode, "	xrl	a, r3\n");
		fprintf(fcode, "	mov	r3, a\n");
		if (sz) {
			fprintf(fcode, "	movx	a, @dptr\n");
			fprintf(fcode, "	inc	dptr\n");
			fprintf(fcode, "	xrl	a, r0\n");
			fprintf(fcode, "	mov	r0, a\n");

			fprintf(fcode, "	movx	a, @dptr\n");
			fprintf(fcode, "	inc	dptr\n");
			fprintf(fcode, "	xrl	a, r1\n");
			fprintf(fcode, "	mov	r1, a\n");
		}
		fprintf(fcode, "	mov	sp_lo, dpl\n");
		fprintf(fcode, "	mov	sp_hi, dph\n");
	} else {
		need_XOR |= (sz?2:1);
		fprintf(fcode, "	lcall	XOR_%d\n",(sz?4:2));
	}
}
void
AND(int sz)
{
	if (inl) {
		fprintf(fcode, "	mov	dpl, sp_lo\n");
		fprintf(fcode, "	mov	dph, sp_hi\n");

		fprintf(fcode, "	movx	a, @dptr\n");
		fprintf(fcode, "	inc	dptr\n");
		fprintf(fcode, "	anl	a, r2\n");
		fprintf(fcode, "	mov	r2, a\n");

		fprintf(fcode, "	movx	a, @dptr\n");
		fprintf(fcode, "	inc	dptr\n");
		fprintf(fcode, "	anl	a, r3\n");
		fprintf(fcode, "	mov	r3, a\n");
		if (sz) {
			fprintf(fcode, "	movx	a, @dptr\n");
			fprintf(fcode, "	inc	dptr\n");
			fprintf(fcode, "	anl	a, r0\n");
			fprintf(fcode, "	mov	r0, a\n");

			fprintf(fcode, "	movx	a, @dptr\n");
			fprintf(fcode, "	inc	dptr\n");
			fprintf(fcode, "	anl	a, r1\n");
			fprintf(fcode, "	mov	r1, a\n");
		}
		fprintf(fcode, "	mov	sp_lo, dpl\n");
		fprintf(fcode, "	mov	sp_hi, dph\n");
	} else {
		need_AND |= (sz?2:1);
		fprintf(fcode, "	lcall	AND_%d\n",(sz?4:2));
	}
}
void
PUSH(int sz)
{
	if (inl) {
		fprintf(fcode, "	clr	c\n");
		fprintf(fcode, "	mov	a, sp_lo\n");
		fprintf(fcode, "	subb	a, #%d\n", (sz?4:2));
		fprintf(fcode, "	mov	dpl, a\n");
		fprintf(fcode, "	mov	sp_lo, a\n");
		fprintf(fcode, "	mov	a, sp_hi\n");
		fprintf(fcode, "	subb	a, #0\n");
		fprintf(fcode, "	mov	dph, a\n");
		fprintf(fcode, "	mov	sp_hi, a\n");
		fprintf(fcode, "	mov	a, r2\n");
		fprintf(fcode, "	movx	@dptr, a\n");
		fprintf(fcode, "	inc	dptr\n");
		fprintf(fcode, "	mov	a, r3\n");
		fprintf(fcode, "	movx	@dptr, a\n");
		if (sz) {
			fprintf(fcode, "	inc	dptr\n");
			fprintf(fcode, "	mov	a, r0\n");
			fprintf(fcode, "	movx	@dptr, a\n");
			fprintf(fcode, "	inc	dptr\n");
			fprintf(fcode, "	mov	a, r1\n");
			fprintf(fcode, "	movx	@dptr, a\n");
		}
		
	} else {
		need_PUSH  |= (sz?2:1);
		fprintf(fcode, "	lcall	PUSH_%d\n",(sz?4:2));
	}
}

void
PUSHFP(int large)
{
	if (inl) {
		fprintf(fcode, "	clr	c\n");
		fprintf(fcode, "	mov	a, sp_lo\n");
		fprintf(fcode, "	subb	a, #%d\n", large?4:2);
		fprintf(fcode, "	mov	dpl, a\n");
		fprintf(fcode, "	mov	sp_lo, a\n");
		fprintf(fcode, "	mov	a, sp_hi\n");
		fprintf(fcode, "	subb	a, #0\n");
		fprintf(fcode, "	mov	dph, a\n");
		fprintf(fcode, "	mov	sp_hi, a\n");


		if (large) {
			fprintf(fcode, "	mov	a, fp_lo\n");
			fprintf(fcode, "	movx	@dptr, a\n");
			fprintf(fcode, "	inc	dptr\n");
			fprintf(fcode, "	mov	a, fp_hi\n");
			fprintf(fcode, "	movx	@dptr, a\n");
			fprintf(fcode, "	inc	dptr\n");
		}
		fprintf(fcode, "	mov	a, r2\n");
		fprintf(fcode, "	movx	@dptr, a\n");
		fprintf(fcode, "	inc	dptr\n");
		fprintf(fcode, "	mov	a, r3\n");
		fprintf(fcode, "	movx	@dptr, a\n");

	} else {
		need_PUSHFP |= (large?2:1);
		fprintf(fcode, "	lcall	PUSHFP_%c\n",(large?'L':'S'));
	}
}

void
POPFP(int large)
{
	if (inl) {
		fprintf(fcode, "	mov	dpl, sp_lo\n");
		fprintf(fcode, "	mov	dph, sp_hi\n");
		if (large) {
			fprintf(fcode, "	movx	a, @dptr\n");
			fprintf(fcode, "	mov	fp_lo, a\n");
			fprintf(fcode, "	inc	dptr\n");
			fprintf(fcode, "	movx	a, @dptr\n");
			fprintf(fcode, "	mov	fp_hi, a\n");
			fprintf(fcode, "	inc	dptr\n");
		}
		fprintf(fcode, "	movx	a, @dptr\n");
		fprintf(fcode, "	mov	r4, a\n");
		fprintf(fcode, "	inc	dptr\n");
		fprintf(fcode, "	movx	a, @dptr\n");
		fprintf(fcode, "	mov	r5, a\n");
		fprintf(fcode, "	inc	dptr\n");
		fprintf(fcode, "	mov	sp_lo, dpl\n");
		fprintf(fcode, "	mov	sp_hi, dph\n");
	} else {
		need_POPFP |= (large?2:1);
		fprintf(fcode, "	lcall	POPFP_%c\n", (large?'L':'S'));
	}
}

void
POP(int sz)
{
	if (inl) {
		fprintf(fcode, "	mov	dpl, sp_lo\n");
		fprintf(fcode, "	mov	dph, sp_hi\n");
		fprintf(fcode, "	movx	a, @dptr\n");
		fprintf(fcode, "	mov	r2, a\n");
		fprintf(fcode, "	inc	dptr\n");
		fprintf(fcode, "	movx	a, @dptr\n");
		fprintf(fcode, "	mov	r3, a\n");
		fprintf(fcode, "	inc	dptr\n");
		if (sz) {
			fprintf(fcode, "	movx	a, @dptr\n");
			fprintf(fcode, "	mov	r0, a\n");
			fprintf(fcode, "	inc	dptr\n");

			fprintf(fcode, "	movx	a, @dptr\n");
			fprintf(fcode, "	mov	r1, a\n");
			fprintf(fcode, "	inc	dptr\n");
		}
		fprintf(fcode, "	mov	sp_lo, dpl\n");
		fprintf(fcode, "	mov	sp_hi, dph\n");
	} else {
		need_POP |= (sz?2:1);
		fprintf(fcode, "	lcall	POP_%d\n", (sz?4:2));
	}
}

void
POP45(int sz)
{
	if (inl) {
		fprintf(fcode, "	mov	dpl, sp_lo\n");
		fprintf(fcode, "	mov	dph, sp_hi\n");
		fprintf(fcode, "	movx	a, @dptr\n");
		fprintf(fcode, "	mov	r4, a\n");
		if (sz < 2) {
			fprintf(fcode, "	inc	dptr\n");
			fprintf(fcode, "	movx	a, @dptr\n");
			fprintf(fcode, "	mov	r5, a\n");
			fprintf(fcode, "	inc	dptr\n");
			if (sz) {
				fprintf(fcode, "	movx	a, @dptr\n");
				fprintf(fcode, "	inc	dptr\n");
				fprintf(fcode, "	mov	r6, a\n");
				fprintf(fcode, "	movx	a, @dptr\n");
				fprintf(fcode, "	mov	r7, a\n");
				fprintf(fcode, "	inc	dptr\n");
			}
		} else {
			fprintf(fcode, "	inc	dptr\n");
			fprintf(fcode, "	inc	dptr\n");
		}
		fprintf(fcode, "	mov	sp_lo, dpl\n");
		fprintf(fcode, "	mov	sp_hi, dph\n");
	} else { 
		need_POP45 |= (sz==2?4:sz==1?2:1);
		fprintf(fcode, "	lcall	POP45_%d\n",(sz==2?1:sz==1?4:2));
	}
}

void
POP01()
{
	if (inl) {
		fprintf(fcode, "	mov	dpl, sp_lo\n");
		fprintf(fcode, "	mov	dph, sp_hi\n");
		fprintf(fcode, "	movx	a, @dptr\n");
		fprintf(fcode, "	mov	r0, a\n");
		fprintf(fcode, "	inc	dptr\n");
		fprintf(fcode, "	movx	a, @dptr\n");
		fprintf(fcode, "	mov	r1, a\n");
		fprintf(fcode, "	inc	dptr\n");
		fprintf(fcode, "	mov	sp_lo, dpl\n");
		fprintf(fcode, "	mov	sp_hi, dph\n");
	} else {
		need_POP01 = 1;
		fprintf(fcode, "	lcall	POP01\n");
	}
}

void
GEU(int sz)
{	
	int l1;
	if (inl) {
		fprintf(fcode, "	mov	dpl, sp_lo\n");
		fprintf(fcode, "	mov	dph, sp_hi\n");

		fprintf(fcode, "	movx	a, @dptr\n");
		fprintf(fcode, "	mov	r4, a\n");
		fprintf(fcode, "	inc	dptr\n");

		fprintf(fcode, "	movx	a, @dptr\n");
		fprintf(fcode, "	inc	dptr\n");
		l1 = lab++;
		if (sz) {
			fprintf(fcode, "	mov	r5, a\n");

			fprintf(fcode, "	movx	a, @dptr\n");
			fprintf(fcode, "	mov	r6, a\n");
			fprintf(fcode, "	inc	dptr\n");

			fprintf(fcode, "	movx	a, @dptr\n");
			fprintf(fcode, "	inc	dptr\n");

			fprintf(fcode, "	cjne	a, r1_0, A%04x\n",l1);
	
			fprintf(fcode, "	mov	a, r6\n");
			fprintf(fcode, "	cjne	a, r0_0, A%04x\n",l1);
			fprintf(fcode, "	mov	a, r5\n");
		}

		fprintf(fcode, "	cjne	a, r3_0, A%04x\n",l1);

		fprintf(fcode, "	mov	a, r4\n");
		fprintf(fcode, "	cjne	a, r2_0, A%04x\n",l1);

		fprintf(fcode, "Z%04x:\n", l1);
		fprintf(fcode, "	mov	r2, #0xff\n");
		fprintf(fcode, "	sjmp	V%04x\n",l1);

		fprintf(fcode, "A%04x:\n", l1);
		fprintf(fcode, "	jnc	Z%04x\n",l1);
		fprintf(fcode, "	mov	r2, #0\n");
		fprintf(fcode, "V%04x:\n", l1);
		fprintf(fcode, "	mov	r3, r2_0\n");

		fprintf(fcode, "	mov	sp_lo, dpl\n");
		fprintf(fcode, "	mov	sp_hi, dph\n");
	} else {
		need_GEU |= (sz?2:1);
		fprintf(fcode, "	lcall	GEU_%d\n", (sz?4:2));
	}
}
void
GE(int sz)
{	
	int l1;
	if (inl) {
		fprintf(fcode, "	mov	dpl, sp_lo\n");
		fprintf(fcode, "	mov	dph, sp_hi\n");

		fprintf(fcode, "	movx	a, @dptr\n");
		fprintf(fcode, "	mov	r4, a\n");
		fprintf(fcode, "	inc	dptr\n");

		fprintf(fcode, "	movx	a, @dptr\n");
		fprintf(fcode, "	inc	dptr\n");
		fprintf(fcode, "	mov	r5, a\n");
		l1 = lab++;
		if (sz) {

			fprintf(fcode, "	movx	a, @dptr\n");
			fprintf(fcode, "	mov	r6, a\n");
			fprintf(fcode, "	inc	dptr\n");

			fprintf(fcode, "	movx	a, @dptr\n");
			fprintf(fcode, "	mov	r7, a\n");
			fprintf(fcode, "	inc	dptr\n");

			fprintf(fcode, "	cjne	a, r1_0, B%04x\n",l1);
	
			fprintf(fcode, "	mov	a, r6\n");
			fprintf(fcode, "	cjne	a, r0_0, A%04x\n",l1);
			fprintf(fcode, "	mov	a, r5\n");
			fprintf(fcode, "	cjne	a, r3_0, A%04x\n",l1);
		} else {
			fprintf(fcode, "	cjne	a, r3_0, B%04x\n",l1);
		}

		fprintf(fcode, "	mov	a, r4\n");
		fprintf(fcode, "	cjne	a, r2_0, A%04x\n",l1);

		fprintf(fcode, "Z%04x:\n", l1);
		fprintf(fcode, "	mov	r2, #0xff\n");
		fprintf(fcode, "	sjmp	V%04x\n",l1);

		fprintf(fcode, "C%04x:\n", l1);
		fprintf(fcode, "	mov	a, r%d\n", (sz?1:3));
		fprintf(fcode, "	jb	acc.7, Z%04x\n", l1);
		fprintf(fcode, "	sjmp	D%04x\n", l1);
		fprintf(fcode, "B%04x:\n", l1);
		fprintf(fcode, "	mov	a, r%d\n", (sz?7:5));
		fprintf(fcode, "	xrl	a, r%d\n", (sz?1:3));
		fprintf(fcode, "	jb	acc.7, C%04x\n", l1);
		fprintf(fcode, "	mov	a, r%d\n", (sz?1:3));
		fprintf(fcode, "	jnb	acc.7, A%04x\n", l1);
		fprintf(fcode, "	cpl	c\n");
		
		fprintf(fcode, "A%04x:\n", l1);
		fprintf(fcode, "	jnc	Z%04x\n",l1);
		fprintf(fcode, "D%04x:\n", l1);
		fprintf(fcode, "	mov	r2, #0\n");
		fprintf(fcode, "V%04x:\n", l1);
		fprintf(fcode, "	mov	r3, r2_0\n");

		fprintf(fcode, "	mov	sp_lo, dpl\n");
		fprintf(fcode, "	mov	sp_hi, dph\n");
	} else {
		need_GE |= (sz?2:1);
		fprintf(fcode, "	lcall	GE_%d\n", (sz?4:2));
	}
}
void
GTU(int sz)
{
	int l1;
	if (inl) {
		fprintf(fcode, "	mov	dpl, sp_lo\n");
		fprintf(fcode, "	mov	dph, sp_hi\n");

		fprintf(fcode, "	movx	a, @dptr\n");
		fprintf(fcode, "	mov	r4, a\n");
		fprintf(fcode, "	inc	dptr\n");

		fprintf(fcode, "	movx	a, @dptr\n");
		fprintf(fcode, "	inc	dptr\n");
		l1 = lab++;
		if (sz) {
			fprintf(fcode, "	mov	r5, a\n");

			fprintf(fcode, "	movx	a, @dptr\n");
			fprintf(fcode, "	mov	r6, a\n");
			fprintf(fcode, "	inc	dptr\n");

			fprintf(fcode, "	movx	a, @dptr\n");
			fprintf(fcode, "	inc	dptr\n");

			fprintf(fcode, "	cjne	a, r1_0, A%04x\n",l1);
	
			fprintf(fcode, "	mov	a, r6\n");
			fprintf(fcode, "	cjne	a, r0_0, A%04x\n",l1);
			fprintf(fcode, "	mov	a, r5\n");
		}

		fprintf(fcode, "	cjne	a, r3_0, A%04x\n",l1);

		fprintf(fcode, "	mov	a, r4\n");
		fprintf(fcode, "	cjne	a, r2_0, A%04x\n",l1);

		fprintf(fcode, "Z%04x:\n", l1);
		fprintf(fcode, "	mov	r2, #0\n");
		fprintf(fcode, "	sjmp	V%04x\n",l1);

		fprintf(fcode, "A%04x:\n", l1);
		fprintf(fcode, "	jc	Z%04x\n",l1);
		fprintf(fcode, "	mov	r2, #0xff\n");
		fprintf(fcode, "V%04x:\n", l1);
		fprintf(fcode, "	mov	r3, r2_0\n");

		fprintf(fcode, "	mov	sp_lo, dpl\n");
		fprintf(fcode, "	mov	sp_hi, dph\n");
	} else {
		need_GTU |= (sz?2:1);
		fprintf(fcode, "	lcall	GTU_%d\n", (sz?4:2));
	}
}
void
GT(int sz)
{
	int l1;
	if (inl) {
		fprintf(fcode, "	mov	dpl, sp_lo\n");
		fprintf(fcode, "	mov	dph, sp_hi\n");

		fprintf(fcode, "	movx	a, @dptr\n");
		fprintf(fcode, "	mov	r4, a\n");
		fprintf(fcode, "	inc	dptr\n");

		fprintf(fcode, "	movx	a, @dptr\n");
		fprintf(fcode, "	inc	dptr\n");
		fprintf(fcode, "	mov	r5, a\n");
		l1 = lab++;
		if (sz) {

			fprintf(fcode, "	movx	a, @dptr\n");
			fprintf(fcode, "	mov	r6, a\n");
			fprintf(fcode, "	inc	dptr\n");

			fprintf(fcode, "	movx	a, @dptr\n");
			fprintf(fcode, "	inc	dptr\n");
			fprintf(fcode, "	mov	r7, a\n");

			fprintf(fcode, "	cjne	a, r1_0, B%04x\n",l1);
	
			fprintf(fcode, "	mov	a, r6\n");
			fprintf(fcode, "	cjne	a, r0_0, A%04x\n",l1);
			fprintf(fcode, "	mov	a, r5\n");

			fprintf(fcode, "	cjne	a, r3_0, A%04x\n",l1);
		} else {
			fprintf(fcode, "	cjne	a, r3_0, B%04x\n",l1);
		}

		fprintf(fcode, "	mov	a, r4\n");
		fprintf(fcode, "	cjne	a, r2_0, A%04x\n",l1);

		fprintf(fcode, "Z%04x:\n", l1);
		fprintf(fcode, "	mov	r2, #0\n");
		fprintf(fcode, "	sjmp	V%04x\n",l1);

		fprintf(fcode, "C%04x:\n", l1);
		fprintf(fcode, "	mov	a, r%d\n", (sz?1:3));
		fprintf(fcode, "	jb	acc.7, D%04x\n", l1);
		fprintf(fcode, "	sjmp	Z%04x\n", l1);
		fprintf(fcode, "B%04x:\n", l1);
		fprintf(fcode, "	mov	a, r%d\n", (sz?7:5));
		fprintf(fcode, "	xrl	a, r%d\n", (sz?1:3));
		fprintf(fcode, "	jb	acc.7, C%04x\n", l1);
		fprintf(fcode, "	mov	a, r%d\n", (sz?1:3));
		fprintf(fcode, "	jnb	acc.7, A%04x\n", l1);
		fprintf(fcode, "	cpl	c\n");

		fprintf(fcode, "A%04x:\n", l1);
		fprintf(fcode, "	jc	Z%04x\n",l1);
		fprintf(fcode, "D%04x:\n", l1);
		fprintf(fcode, "	mov	r2, #0xff\n");
		fprintf(fcode, "V%04x:\n", l1);
		fprintf(fcode, "	mov	r3, r2_0\n");

		fprintf(fcode, "	mov	sp_lo, dpl\n");
		fprintf(fcode, "	mov	sp_hi, dph\n");
	} else {
		need_GT |= (sz?2:1);
		fprintf(fcode, "	lcall	GT_%d\n", (sz?4:2));
	}
}
void
LEU(int sz)
{
	int l1;
	if (inl) {
		fprintf(fcode, "	mov	dpl, sp_lo\n");
		fprintf(fcode, "	mov	dph, sp_hi\n");

		fprintf(fcode, "	movx	a, @dptr\n");
		fprintf(fcode, "	mov	r4, a\n");
		fprintf(fcode, "	inc	dptr\n");

		fprintf(fcode, "	movx	a, @dptr\n");
		fprintf(fcode, "	inc	dptr\n");
		l1 = lab++;
		if (sz) {
			fprintf(fcode, "	mov	r5, a\n");

			fprintf(fcode, "	movx	a, @dptr\n");
			fprintf(fcode, "	mov	r6, a\n");
			fprintf(fcode, "	inc	dptr\n");

			fprintf(fcode, "	movx	a, @dptr\n");
			fprintf(fcode, "	inc	dptr\n");

			fprintf(fcode, "	cjne	a, r1_0, A%04x\n",l1);
	
			fprintf(fcode, "	mov	a, r6\n");
			fprintf(fcode, "	cjne	a, r0_0, A%04x\n",l1);
			fprintf(fcode, "	mov	a, r5\n");
		}

		fprintf(fcode, "	cjne	a, r3_0, A%04x\n",l1);

		fprintf(fcode, "	mov	a, r4\n");
		fprintf(fcode, "	cjne	a, r2_0, A%04x\n",l1);

		fprintf(fcode, "Z%04x:\n", l1);
		fprintf(fcode, "	mov	r2, #0xff\n");
		fprintf(fcode, "	sjmp	V%04x\n",l1);

		fprintf(fcode, "A%04x:\n", l1);
		fprintf(fcode, "	jc	Z%04x\n",l1);
		fprintf(fcode, "	mov	r2, #0x00\n");
		fprintf(fcode, "V%04x:\n", l1);
		fprintf(fcode, "	mov	r3, r2_0\n");

		fprintf(fcode, "	mov	sp_lo, dpl\n");
		fprintf(fcode, "	mov	sp_hi, dph\n");
	} else {
		need_LEU |= (sz?2:1);
		fprintf(fcode, "	lcall	LEU_%d\n", (sz?4:2));
	}
}
void
LE(int sz)
{
	int l1;
	if (inl) {
		fprintf(fcode, "	mov	dpl, sp_lo\n");
		fprintf(fcode, "	mov	dph, sp_hi\n");

		fprintf(fcode, "	movx	a, @dptr\n");
		fprintf(fcode, "	mov	r4, a\n");
		fprintf(fcode, "	inc	dptr\n");

		fprintf(fcode, "	movx	a, @dptr\n");
		fprintf(fcode, "	inc	dptr\n");
		fprintf(fcode, "	mov	r5, a\n");
		l1 = lab++;
		if (sz) {

			fprintf(fcode, "	movx	a, @dptr\n");
			fprintf(fcode, "	mov	r6, a\n");
			fprintf(fcode, "	inc	dptr\n");

			fprintf(fcode, "	movx	a, @dptr\n");
			fprintf(fcode, "	inc	dptr\n");
			fprintf(fcode, "	mov	r7, a\n");

			fprintf(fcode, "	cjne	a, r1_0, B%04x\n",l1);
	
			fprintf(fcode, "	mov	a, r6\n");
			fprintf(fcode, "	cjne	a, r0_0, A%04x\n",l1);
			fprintf(fcode, "	mov	a, r5\n");

			fprintf(fcode, "	cjne	a, r3_0, A%04x\n",l1);
		} else {
			fprintf(fcode, "	cjne	a, r3_0, B%04x\n",l1);
		}

		fprintf(fcode, "	mov	a, r4\n");
		fprintf(fcode, "	cjne	a, r2_0, A%04x\n",l1);

		fprintf(fcode, "Z%04x:\n", l1);
		fprintf(fcode, "	mov	r2, #0xff\n");
		fprintf(fcode, "	sjmp	V%04x\n",l1);

		fprintf(fcode, "C%04x:\n", l1);
		fprintf(fcode, "	mov	a, r%d\n", (sz?1:3));
		fprintf(fcode, "	jb	acc.7, D%04x\n", l1);
		fprintf(fcode, "	sjmp	Z%04x\n", l1);
		fprintf(fcode, "B%04x:\n", l1);
		fprintf(fcode, "	mov	a, r%d\n", (sz?7:5));
		fprintf(fcode, "	xrl	a, r%d\n", (sz?1:3));
		fprintf(fcode, "	jb	acc.7, C%04x\n", l1);
		fprintf(fcode, "	mov	a, r%d\n", (sz?1:3));
		fprintf(fcode, "	jnb	acc.7, A%04x\n", l1);
		fprintf(fcode, "	cpl	c\n");

		fprintf(fcode, "A%04x:\n", l1);
		fprintf(fcode, "	jc	Z%04x\n",l1);
		fprintf(fcode, "D%04x:\n", l1);
		fprintf(fcode, "	mov	r2, #0x00\n");
		fprintf(fcode, "V%04x:\n", l1);
		fprintf(fcode, "	mov	r3, r2_0\n");

		fprintf(fcode, "	mov	sp_lo, dpl\n");
		fprintf(fcode, "	mov	sp_hi, dph\n");
	} else {
		need_LE |= (sz?2:1);
		fprintf(fcode, "	lcall	LE_%d\n", (sz?4:2));
	}
}
void
LTU(int sz)
{
	int l1;
	if (inl) {
		fprintf(fcode, "	mov	dpl, sp_lo\n");
		fprintf(fcode, "	mov	dph, sp_hi\n");

		fprintf(fcode, "	movx	a, @dptr\n");
		fprintf(fcode, "	mov	r4, a\n");
		fprintf(fcode, "	inc	dptr\n");

		fprintf(fcode, "	movx	a, @dptr\n");
		fprintf(fcode, "	inc	dptr\n");
		l1 = lab++;
		if (sz) {
			fprintf(fcode, "	mov	r5, a\n");

			fprintf(fcode, "	movx	a, @dptr\n");
			fprintf(fcode, "	mov	r6, a\n");
			fprintf(fcode, "	inc	dptr\n");

			fprintf(fcode, "	movx	a, @dptr\n");
			fprintf(fcode, "	inc	dptr\n");

			fprintf(fcode, "	cjne	a, r1_0, A%04x\n",l1);
	
			fprintf(fcode, "	mov	a, r6\n");
			fprintf(fcode, "	cjne	a, r0_0, A%04x\n",l1);
			fprintf(fcode, "	mov	a, r5\n");
		}

		fprintf(fcode, "	cjne	a, r3_0, A%04x\n",l1);

		fprintf(fcode, "	mov	a, r4\n");
		fprintf(fcode, "	cjne	a, r2_0, A%04x\n",l1);

		fprintf(fcode, "Z%04x:\n", l1);
		fprintf(fcode, "	mov	r2, #0x00\n");
		fprintf(fcode, "	sjmp	V%04x\n",l1);

		fprintf(fcode, "A%04x:\n", l1);
		fprintf(fcode, "	jnc	Z%04x\n",l1);
		fprintf(fcode, "	mov	r2, #0xff\n");
		fprintf(fcode, "V%04x:\n", l1);
		fprintf(fcode, "	mov	r3, r2_0\n");

		fprintf(fcode, "	mov	sp_lo, dpl\n");
		fprintf(fcode, "	mov	sp_hi, dph\n");
	} else {
		need_LTU |= (sz?2:1);
		fprintf(fcode, "	lcall	LTU_%d\n", (sz?4:2));
	}
}
void
LT(int sz)
{
	int l1;
	if (inl) {
		fprintf(fcode, "	mov	dpl, sp_lo\n");
		fprintf(fcode, "	mov	dph, sp_hi\n");

		fprintf(fcode, "	movx	a, @dptr\n");
		fprintf(fcode, "	mov	r4, a\n");
		fprintf(fcode, "	inc	dptr\n");

		fprintf(fcode, "	movx	a, @dptr\n");
		fprintf(fcode, "	inc	dptr\n");
		fprintf(fcode, "	mov	r5, a\n");
		l1 = lab++;
		if (sz) {

			fprintf(fcode, "	movx	a, @dptr\n");
			fprintf(fcode, "	mov	r6, a\n");
			fprintf(fcode, "	inc	dptr\n");

			fprintf(fcode, "	movx	a, @dptr\n");
			fprintf(fcode, "	inc	dptr\n");
			fprintf(fcode, "	mov	r7, a\n");

			fprintf(fcode, "	cjne	a, r1_0, B%04x\n",l1);
	
			fprintf(fcode, "	mov	a, r6\n");
			fprintf(fcode, "	cjne	a, r0_0, A%04x\n",l1);
			fprintf(fcode, "	mov	a, r5\n");
			fprintf(fcode, "	cjne	a, r3_0, A%04x\n",l1);
		} else {
			fprintf(fcode, "	cjne	a, r3_0, B%04x\n",l1);
		}

		fprintf(fcode, "	mov	a, r4\n");
		fprintf(fcode, "	cjne	a, r2_0, A%04x\n",l1);

		fprintf(fcode, "Z%04x:\n", l1);
		fprintf(fcode, "	mov	r2, #0x00\n");
		fprintf(fcode, "	sjmp	V%04x\n",l1);
		fprintf(fcode, "C%04x:\n", l1);
		fprintf(fcode, "	mov	a, r%d\n", (sz?1:3));
		fprintf(fcode, "	jb	acc.7, Z%04x\n", l1);
		fprintf(fcode, "	sjmp	D%04x\n", l1);
		fprintf(fcode, "B%04x:\n", l1);
		fprintf(fcode, "	mov	a, r%d\n", (sz?7:5));
		fprintf(fcode, "	xrl	a, r%d\n", (sz?1:3));
		fprintf(fcode, "	jb	acc.7, C%04x\n", l1);
		fprintf(fcode, "	mov	a, r%d\n", (sz?1:3));
		fprintf(fcode, "	jnb	acc.7, A%04x\n", l1);
		fprintf(fcode, "	cpl	c\n");

		fprintf(fcode, "A%04x:\n", l1);
		fprintf(fcode, "	jnc	Z%04x\n",l1);
		fprintf(fcode, "D%04x:\n", l1);
		fprintf(fcode, "	mov	r2, #0xff\n");
		fprintf(fcode, "V%04x:\n", l1);
		fprintf(fcode, "	mov	r3, r2_0\n");

		fprintf(fcode, "	mov	sp_lo, dpl\n");
		fprintf(fcode, "	mov	sp_hi, dph\n");
	} else {
		need_LT |= (sz?2:1);
		fprintf(fcode, "	lcall	LT_%d\n", (sz?4:2));
	}
}
void
NE(int sz)
{
	int l1;
	if (inl) {
		fprintf(fcode, "	mov	dpl, sp_lo\n");
		fprintf(fcode, "	mov	dph, sp_hi\n");

		fprintf(fcode, "	movx	a, @dptr\n");
		fprintf(fcode, "	inc	dptr\n");
		fprintf(fcode, "	cjne	a, r2_0, B%04x\n",l1=lab++);

		fprintf(fcode, "	movx	a, @dptr\n");
		fprintf(fcode, "	inc	dptr\n");
		fprintf(fcode, "	cjne	a, r3_0, A%04x\n",l1);

		if (sz) {
			fprintf(fcode, "	movx	a, @dptr\n");
			fprintf(fcode, "	inc	dptr\n");
			fprintf(fcode, "	cjne	a, r0_0, C%04x\n",l1);

			fprintf(fcode, "	movx	a, @dptr\n");
			fprintf(fcode, "	inc	dptr\n");
			fprintf(fcode, "	cjne	a, r1_0, W%04x\n",l1);
		}

		fprintf(fcode, "	mov	r2, #0\n");
		fprintf(fcode, "	sjmp	V%04x\n",l1);
		fprintf(fcode, "B%04x:\n", l1);
		fprintf(fcode, "	inc	dptr\n");
		fprintf(fcode, "A%04x:\n", l1);
		if (sz) {
			fprintf(fcode, "	inc	dptr\n");
			fprintf(fcode, "C%04x:\n", l1);
			fprintf(fcode, "	inc	dptr\n");
			fprintf(fcode, "W%04x:\n", l1);
		}
		fprintf(fcode, "	mov	r2, #0xff\n");
		fprintf(fcode, "V%04x:\n", l1);
		fprintf(fcode, "	mov	r3, r2_0\n");

		fprintf(fcode, "	mov	sp_lo, dpl\n");
		fprintf(fcode, "	mov	sp_hi, dph\n");
	} else {
		need_NE |= (sz?2:1);
		fprintf(fcode, "	lcall	NE_%d\n", (sz?4:2));
	}
}
void
EQC(int sz)
{
	int l1;
	if (inl) {

		l1 = lab++;
		if (sz) {
			fprintf(fcode, "	mov	a, r7\n");
			fprintf(fcode, "	cjne	a, r1_0, W%04x\n",l1);
	
			fprintf(fcode, "	mov	a, r6\n");
			fprintf(fcode, "	cjne	a, r0_0, W%04x\n",l1);
		}

		fprintf(fcode, "	mov	a, r5\n");
		fprintf(fcode, "	cjne	a, r3_0, W%04x\n",l1);

		fprintf(fcode, "	mov	a, r4\n");
		fprintf(fcode, "	cjne	a, r2_0, W%04x\n",l1);
		fprintf(fcode, "	mov	r2, #0xff\n");
		fprintf(fcode, "	sjmp	V%04x\n",l1);
		fprintf(fcode, "W%04x:\n", l1);
		fprintf(fcode, "	mov	r2, #0x\n");
		fprintf(fcode, "V%04x:\n", l1);
		fprintf(fcode, "	mov	r3, r2_0\n");

	} else {
		need_EQC |= (sz?2:1);
		fprintf(fcode, "	lcall	EQC_%d\n", (sz?4:2));
	}
}
void
EQ(int sz)
{
	int l1;
	if (inl) {
		fprintf(fcode, "	mov	dpl, sp_lo\n");
		fprintf(fcode, "	mov	dph, sp_hi\n");

		fprintf(fcode, "	movx	a, @dptr\n");
		fprintf(fcode, "	inc	dptr\n");
		fprintf(fcode, "	cjne	a, r2_0, W%04x\n",l1=lab++);

		fprintf(fcode, "	movx	a, @dptr\n");
		fprintf(fcode, "	inc	dptr\n");
		fprintf(fcode, "	cjne	a, r3_0, A%04x\n",l1);

		if (sz) {
			fprintf(fcode, "	movx	a, @dptr\n");
			fprintf(fcode, "	inc	dptr\n");
			fprintf(fcode, "	cjne	a, r0_0, B%04x\n",l1);

			fprintf(fcode, "	movx	a, @dptr\n");
			fprintf(fcode, "	inc	dptr\n");
			fprintf(fcode, "	cjne	a, r1_0, C%04x\n",l1);
		}

		fprintf(fcode, "	mov	r2, #0xff\n");
		fprintf(fcode, "	sjmp	V%04x\n",l1);
		fprintf(fcode, "W%04x:\n", l1);
		fprintf(fcode, "	inc	dptr\n");
		fprintf(fcode, "A%04x:\n", l1);
		if (sz) {
			fprintf(fcode, "	inc	dptr\n");
			fprintf(fcode, "B%04x:\n", l1);
			fprintf(fcode, "	inc	dptr\n");
			fprintf(fcode, "C%04x:\n", l1);
		}
		fprintf(fcode, "	mov	r2, #0x\n");
		fprintf(fcode, "V%04x:\n", l1);
		fprintf(fcode, "	mov	r3, r2_0\n");

		fprintf(fcode, "	mov	sp_lo, dpl\n");
		fprintf(fcode, "	mov	sp_hi, dph\n");
	} else { 
		need_EQ |= (sz?2:1); 
		fprintf(fcode, "	lcall	EQ_%d\n", (sz?4:2));
	}
}

#define	N2	(mem[pc]|(mem[pc+1]<<8))
#define	N4	(mem[pc]|(mem[pc+1]<<8)|(mem[pc+2]<<16)|(mem[pc+3]<<24))
#define	XN2	(mem[pc+2]|(mem[pc+3]<<8))
#define	XN4	(mem[pc+2]|(mem[pc+3]<<8)|(mem[pc+4]<<16)|(mem[pc+5]<<24))
unsigned short code_size;
unsigned short global_size;
unsigned short string_size;
unsigned short strp;
#ifdef MPW
#pragma segment mm
#endif
 
int
main(int argc, char **argv)
{
	unsigned short tos;
	unsigned short pc;
	unsigned short gp;
	unsigned short sp;
	int quit, i, op, dbg;
	char *code_file, *cp;
	unsigned long xx;
	
	mem = (unsigned char *)malloc(64*1024); 
	hdr.magic = 0xaa;
	code_file = NULL;
	prog = argv[0];
	for (i = 1;i < argc; i++) {
		if (argv[i][0] == '-') {
			cp = &argv[i][1];
			for (quit = 0;!quit;) {
				switch (*cp++) {
				case 0:
					quit = 1;
					break;
				
				case 'i':
					inl = 1;
					break;

				case 'd':
					dbg = 1 - dbg;
					break;

				case 'o':
					if (fcode) {
						fprintf(stderr, "%s: multiple output files\n", prog);
                                        	exit(2);
					}
					if (*cp == 0) {
						i++;
						if (i == argc) {
							fprintf(stderr, "%s: missing argument for -o\n", prog);
                                        		exit(2);
						}
						cp = argv[i];
					}
					fcode = fopen(cp, "w+");
					if (fcode == NULL) {
						fprintf(stderr, "%s: unable to open output file '%s'\n", prog, cp);
                                       		exit(2);
					}
					cp="";
					break;
					
					
				default:
					fprintf(stderr, "%s: unknown flag -%c\n", prog, cp[-1]);
					exit(2);
				}
			}
		} else {
			if (code_file) {
				fprintf(stderr, "%s: multiple input files '%s' and '%s'\n", prog, code_file, argv[i]);
				exit(2);
			}
			code_file = argv[i];
		}
	}
	if (fcode == NULL) {
		fprintf(stderr, "%s: no output file (-o) specified\n", prog);
        	exit(2);
	}
	load_code(code_file);
	if (hdr.magic != MAGIC) {
		fprintf(stderr, "Invalid magic number on input file = 0x%x\n", hdr.magic);
		exit(2);
	}
	code_size = hdr.code_size[0]|(hdr.code_size[1]<<8);
	global_size = hdr.global_size[0]|(hdr.global_size[1]<<8);
	string_size = hdr.string_size[0]|(hdr.string_size[1]<<8);
	stack_size = hdr.stack_size[0]|(hdr.stack_size[1]<<8);

	strp = BASE+code_size;
	gp = BASE+code_size+string_size;
	sp = TOP;
	tos = 0;

	//
	//	register set 0
	//
	//	r1:r0:r3:r2 is TOS
	//	r7:r4 is scratch
	//
	//	register_set 1
	//
	//	r1:r0	fp
	//	r5:r2	gtime	- time at entry to 
	//	r7:r6	sp
	//
	//	register_set 2
	//
	//	r3:r0	current time
	//	r7:r4	scratch
	//
	//	register_set 3
	//
	//	r3:r0	launch time
	//	r7:r4	scratch 
	//	
	//
	//	0x21.0	scratch
	//
	//	0x24	pending interrupts
	//	0x25 		scratch1
	//	0x26 		log_poll_lo
	//	0x27 		log_poll_hi
	//	0x28 		scratch2
	//	0x29 		scratch3
	//
		
	fprintf(fcode, "	.=0x8000\n");
	fprintf(fcode, "	gtime_0=0x0a\n");
	fprintf(fcode, "	gtime_1=0x0b\n");
	fprintf(fcode, "	gtime_2=0x0c\n");
	fprintf(fcode, "	gtime_3=0x0d\n");
	fprintf(fcode, "	ltime_0=0x18\n");
	fprintf(fcode, "	ltime_1=0x19\n");
	fprintf(fcode, "	ltime_2=0x1a\n");
	fprintf(fcode, "	ltime_3=0x1b\n");
	fprintf(fcode, "	time_0=0x10\n");
	fprintf(fcode, "	time_1=0x11\n");
	fprintf(fcode, "	time_2=0x12\n");
	fprintf(fcode, "	time_3=0x13\n");
	fprintf(fcode, "	pend_int=0x24\n");
	fprintf(fcode, "	scratch1=0x29\n");
	fprintf(fcode, "	scratch2=0x28\n");
	fprintf(fcode, "	scratch3=0x25\n");
	fprintf(fcode, "	log_poll_lo=0x26\n");
	fprintf(fcode, "	log_poll_hi=0x27\n");
	fprintf(fcode, "	fp_lo=0x08\n");
	fprintf(fcode, "	fp_hi=0x09\n");
	fprintf(fcode, "	sp_lo=0x0e\n");
	fprintf(fcode, "	sp_hi=0x0f\n");
	fprintf(fcode, "	log_full=0x20.0\n");
	fprintf(fcode, "	log_poll_flg=0x20.1\n");
	fprintf(fcode, "	LOGBASE=LGP+0x%x\n", global_size);
	fprintf(fcode, "	LOGEND=0x%x\n", sp-stack_size);
        if (global_size) {
                fprintf(fcode, "        mov     dptr, #LGP\n");
                fprintf(fcode, "        clr     a\n");
                if ((global_size&0xff00) == 0) {
                        fprintf(fcode, "        mov     r0, #0x%x&0xff\n", global_size);
                        fprintf(fcode, "INIT_LOOP:\n");
                        fprintf(fcode, "        movx    @dptr, a\n");
                        fprintf(fcode, "        inc     dptr\n");
                        fprintf(fcode, "        djnz    r0, INIT_LOOP\n");
                } else {
                        if (global_size&0xff) {
                                fprintf(fcode, "        mov     r0, #0x%x&0xff\n", global_size);
                                fprintf(fcode, "        mov     r1, #(0x%x>>8)&0xff\n", global_size);
                        } else {
                                fprintf(fcode, "        mov     r0, #0x%x&0xff\n", global_size-1);
                                fprintf(fcode, "        mov     r1, #(0x%x>>8)&0xff\n", global_size-1);
                                fprintf(fcode, "        movx    @dptr, a\n");
                                fprintf(fcode, "        inc     dptr\n");
                        }
                        fprintf(fcode, "INIT_LOOP:\n");
                        fprintf(fcode, "        movx    @dptr, a\n");
                        fprintf(fcode, "        inc     dptr\n");
                        fprintf(fcode, "        djnz    r0, INIT_LOOP\n");
                        fprintf(fcode, "        djnz    r1, INIT_LOOP\n");
                }
        }
	fprintf(fcode, "	mov	sp_lo, #0x%x\n", sp&0xff);
	fprintf(fcode, "	mov	sp_hi, #0x%x\n", sp>>8);
	fprintf(fcode, "	mov	pend_int, #0x0\n");
	fprintf(fcode, "	mov	time_3, #0x0\n");
	fprintf(fcode, "	mov	0x20, #0x0\n");
	fprintf(fcode, "	clr	EA\n");
	fprintf(fcode, "	mov	time_2, 0x3e\n");	// save time ....
	fprintf(fcode, "	mov	time_1, 0x3d\n");
	fprintf(fcode, "	mov	time_0, 0x3c\n");
	fprintf(fcode, "	setb	EA\n");
	for (pc = BASE; pc < (BASE+code_size);) {
		fprintf(fcode, "L%04x:\n",pc);
		op = mem[pc++];
		switch (op){
		case P_HALT:		// halt
			fprintf(fcode, "	lcall	HALT\n");need_HALT = 1;
			break;
		case P_J_NE:		// jump if TOS ne 0 (don't pop tos)
			fprintf(fcode, "	mov	a, r2\n");
			fprintf(fcode, "	orl	a, r3\n");
			fprintf(fcode, "	jz	X%04x\n", pc-1);
			fprintf(fcode, "	ljmp	L%04x\n",  (pc+N2)&0xffff);
			fprintf(fcode, "X%04x:\n", pc-1);
			pc += 2;
			break;
		case P_J_EQ:		// jump if TOS eq 0 (don't pop tos)
			fprintf(fcode, "	mov	a, r2\n");
			fprintf(fcode, "	orl	a, r3\n");
			fprintf(fcode, "	jnz	X%04x\n", pc-1);
			fprintf(fcode, "	ljmp	L%04x\n",  (pc+N2)&0xffff);
			fprintf(fcode, "X%04x:\n", pc-1);
			pc += 2;
			break;
		case P_JEQV:		// jump if TOS eq V
			xx = XN2;
			fprintf(fcode, "	cjne	r2, #0x%x, X%04x\n", xx&0xff, pc-1);
			fprintf(fcode, "	cjne	r3, #0x%x, X%04x\n", (xx>>8)&0xff, pc-1);
			fprintf(fcode, "	ljmp	L%04x\n",  (pc+N2)&0xffff);
			fprintf(fcode, "X%04x:\n", pc-1);
			pc += 4;
			break;
		case P_JEQV_L:		// jump if TOS eq V
			xx = XN4;
			fprintf(fcode, "	cjne	r2, #0x%x, X%04x\n", xx&0xff, pc-1);
			fprintf(fcode, "	cjne	r3, #0x%x, X%04x\n", (xx>>8)&0xff, pc-1);
			fprintf(fcode, "	cjne	r0, #0x%x, X%04x\n", (xx>>16)&0xff, pc-1);
			fprintf(fcode, "	cjne	r1, #0x%x, X%04x\n", (xx>>24)&0xff, pc-1);
			fprintf(fcode, "	ljmp	L%04x\n",  (pc+N2)&0xffff);
			fprintf(fcode, "X%04x:\n", pc-1);
			pc += 6;
			break;
		case P_JNEV:		// jump if TOS eq V
			xx = XN2;
			fprintf(fcode, "	cjne	r2, #0x%x, X%04x\n", xx&0xff, pc-1);
			fprintf(fcode, "	cjne	r3, #0x%x, X%04x\n", (xx>>8)&0xff, pc-1);
			fprintf(fcode, "	sjmp	Y%04x\n",  pc-1);
			fprintf(fcode, "X%04x:\n", pc-1);
			fprintf(fcode, "	ljmp	L%04x\n",  (pc+N2)&0xffff);
			fprintf(fcode, "Y%04x:\n", pc-1);
			pc += 4;
			break;
		case P_JNEV_L:		// jump if TOS eq V
			xx = XN4;
			fprintf(fcode, "	cjne	r2, #0x%x, X%04x\n", xx&0xff, pc-1);
			fprintf(fcode, "	cjne	r3, #0x%x, X%04x\n", (xx>>8)&0xff, pc-1);
			fprintf(fcode, "	cjne	r0, #0x%x, X%04x\n", (xx>>16)&0xff, pc-1);
			fprintf(fcode, "	cjne	r1, #0x%x, X%04x\n", (xx>>24)&0xff, pc-1);
			fprintf(fcode, "	sjmp	Y%04x\n",  pc-1);
			fprintf(fcode, "X%04x:\n", pc-1);
			fprintf(fcode, "	ljmp	L%04x\n",  (pc+N2)&0xffff);
			fprintf(fcode, "Y%04x:\n", pc-1);
			pc += 6;
			break;
		case P_GEU_L:		// tos is replaced with truth value for tos-1 >= tos
			GEU(1);
			break;
		case P_GTU_L:		// tos is replaced with truth value for tos-1 > tos
			GTU(1);
			break;
		case P_LEU_L:		// tos is replaced with truth value for tos-1 <= tos
			LEU(1);
			break;
		case P_LTU_L:		// tos is replaced with truth value for tos-1 < tos
			LTU(1);
			break;
		case P_GE_L:		// tos is replaced with truth value for tos-1 >= tos
			GE(1);
			break;
		case P_GT_L:		// tos is replaced with truth value for tos-1 > tos
			GT(1);
			break;
		case P_LE_L:		// tos is replaced with truth value for tos-1 <= tos
			LE(1);
			break;
		case P_LT_L:		// tos is replaced with truth value for tos-1 < tos
			LT(1);
			break;
		case P_NE_L:		// tos is replaced with truth value for tos-1 != tos
			NE(1);
			break;
		case P_EQ_C:		// tos is replaced with truth value for tos-1 == tos
			fprintf(fcode, "	mov	r4, #0x%x\n", N2&0xff);
			fprintf(fcode, "	mov	r5, #0x%x\n", (N2>>8)&0xff);
			EQC(0);
			pc += 2;
			break;
		case P_EQ_L_C:		// tos is replaced with truth value for tos-1 == tos
			fprintf(fcode, "	mov	r4, #0x%x\n", N4&0xff);
			fprintf(fcode, "	mov	r5, #0x%x\n", (N4>>8)&0xff);
			fprintf(fcode, "	mov	r6, #0x%x\n", (N4>>16)&0xff);
			fprintf(fcode, "	mov	r7, #0x%x\n", (N4>>24)&0xff);
			EQC(1);
			pc += 4;
			break;
		case P_EQ_L:		// tos is replaced with truth value for tos-1 == tos
			EQ(1);
			break;
		case P_GEU:		// tos is replaced with truth value for tos-1 >= tos
			GEU(0);
			break;
		case P_GTU:		// tos is replaced with truth value for tos-1 > tos
			GTU(0);
			break;
		case P_LEU:		// tos is replaced with truth value for tos-1 <= tos
			LEU(0);
			break;
		case P_LTU:		// tos is replaced with truth value for tos-1 < tos
			LTU(0);
			break;
		case P_GE:		// tos is replaced with truth value for tos-1 >= tos
			GE(0);
			break;
		case P_GT:		// tos is replaced with truth value for tos-1 > tos
			GT(0);
			break;
		case P_LE:		// tos is replaced with truth value for tos-1 <= tos
			LE(0);
			break;
		case P_LT:		// tos is replaced with truth value for tos-1 < tos
			LT(0);
			break;
		case P_NE:		// tos is replaced with truth value for tos-1 != tos
			NE(0);
			break;
		case P_EQ:		// tos is replaced with truth value for tos-1 == tos
			EQ(0);
			break;
		case P_NOT_L:		// tos is replaced with truth value for tos == 0
			NOT(1);
			break;
		case P_NOT:		// tos is replaced with truth value for tos == 0
			NOT(0);
			break;
		case P_SUB_L:		// tos is replaced with value for tos-1 - tos
			SUB(1);
			break;
		case P_SUB:		// tos is replaced with value for tos-1 - tos
			SUB(0);
			break;
		case P_ADD_L:		// tos is replaced with value for tos-1 + tos
			ADD(1);
			break;
		case P_ADD:		// tos is replaced with value for tos-1 + tos
			ADD(0);
			break;
		case P_ADD_C:		// tos is replaced with value for tos-1 + tos
			fprintf(fcode, "	mov	r4, #0x%x\n", N2&0xff);
			fprintf(fcode, "	mov	r5, #0x%x\n", (N2>>8)&0xff);
			ADDC(0);
			pc += 2;
			break;
		case P_ADD_L_C:		// tos is replaced with value for tos-1 + tos
			fprintf(fcode, "	mov	r4, #0x%x\n", N4&0xff);
			fprintf(fcode, "	mov	r5, #0x%x\n", (N4>>8)&0xff);
			fprintf(fcode, "	mov	r6, #0x%x\n", (N4>>16)&0xff);
			fprintf(fcode, "	mov	r7, #0x%x\n", (N4>>24)&0xff);
			ADDC(1);
			pc += 4;
			break;
		case P_MULU_L:		// tos is replaced with value for tos-1 * tos
			POP45(1);
			fprintf(fcode, "	lcall	MUL_4U\n");need_MULU|=2;
			break;
		case P_MUL_L:		// tos is replaced with value for tos-1 * tos
			POP45(1);
			fprintf(fcode, "	lcall	MUL_4\n");need_MUL|=2;
			break;
		case P_MULU:		// tos is replaced with value for tos-1 * tos
			POP45(0);
			fprintf(fcode, "	lcall	MUL_2U\n");need_MULU|=1;
			break;
		case P_MUL:		// tos is replaced with value for tos-1 * tos
			POP45(0);
			fprintf(fcode, "	lcall	MUL_2\n");need_MUL|=1;
			break;
		case P_DIV_L:		// tos is replaced with value for tos-1 / tos
			POP45(1);
			fprintf(fcode, "	lcall	DIV_4\n");need_DIV|=2;
			//WIDEN();
			break;
		case P_DIVU_L:		// tos is replaced with value for tos-1 / tos
			POP45(1);
			fprintf(fcode, "	lcall	DIV_4U\n");need_DIVU|=2;
			//WIDEN();
			break;
		case P_DIVU:		// tos is replaced with value for tos-1 / tos
			POP45(0);
			fprintf(fcode, "	lcall	DIV_2U\n");need_DIVU|=1;
			break;
		case P_DIV:		// tos is replaced with value for tos-1 / tos
			POP45(0);
			fprintf(fcode, "	lcall	DIV_2\n");need_DIV|=1;
			break;
		case P_MOD_L:		// tos is replaced with value for tos-1 % tos
			POP45(1);
			fprintf(fcode, "	lcall	DIV_4U\n");need_DIVU|=2;
			fprintf(fcode, "	mov	r2, r4\n");
			fprintf(fcode, "	mov	r3, r5\n");
			fprintf(fcode, "	mov	r0, r6\n");
			fprintf(fcode, "	mov	r1, r7\n");
			WIDEN();
			break;
		case P_MOD:		// tos is replaced with value for tos-1 % tos
			POP45(0);
			fprintf(fcode, "	lcall	DIV_2\n");need_DIVU|=1;
			fprintf(fcode, "	mov	r3, r1\n");
			fprintf(fcode, "	mov	r2, r0\n");
			break;
		case P_OR_L:		// tos is replaced with value for tos-1 | tos
			OR(1);
			break;
		case P_OR:		// tos is replaced with value for tos-1 | tos
			OR(0);
			break;
		case P_XOR:		// tos is replaced with value for tos-1 ^ tos
			XOR(0);
			break;
		case P_XOR_L:		// tos is replaced with value for tos-1 ^ tos
			XOR(1);
			break;
		case P_AND_L:		// tos is replaced with value for tos-1 & tos
			AND(1);
			break;
		case P_AND:		// tos is replaced with value for tos-1 & tos
			AND(0);
			break;
		case P_SHL_L:		// tos is replaced with value for tos-1 << tos
			fprintf(fcode, "	mov	r4, r2_0\n");
			POP(1);
			SHL(1);
			break;
		case P_INDEX2:		// tos is replaced with value for tos-1 << tos
			fprintf(fcode, "	mov	a, r2\n");
			fprintf(fcode, "	add	a, r2\n");
			fprintf(fcode, "	mov	r2, a\n");
			fprintf(fcode, "	mov	a, r3\n");
			fprintf(fcode, "	addc	a, r3\n");
			fprintf(fcode, "	mov	r3, a\n");
			break;
		case P_INDEX4:		// tos is replaced with value for tos-1 << tos	
			INDEX(1);
			break;
		case P_SHR_L:		// tos is replaced with value for tos-1 >> tos
			fprintf(fcode, "	mov	r4, r2_0\n");
			POP(1);
			SHR(1);
			break;
		case P_SHL:		// tos is replaced with value for tos-1 << tos
			fprintf(fcode, "	mov	r4, r2_0\n");
			POP(0);
			SHL(0);
			break;
		case P_SHR:		// tos is replaced with value for tos-1 >> tos
			fprintf(fcode, "	mov	r4, r2_0\n");
			POP(0);
			SHR(0);
			break;
		case P_JMP:		// jump unconditionally
			fprintf(fcode, "	ljmp	L%04x\n",  (pc+N2)&0xffff);
			pc += 2;
			break;
		case P_COMP_L:		// tos is replaced with ~tos 1's complement)
			fprintf(fcode, "	mov	a, r0\n");
			fprintf(fcode, "	cpl	a\n");
			fprintf(fcode, "	mov	r0, a\n");
			fprintf(fcode, "	mov	a, r1\n");
			fprintf(fcode, "	cpl	a\n");
			fprintf(fcode, "	mov	r1, a\n");
		case P_COMP:		// tos is replaced with ~tos 1's complement)
			fprintf(fcode, "	mov	a, r2\n");
			fprintf(fcode, "	cpl	a\n");
			fprintf(fcode, "	mov	r2, a\n");
			fprintf(fcode, "	mov	a, r3\n");
			fprintf(fcode, "	cpl	a\n");
			fprintf(fcode, "	mov	r3, a\n");
			break;
		case P_CALL:		// call subroutine
			fprintf(fcode, "	mov	r3, #L%04x>>8\n",pc+2);
			fprintf(fcode, "	mov	r2, #L%04x&0xff\n",pc+2);
			fprintf(fcode, "	ljmp	L%04x\n",  (pc+N2)&0xffff);
			pc += 2;
			break;
		case P_CALLI:		// call-indirect subroutine (from TOS - TOS is popped)
			fprintf(fcode, "	push	r3_0\n");
			fprintf(fcode, "	push	r2_0\n");
			fprintf(fcode, "	mov	r3, #L%04x>>8\n",pc+2);
			fprintf(fcode, "	mov	r2, #L%04x&0xff\n",pc+2);
			fprintf(fcode, "	ret\n");
			break;
		case P_COPYN:		// N/2+1 words are popped from TOS, old TOS is pushed back on
			fprintf(fcode, "	mov	a, sp_lo\n");
			fprintf(fcode, "	add	a, #0x%x\n", N2&0xff);
			fprintf(fcode, "	mov	sp_lo, a\n");
			fprintf(fcode, "	mov	a, sp_hi\n");
			fprintf(fcode, "	addc	a, #0x%x\n", N2>>8);
			fprintf(fcode, "	mov	sp_hi, a\n");
			pc += 2;
			break;
		case P_CUTN:		// N/2 words are popped from TOS
			fprintf(fcode, "	mov	a, sp_lo\n");
			fprintf(fcode, "	add	a, #0x%x\n", N2&0xff);
			fprintf(fcode, "	mov	sp_lo, a\n");
			fprintf(fcode, "	mov	a, sp_hi\n");
			fprintf(fcode, "	addc	a, #0x%x\n", N2>>8);
			fprintf(fcode, "	mov	sp_hi, a\n");
			pc += 2;
			break;
		case P_CONST:		// push a constant value
			fprintf(fcode, "	mov	r2, #0x%x\n", N2&0xff);
			fprintf(fcode, "	mov	r3, #0x%x\n", (N2>>8)&0xff);
			pc += 2;
			break;
		case P_CONST_L:		// push a constant value
			fprintf(fcode, "	mov	r2, #0x%x\n", N4&0xff);
			fprintf(fcode, "	mov	r3, #0x%x\n", (N4>>8)&0xff);
			fprintf(fcode, "	mov	r0, #0x%x\n", (N4>>16)&0xff);
			fprintf(fcode, "	mov	r1, #0x%x\n", (N4>>24)&0xff);
			pc += 4;
			break;
		case P_ADDR_L:		// push the address of a local value  (2 byte offset)
			if (N2 == 0) {
				fprintf(fcode, "	mov	r2, fp_lo\n");
				fprintf(fcode, "	mov	r3, fp_hi\n");
			} else {
				fprintf(fcode, "	mov	a, fp_lo\n");
				fprintf(fcode, "	add	a, #0x%x\n", N2&0xff);
				fprintf(fcode, "	mov	r2, a\n");
				fprintf(fcode, "	mov	a, fp_hi\n");
				fprintf(fcode, "	addc	a, #0x%x\n", N2>>8);
				fprintf(fcode, "	mov	r3, a\n");
			}
			pc += 2;
			break;
		case P_ADDR_G:		// push the address of a global value  (2 byte offset)
			fprintf(fcode, "	mov	r2, #(LGP+0x%x)&0xff\n", N2);
			fprintf(fcode, "	mov	r3, #(LGP+0x%x)>>8\n", N2);
			pc += 2;
			break;
		case P_UBYTE_L:		// push a local byte value  (2 byte offset)
			LD_LOCAL(8, N2);
			pc += 2;
			break;
		case P_BYTE_L:		// push a local byte value  (2 byte offset)
			LD_LOCAL(1, N2);
			pc += 2;
			break;
		case P_UBYTE_G:		// push a global byte value  (2 byte offset)
			fprintf(fcode, "	mov	r3, #0\n");
			fprintf(fcode, "	mov	dptr, #(LGP+0x%x)\n", N2);
			fprintf(fcode, "	movx	a, @dptr\n");
			fprintf(fcode, "	mov	r2, a\n");
			pc += 2;
			break;
		case P_BYTE_G:		// push a global byte value  (2 byte offset)
			LD_GLOBAL(1, N2);
			pc += 2;
			break;
		case P_WORD_L:		// push a local word value  (2 byte offset)
			LD_LOCAL(2, N2);
			pc += 2;
			break;
		case P_WORD_G:		// push a global word value  (2 byte offset)
			LD_GLOBAL(2, N2);
			pc += 2;
			break;
		case P_LONG_L:		// push a local word value  (2 byte offset)
			LD_LOCAL(4, N2);
			pc += 2;
			break;
		case P_LONG_G:		// push a global word value  (2 byte offset)
			LD_GLOBAL(4, N2);
			pc += 2;
			break;
		case P_SBYTE_L:		// store a local byte value  (2 byte offset)
			ST_LOCAL(1, N2);
			pc += 2;
			break;
		case P_SBYTE_G:		// store a global byte value  (2 byte offset)
			fprintf(fcode, "	mov	dptr, #(LGP+0x%x)\n", N2);
			fprintf(fcode, "	mov	a, r2\n");
			fprintf(fcode, "	movx	@dptr, a\n");
			pc += 2;
			break;
		case P_SWORD_L:		// store a local word value  (2 byte offset)
			ST_LOCAL(2, N2);
			pc += 2;
			break;
		case P_SLONG_L:		// store a local word value  (2 byte offset)
			ST_LOCAL(4, N2);
			pc += 2;
			break;
		case P_SWORD_G:		// store a global word value  (2 byte offset)
			ST_GLOBAL(2, N2);
			pc += 2;
			break;
		case P_SLONG_G:		// store a global word value  (2 byte offset)
			ST_GLOBAL(4, N2);
			pc += 2;
			break;
		case P_LOAD_UB:		// tos is replaced by byte from indirection of old tos value
			LOAD(8, N2);
			pc += 2;
			break;
		case P_LOAD_B:		// tos is replaced by byte from indirection of old tos value
			LOAD(1, N2);
			pc += 2;
			break;
		case P_LOAD_W:		// tos is replaced by word from indirection of old tos value
			LOAD(2, N2);
			pc += 2;
			break;
		case P_LOAD_L:		// tos is replaced by word from indirection of old tos value
			LOAD(4, N2);
			pc += 2;
			break;
		case P_DUP_L:		// duplicate top of stack
			PUSH(1);
			break;
		case P_DUP:		// duplicate top of stack
			PUSH(0);
			break;
		case P_STORE_B:		// *tos = tos-1 (byte) tos/tos-1 are discarded
			POP45(2);
			STORE(1, N2);
			pc += 2;
			break;
		case P_STORE_W:		// *tos = tos-1 (word) tos/tos-1 are discarded
			POP45(0);
			STORE(2, N2);
			pc += 2;
			break;
		case P_STORE_L:		// *tos = tos-1 (word) tos/tos-1 are discarded
			POP45(1);
			STORE(4, N2);
			pc += 2;
			break;
		case P_ADDR_P:		// push the address of a code address (relative) (2 byte offset)
			fprintf(fcode, "	mov	r3, #L%04x>>8\n",(pc+N2)&0xffff);
			fprintf(fcode, "	mov	r2, #L%04x&0xff\n",(pc+N2)&0xffff);
			pc += 2;
			break;
		case P_ZERO:		// pushes 0
			fprintf(fcode, "	mov	r3, #0\n");
			fprintf(fcode, "	mov	r2, #0\n");
			break;
		case P_ZERO_L:		// pushes 0
			fprintf(fcode, "	mov	r3, #0\n");
			fprintf(fcode, "	mov	r2, #0\n");
			fprintf(fcode, "	mov	r1, #0\n");
			fprintf(fcode, "	mov	r0, #0\n");
			break;
		case P_ONE_L:		// pushes 1
			fprintf(fcode, "	mov	r2, #1\n");
			fprintf(fcode, "	mov	r3, #0\n");
			fprintf(fcode, "	mov	r1, #0\n");
			fprintf(fcode, "	mov	r0, #0\n");
			break;
		case P_ONE:		// pushes 1
			fprintf(fcode, "	mov	r2, #1\n");
			fprintf(fcode, "	mov	r3, #0\n");
			break;
		case P_ENTER:		// allocates space for local variables (subtracts sp by 2 byte offset)
			PUSHFP(N2 != 0xffff);
			if (N2 == 0) {
				fprintf(fcode, "	mov	fp_lo, sp_lo\n");
				fprintf(fcode, "	mov	fp_hi, sp_hi\n");
			} else 
			if (N2 != 0xffff) {
				fprintf(fcode, "	clr	c\n");
				fprintf(fcode, "	mov	a, sp_lo\n");
				fprintf(fcode, "	subb	a, #0x%x\n",N2&0xff);
				fprintf(fcode, "	mov	sp_lo, a\n");
				fprintf(fcode, "	mov	fp_lo, a\n");
				fprintf(fcode, "	mov	a, sp_hi\n");
				fprintf(fcode, "	subb	a, #0x%x\n",N2>>8);
				fprintf(fcode, "	mov	sp_hi, a\n");
				fprintf(fcode, "	mov	fp_hi, a\n");
			}
			pc +=2;
			break;
		case P_RET:		// recovers space for local variables (subtracts sp by 2 byte offset)
			if (N2 != 0xffff && N2 != 0) {
				fprintf(fcode, "	mov	a, sp_lo\n");
				fprintf(fcode, "	add	a, #0x%x\n",N2&0xff);
				fprintf(fcode, "	mov	sp_lo, a\n");
				fprintf(fcode, "	mov	a, sp_hi\n");
				fprintf(fcode, "	addc	a, #0x%x\n",N2>>8);
				fprintf(fcode, "	mov	sp_hi, a\n");
			}
			POPFP(N2 != 0xffff);
			fprintf(fcode, "	push	r4_0\n");
			fprintf(fcode, "	push	r5_0\n");
			fprintf(fcode, "	ret\n");
			pc += 2;
			break;
		case P_ADDR_S:		// push the address of a string (2 byte offset)
			fprintf(fcode, "	mov	r2, #(LSTR+0x%x)&0xff\n", N2);
			fprintf(fcode, "	mov	r3, #(LSTR+0x%x)>>8\n", N2);
			pc += 2;
			break;
		case P_POLL:		// call into environment for busy work
			fprintf(fcode, "	lcall	POLL\n");need_POLL=1;
			break;
		case P_INTERRUPT:	// push true if interrupt N has occured (and clear the flag)(2 byte number)
			fprintf(fcode, "	mov	r2, #1<<%d\n",N2&3);
			fprintf(fcode, "	lcall	INTR\n");need_INTR=1;
			pc += 2;
			break;
		case P_SAVE_TIME:	// saves current time
			fprintf(fcode, "	lcall	SAVE_TIME\n");need_SAVE_TIME=1;
			break;
		case P_CMP_TIME:	// pushes true if current time is N > than the last saved one (2 byte constant)
			fprintf(fcode, "	mov	r2, #0x%x\n", N4&0xf);
			fprintf(fcode, "	mov	r3, #0x%x\n", (N4>>8)&0xff);
			fprintf(fcode, "	mov	r0, #0x%x\n", (N4>>16)&0xff);
			fprintf(fcode, "	mov	r1, #0x%x\n", (N4>>24)&0xff);
			fprintf(fcode, "	lcall	CMP_TIME\n");need_CMP_TIME=1;
			pc += 4;
			break;
		case P_INPUT:		// pushes false if no input char available, and the chare and true it it is
			fprintf(fcode, "	lcall	INPUT\n");need_INPUT=1;
			fprintf(fcode, "	mov	r2, a\n");
			fprintf(fcode, "	mov	r3, #0\n");
			break;
		case P_OUTPUT:		// pushes truth value - true if we can send a character without stalling
			fprintf(fcode, "	jnb	ti, X%04x\n", pc);
			fprintf(fcode, "	mov	r2, #0xff\n");
			fprintf(fcode, "	sjmp	Y%04x\n", pc);
			fprintf(fcode, "X%04x:\n", pc);
			fprintf(fcode, "	mov	r2, #0\n");
			fprintf(fcode, "Y%04x:\n", pc);
			fprintf(fcode, "	mov	r3, r2\n");
			break;
		case P_LAUNCH:		// pushes truth value - true if we have launched
			fprintf(fcode, "	lcall	LAUNCH\n");need_LAUNCH = 1;
			break;
		case P_FOUND_LAUNCH:
			fprintf(fcode, "	mov	a, pend_int\n");
			fprintf(fcode, "	setb	acc.5\n");
			fprintf(fcode, "	mov	pend_int, a\n");
			fprintf(fcode, "	mov	a, time_0\n");
			fprintf(fcode, "	mov	ltime_0, a\n");
			fprintf(fcode, "	mov	a, time_1\n");
			fprintf(fcode, "	mov	ltime_1, a\n");
			fprintf(fcode, "	mov	a, time_2\n");
			fprintf(fcode, "	mov	ltime_2, a\n");
			fprintf(fcode, "	mov	a, time_3\n");
			fprintf(fcode, "	mov	ltime_3, a\n");
			break;
		case P_ARM:		// pops tos and passes it to the arming mechanism
			fprintf(fcode, "	lcall	ARM\n");need_ARM = 1;
			break;
		case P_SAFE:		// pops tos and passes it to the safing mechanism
			fprintf(fcode, "	lcall	SAFE\n");need_SAFE = 1;
			break;
		case P_FIRE:		// pops tos and uses it to activate a pyro channel
			fprintf(fcode, "	lcall	FIRE\n");need_FIRE=1;
			break;
		case P_TIME:		// pushes absolute time
			fprintf(fcode, "	lcall	TIME\n");need_TIME=1;
			break;
		case P_LTIME:		// pushes time since launch event
			fprintf(fcode, "	lcall	LTIME\n");need_LTIME=1;
			break;
		case P_STIME:		// pushes time since launch event
			fprintf(fcode, "	mov	r2, gtime_0\n");
			fprintf(fcode, "	mov	r3, gtime_1\n");
			fprintf(fcode, "	mov	r0, gtime_2\n");
			fprintf(fcode, "	mov	r1, gtime_3\n");
			break;
		case P_RTIME:		// pushes time since launch event
			fprintf(fcode, "	lcall	RTIME\n");need_RTIME=1;
			break;
		case P_LOG_BASE:	// set's TOS to log base
			fprintf(fcode, "	mov	r2, #LOGBASE&0xff\n");
			fprintf(fcode, "	mov	r3, #(LOGBASE>>8)&0xff\n");
			break;
		case P_LOG_END:		// set's TOS to log end+1
			fprintf(fcode, "	mov	r2, #LOGEND&0xff\n");
			fprintf(fcode, "	mov	r3, #(LOGEND>>8)&0xff\n");
			break;
		case P_SET_LOG_FULL:		// set's log full state
			fprintf(fcode, "	mov	a, r2\n");
			fprintf(fcode, "	rrc	a\n");
			fprintf(fcode, "	mov	log_full, c\n");
			break;
		case P_SET_POLL:	// set's log polling function
			fprintf(fcode, "	log_poll_addr= L%04x\n",  (pc+N2)&0xffff);
			pc += 2;
			logging=1;
			break;
		case P_SET_TRAMPOLINE:	// set's log polling function
			fprintf(fcode, "	trampoline= L%04x\n",  (pc+N2)&0xffff);
			pc += 2;
			logging=1;
			break;
		case P_SET_EXTRA:	// set's log polling function
			fprintf(fcode, "	extra= L%04x\n",  (pc+N2)&0xffff);
			pc += 2;
			logging=1;
			break;
		case P_LOG_FULL:	// pushes truth value - true if the log is full
			fprintf(fcode, "	clr	a\n");
			fprintf(fcode, "	mov	r3, a\n");
			fprintf(fcode, "	mov	c, log_full\n");
			fprintf(fcode, "	clr	log_full\n");
			fprintf(fcode, "	rlc	a\n");
			fprintf(fcode, "	mov	r2, a\n");
			break;
		case P_BEEP:		// pops TOS value and uses it to control the beeper (if any)
			fprintf(fcode, "	lcall	BEEP\n");need_BEEP=1;
			break;
		case P_PSTR:		// pops TOS value and uses it as the address of a string to print
			fprintf(fcode, "	lcall	PSTR\n");need_PSTR=1;
			break;
		case P_PHEX:		// pops TOS value and uses it as a hex value to print
			fprintf(fcode, "	lcall	PHEX\n");need_PHEX=1;
			break;
		case P_PHEXL:		// pops TOS value and uses it as a hex value to print
			fprintf(fcode, "	lcall	PHEXL\n");need_PHEXL=1;
			break;
		case P_PVAL:		// pops TOS value and uses it as a decimal value to print
			fprintf(fcode, "	lcall	PVAL\n");need_PVAL|=1; need_DIVU |= 2;
			break;
		case P_PVALU:		// pops TOS value and uses it as a decimal value to print
			fprintf(fcode, "	lcall	PVALU\n");need_PVAL|=2; need_DIVU |= 2;
			break;
		case P_PCHR:		// pops TOS value and uses it as a character value to print
			fprintf(fcode, "	lcall	PCHR\n");need_PCHR=1;
			break;
		case P_EESAVE:		// pops 3 TOS values saves data to eeprom tos is eeprom address, tos-1 main mem address tos-2 is count
			POP45(0);
			POP01();
			fprintf(fcode, "	lcall	EESAVE\n");need_EESAVE=1;
			break;
		case P_EELOAD:		// pops 3 TOS values loads data from eeprom tos is main mem address, tos-1 eeprom address tos-2 is count
			POP45(0);
			POP01();
			fprintf(fcode, "	lcall	EELOAD\n");need_EELOAD=1;
			break;
		case P_GET:		// get value from external source (tos gives value and is replaced with old one)
			fprintf(fcode, "	lcall	GET\n");need_GET=1;
			break;
		case P_SET:		// set value to external source (tos is the value tos-1 points to the source, both are removed)
			POP45(0);
			fprintf(fcode, "	lcall	SET\n");need_SET=1;
			break;
		case P_POP_L:		// discards the tos
			POP(1);
			break;
		case P_POP:		// discards the tos
			POP(0);
			break;
		case P_LSHORTEN:		// 32->16
			fprintf(fcode, "	mov	a, r0\n");
			fprintf(fcode, "	orl	a, r2\n");
			fprintf(fcode, "	orl	a, r1\n");
			fprintf(fcode, "	mov	r2, a\n");
			break;
		case P_SHORTEN:		// 32->16
			break;
		case P_WIDENU:		// 16->32 (unsigned)
			WIDENU();
			break;
		case P_WIDEN:		// 16->32
			WIDEN();
			break;
		default:
			fprintf(stderr, "Invalid opcode 0x%x @ 0x%04x\n",op, pc-1);
			exit(2);
		}
	}
	postlude();
	postlude2();
	postlude3();
	return(0);
}
#ifdef MPW
#pragma segment postlude
#endif
int
postlude()
{
	int i;
	
	inl = 1;
	if (need_PUSHFP&1) {
		fprintf(fcode, "PUSHFP_S:\n");
		PUSHFP(0);
		fprintf(fcode, "	ret\n");
	}
	if (need_PUSHFP&2) {
		fprintf(fcode, "PUSHFP_L:\n");
		PUSHFP(1);
		fprintf(fcode, "	ret\n");
	}
	if (need_POPFP&1) {
		fprintf(fcode, "POPFP_S:\n");
		POPFP(0);
		fprintf(fcode, "	ret\n");
	}
	if (need_POPFP&2) {
		fprintf(fcode, "POPFP_L:\n");
		POPFP(1);
		fprintf(fcode, "	ret\n");
	}
	if (need_POP&1) {
		fprintf(fcode, "POP_2:\n");
		POP(0);
		fprintf(fcode, "	ret\n");
	}
	if (need_POP&2) {
		fprintf(fcode, "POP_4:\n");
		POP(1);
		fprintf(fcode, "	ret\n");
	}
	if (need_POP01) {
		fprintf(fcode, "POP01:\n");
		POP01();
		fprintf(fcode, "	ret\n");
	}
	if (need_POP45&2) {
		fprintf(fcode, "POP45_4:\n");
		POP45(1);
		fprintf(fcode, "	ret\n");
	}
	if (need_POP45&4) {
		fprintf(fcode, "POP45_1:\n");
		POP45(2);
		fprintf(fcode, "	ret\n");
	}
	if (need_POP45&1) {
		fprintf(fcode, "POP45_2:\n");
		POP45(0);
		fprintf(fcode, "	ret\n");
	}
	if (need_HALT ) {
		fprintf(fcode, "HALT:\n");
		fprintf(fcode, "	jnb	ti, .\n");
		fprintf(fcode, "	mov	ie, #0\n");
		fprintf(fcode, "	mov	PSW, #0\n");
		fprintf(fcode, "	mov	t2con, #0\n");
		fprintf(fcode, "	ljmp	0\n");
	}
	if (need_STORE&0x1) {
		fprintf(fcode, "STORE_1:\n");
		STORE(1, 1);
		fprintf(fcode, "	ret\n");
	}
	if (need_STORE&0x2) {
		fprintf(fcode, "STORE_2:\n");
		STORE(2, 1);
		fprintf(fcode, "	ret\n");
	}
	if (need_STORE&0x4) {
		fprintf(fcode, "STORE_4:\n");
		STORE(4, 1);
		fprintf(fcode, "	ret\n");
	}
	if (need_STORE&0x10) {
		fprintf(fcode, "STORE0_1:\n");
		STORE(1, 0);
		fprintf(fcode, "	ret\n");
	}
	if (need_STORE&0x20) {
		fprintf(fcode, "STORE0_2:\n");
		STORE(2, 0);
		fprintf(fcode, "	ret\n");
	}
	if (need_STORE&0x40) {
		fprintf(fcode, "STORE0_4:\n");
		STORE(4, 0);
		fprintf(fcode, "	ret\n");
	}
	if (need_LOAD&0x10) {
		fprintf(fcode, "LOAD0_1:\n");
		LOAD(1, 0);
		fprintf(fcode, "	ret\n");
	}
	if (need_LOAD&0x20) {
		fprintf(fcode, "LOAD0_2:\n");
		LOAD(2, 0);
		fprintf(fcode, "	ret\n");
	}
	if (need_LOAD&0x40) {
		fprintf(fcode, "LOAD0_4:\n");
		LOAD(4, 0);
		fprintf(fcode, "	ret\n");
	}
	if (need_LOAD&0x80) {
		fprintf(fcode, "LOAD0_8:\n");
		LOAD(8, 0);
		fprintf(fcode, "	ret\n");
	}
	if (need_LOAD&0x1) {
		fprintf(fcode, "LOAD_1:\n");
		LOAD(1, 1);
		fprintf(fcode, "	ret\n");
	}
	if (need_LOAD&0x2) {
		fprintf(fcode, "LOAD_2:\n");
		LOAD(2, 1);
		fprintf(fcode, "	ret\n");
	}
	if (need_LOAD&0x4) {
		fprintf(fcode, "LOAD_4:\n");
		LOAD(4, 1);
		fprintf(fcode, "	ret\n");
	}
	if (need_LOAD&0x8) {
		fprintf(fcode, "LOAD_8:\n");
		LOAD(8, 1);
		fprintf(fcode, "	ret\n");
	}
	if (need_LD_GLOBAL&1) {
		fprintf(fcode, "LD_GLOBAL_1:\n");
		LD_GLOBAL(1, 0);
		fprintf(fcode, "	ret\n");
	}
	if (need_LD_GLOBAL&2) {
		fprintf(fcode, "LD_GLOBAL_2:\n");
		LD_GLOBAL(2, 0);
		fprintf(fcode, "	ret\n");
	}
	if (need_LD_GLOBAL&4) {
		fprintf(fcode, "LD_GLOBAL_4:\n");
		LD_GLOBAL(4, 0);
		fprintf(fcode, "	ret\n");
	}
	if (need_LD_GLOBAL&8) {
		fprintf(fcode, "LD_GLOBAL_8:\n");
		LD_GLOBAL(8, 0);
		fprintf(fcode, "	ret\n");
	}
	if (need_LD_LOCAL&1) {
		fprintf(fcode, "LD_LOCAL_1:\n");
		LD_LOCAL(1, 0);
		fprintf(fcode, "	ret\n");
	}
	if (need_LD_LOCAL&2) {
		fprintf(fcode, "LD_LOCAL_2:\n");
		LD_LOCAL(2, 0);
		fprintf(fcode, "	ret\n");
	}
	if (need_LD_LOCAL&4) {
		fprintf(fcode, "LD_LOCAL_4:\n");
		LD_LOCAL(4, 0);
		fprintf(fcode, "	ret\n");
	}
	if (need_LD_LOCAL&8) {
		fprintf(fcode, "LD_LOCAL_8:\n");
		LD_LOCAL(8, 0);
		fprintf(fcode, "	ret\n");
	}
	if (need_ST_LOCAL&1) {
		fprintf(fcode, "ST_LOCAL_1:\n");
		ST_LOCAL(1, 0);
		fprintf(fcode, "	ret\n");
	}
	if (need_ST_LOCAL&2) {
		fprintf(fcode, "ST_LOCAL_2:\n");
		ST_LOCAL(2, 0);
		fprintf(fcode, "	ret\n");
	}
	if (need_ST_LOCAL&4) {
		fprintf(fcode, "ST_LOCAL_4:\n");
		ST_LOCAL(4, 0);
		fprintf(fcode, "	ret\n");
	}
	if (need_ST_GLOBAL&1) {
		fprintf(fcode, "ST_GLOBAL_1:\n");
		ST_GLOBAL(1, 0);
		fprintf(fcode, "	ret\n");
	}
	if (need_ST_GLOBAL&2) {
		fprintf(fcode, "ST_GLOBAL_2:\n");
		ST_GLOBAL(2, 0);
		fprintf(fcode, "	ret\n");
	}
	if (need_ST_GLOBAL&4) {
		fprintf(fcode, "ST_GLOBAL_4:\n");
		ST_GLOBAL(4, 0);
		fprintf(fcode, "	ret\n");
	}
	if (need_GEU&2) {
		fprintf(fcode, "GEU_4:\n");
		GEU(1);
		fprintf(fcode, "	ret\n");
	}
	if (need_GTU&2) {
		fprintf(fcode, "GTU_4:\n");
		GTU(1);
		fprintf(fcode, "	ret\n");
	}
	if (need_LTU&2) {
		fprintf(fcode, "LTU_4:\n");
		LTU(1);
		fprintf(fcode, "	ret\n");
	}
	if (need_LEU&2) {
		fprintf(fcode, "LEU_4:\n");
		LEU(1);
		fprintf(fcode, "	ret\n");
	}
	if (need_GE&2) {
		fprintf(fcode, "GE_4:\n");
		GE(1);
		fprintf(fcode, "	ret\n");
	}
	if (need_GT&2) {
		fprintf(fcode, "GT_4:\n");
		GT(1);
		fprintf(fcode, "	ret\n");
	}
	if (need_LT&2) {
		fprintf(fcode, "LT_4:\n");
		LT(1);
		fprintf(fcode, "	ret\n");
	}
	if (need_LE&2) {
		fprintf(fcode, "LE_4:\n");
		LE(1);
		fprintf(fcode, "	ret\n");
	}
	if (need_EQC&1) {
		fprintf(fcode, "EQC_2:\n");
		EQC(0);
		fprintf(fcode, "	ret\n");
	}
	if (need_EQC&2) {
		fprintf(fcode, "EQC_4:\n");
		EQC(1);
		fprintf(fcode, "	ret\n");
	}
	if (need_EQ&2) {
		fprintf(fcode, "EQ_4:\n");
		EQ(1);
		fprintf(fcode, "	ret\n");
	}
	if (need_NE&2) {
		fprintf(fcode, "NE_4:\n");
		NE(1);
		fprintf(fcode, "	ret\n");
	}
	if (need_GEU&1) {
		fprintf(fcode, "GEU_2:\n");
		GEU(0);
		fprintf(fcode, "	ret\n");
	}
	if (need_GTU&1) {
		fprintf(fcode, "GTU_2:\n");
		GTU(0);
		fprintf(fcode, "	ret\n");
	}
	if (need_LTU&1) {
		fprintf(fcode, "LTU_2:\n");
		LTU(0);
		fprintf(fcode, "	ret\n");
	}
	if (need_LEU&1) {
		fprintf(fcode, "LEU_2:\n");
		LEU(0);
		fprintf(fcode, "	ret\n");
	}
	if (need_GE&1) {
		fprintf(fcode, "GE_2:\n");
		GE(0);
		fprintf(fcode, "	ret\n");
	}
	if (need_GT&1) {
		fprintf(fcode, "GT_2:\n");
		GT(0);
		fprintf(fcode, "	ret\n");
	}
	if (need_LT&1) {
		fprintf(fcode, "LT_2:\n");
		LT(0);
		fprintf(fcode, "	ret\n");
	}
	if (need_LE&1) {
		fprintf(fcode, "LE_2:\n");
		LE(0);
		fprintf(fcode, "	ret\n");
	}
	if (need_EQ&1) {
		fprintf(fcode, "EQ_2:\n");
		EQ(0);
		fprintf(fcode, "	ret\n");
	}
	if (need_NE&1) {
		fprintf(fcode, "NE_2:\n");
		NE(0);
		fprintf(fcode, "	ret\n");
	}
	if (need_ADDC&2) {
		fprintf(fcode, "ADDC_4:\n");
		ADDC(1);
		fprintf(fcode, "	ret\n");
	}
	if (need_ADDC&1) {
		fprintf(fcode, "ADDC_2:\n");
		ADDC(0);
		fprintf(fcode, "	ret\n");
	}
	if (need_ADD&2) {
		fprintf(fcode, "ADD_4:\n");
		ADD(1);
		fprintf(fcode, "	ret\n");
	}
	if (need_ADD&1) {
		fprintf(fcode, "ADD_2:\n");
		ADD(0);
		fprintf(fcode, "	ret\n");
	}
	if (need_SUB&2) {
		fprintf(fcode, "SUB_4:\n");
		SUB(1);
		fprintf(fcode, "	ret\n");
	}
	if (need_SUB&1) {
		fprintf(fcode, "SUB_2:\n");
		SUB(0);
		fprintf(fcode, "	ret\n");
	}
	if (need_OR&1) {
		fprintf(fcode, "OR_2:\n");
		OR(0);
		fprintf(fcode, "	ret\n");
	}
	if (need_XOR&1) {
		fprintf(fcode, "XOR_2:\n");
		XOR(0);
		fprintf(fcode, "	ret\n");
	}
	if (need_AND&1) {
		fprintf(fcode, "AND_2:\n");
		AND(0);
		fprintf(fcode, "	ret\n");
	}
	if (need_SHL&1) {
		fprintf(fcode, "SHL_2:\n");
		SHL(0);
		fprintf(fcode, "	ret\n");
	}
	if (need_SHR&1) {
		fprintf(fcode, "SHR_2:\n");
		SHR(0);
		fprintf(fcode, "	ret\n");
	}
	if (need_OR&2) {
		fprintf(fcode, "OR_4:\n");
		OR(1);
		fprintf(fcode, "	ret\n");
	}
	if (need_XOR&2) {
		fprintf(fcode, "XOR_4:\n");
		XOR(1);
		fprintf(fcode, "	ret\n");
	}
	if (need_AND&2) {
		fprintf(fcode, "AND_4:\n");
		AND(1);
		fprintf(fcode, "	ret\n");
	}
	if (need_SHL&2) {
		fprintf(fcode, "SHL_4:\n");
		SHL(1);
		fprintf(fcode, "	ret\n");
	}
	if (need_INDEX&2) {
		fprintf(fcode, "INDEX_2:\n");
		INDEX(0);
		fprintf(fcode, "	ret\n");
	}
	if (need_INDEX&2) {
		fprintf(fcode, "INDEX_4:\n");
		INDEX(1);
		fprintf(fcode, "	ret\n");
	}
	if (need_SHR&2) {
		fprintf(fcode, "SHR_4:\n");
		SHR(1);
		fprintf(fcode, "	ret\n");
	}
	if (need_NOT&1) {
		fprintf(fcode, "NOT_2:\n");
		NOT(0);
		fprintf(fcode, "	ret\n");
	}
	if (need_NOT&2) {
		fprintf(fcode, "NOT_4:\n");
		NOT(1);
		fprintf(fcode, "	ret\n");
	}
	if (need_MULU&2) {
		need_MUL4_core = 1;
		fprintf(fcode, "MUL_4U:\n");
        	fprintf(fcode, "	mov	a, r1\n");
        	fprintf(fcode, "	mov	r7_2, a\n");
        	fprintf(fcode, "	mov	a, r0\n");
        	fprintf(fcode, "	mov	r6_2, a\n");
		fprintf(fcode, "	mov	a, r2\n");
		fprintf(fcode, "	mov	r4_2, a\n");
        	fprintf(fcode, "	mov	a, r3\n");
        	fprintf(fcode, "	mov	r5_2, a\n");
        	fprintf(fcode, "	mov	r4_3, #0\n");
		if (!(need_MUL&2))
        		fprintf(fcode, "	sjmp	MUL_4_3\n");
	}
	if (need_MUL&2) {
		need_MUL4_core = 1;
		//
		//	A B C D
		//   *  E F G H
		//
		//  ==	    H-D
		//	  H-C
		//      H-B
		//    H-A
		//	  G-D
		//      G-C
		//    G-B
		//      F-D
		//    F-C
		//    E-D
		//	
		//	A = R1->r7_2
		//	B = R0->r6_2
		//	C = R3->R5_2
		//	D = R2->R4_2
		//	
		//	E = R7
		//	F = R6
		//	G = R5
		//	H = R4
		//
		fprintf(fcode, "MUL_4:\n");
		
		
        	fprintf(fcode, "	mov	a, r1\n");
        	fprintf(fcode, "	jnb	acc.7, MUL_4_1\n");
		fprintf(fcode, "		mov	a, r2\n");
		fprintf(fcode, "		cpl	a\n");
		fprintf(fcode, "		add	a, #1\n");
		fprintf(fcode, "		mov	r4_2, a\n");
        	fprintf(fcode, "		mov	a, r3\n");
		fprintf(fcode, "		cpl	a\n");
		fprintf(fcode, "		addc	a, #0\n");
        	fprintf(fcode, "		mov	r5_2, a\n");
        	fprintf(fcode, "		mov	a, r0\n");
		fprintf(fcode, "		cpl	a\n");
		fprintf(fcode, "		addc	a, #0\n");
        	fprintf(fcode, "		mov	r6_2, a\n");
        	fprintf(fcode, "		mov	a, r1\n");
		fprintf(fcode, "		cpl	a\n");
		fprintf(fcode, "		addc	a, #0\n");
        	fprintf(fcode, "		mov	r7_2, a\n");
        	fprintf(fcode, "		mov	r4_3, #1\n");
        	fprintf(fcode, "		sjmp	MUL_4_2\n");
        	fprintf(fcode, "MUL_4_1:\n");
        	fprintf(fcode, "		mov	r7_2, a\n");
        	fprintf(fcode, "		mov	a, r0\n");
        	fprintf(fcode, "		mov	r6_2, a\n");
		fprintf(fcode, "		mov	a, r2\n");
		fprintf(fcode, "		mov	r4_2, a\n");
        	fprintf(fcode, "		mov	a, r3\n");
        	fprintf(fcode, "		mov	r5_2, a\n");
        	fprintf(fcode, "		mov	r4_3, #0\n");
        	fprintf(fcode, "MUL_4_2:\n");
		
        	fprintf(fcode, "	mov	a, r7\n");
        	fprintf(fcode, "	jnb	acc.7, MUL_4_3\n");
		fprintf(fcode, "		mov	a, r4\n");
		fprintf(fcode, "		cpl	a\n");
		fprintf(fcode, "		add	a, #1\n");
		fprintf(fcode, "		mov	r4, a\n");
        	fprintf(fcode, "		mov	a, r5\n");
		fprintf(fcode, "		cpl	a\n");
		fprintf(fcode, "		addc	a, #0\n");
        	fprintf(fcode, "		mov	r5, a\n");
        	fprintf(fcode, "		mov	a, r6\n");
		fprintf(fcode, "		cpl	a\n");
		fprintf(fcode, "		addc	a, #0\n");
        	fprintf(fcode, "		mov	r6, a\n");
        	fprintf(fcode, "		mov	a, r7\n");
		fprintf(fcode, "		cpl	a\n");
		fprintf(fcode, "		addc	a, #0\n");
        	fprintf(fcode, "		mov	r7, a\n");
        	fprintf(fcode, "		mov	a, r4_3\n");
        	fprintf(fcode, "		xrl	a, #1\n");
        	fprintf(fcode, "		mov	r4_3, a\n");

	}
	if (need_MUL4_core) {
        	fprintf(fcode, "MUL_4_3:\n");

		// get first byte
		fprintf(fcode, "	mov	a, r4_2\n");
		fprintf(fcode, "	mov	b, r4\n");
        	fprintf(fcode, "	mul     ab\n");
        	fprintf(fcode, "	mov	r2, a\n");
        	fprintf(fcode, "	mov	r3, b\n");
		// get 2nd byte
        	fprintf(fcode, "	mov	a, r5_2\n");
        	fprintf(fcode, "	mov	b, r4\n");
        	fprintf(fcode, "	mul     ab\n");
        	fprintf(fcode, "	add	a, r3\n");
        	fprintf(fcode, "	mov	r3, a\n");
        	fprintf(fcode, "	mov	a, b\n");
        	fprintf(fcode, "	addc	a, #0\n");
        	fprintf(fcode, "	mov	r0, a\n");
        	fprintf(fcode, "	clr	a\n");
        	fprintf(fcode, "	addc	a, #0\n");
        	fprintf(fcode, "	mov	r1, a\n");
	
        	fprintf(fcode, "	mov	a, r4_2\n");
        	fprintf(fcode, "	mov	b, r5\n");
        	fprintf(fcode, "	mul     ab\n");
        	fprintf(fcode, "	add	a, r3\n");
        	fprintf(fcode, "	mov	r3, a\n");
        	fprintf(fcode, "	mov	a, b\n");
        	fprintf(fcode, "	addc	a, r0\n");
        	fprintf(fcode, "	mov	r0, a\n");
        	fprintf(fcode, "	clr	a\n");
        	fprintf(fcode, "	addc	a, r1\n");
        	fprintf(fcode, "	mov	r1, a\n");
	
		// 3rd byte
	
        	fprintf(fcode, "	mov	a, r6_2\n");
        	fprintf(fcode, "	mov	b, r4\n");
        	fprintf(fcode, "	mul     ab\n");
        	fprintf(fcode, "	add	a, r0\n");
        	fprintf(fcode, "	mov	r0, a\n");
        	fprintf(fcode, "	mov	a, b\n");
        	fprintf(fcode, "	addc	a, r1\n");
        	fprintf(fcode, "	mov	r1, a\n");
	
        	fprintf(fcode, "	mov	a, r5_2\n");
        	fprintf(fcode, "	mov	b, r5\n");
        	fprintf(fcode, "	mul     ab\n");
        	fprintf(fcode, "	add	a, r0\n");
        	fprintf(fcode, "	mov	r0, a\n");
        	fprintf(fcode, "	mov	a, b\n");
        	fprintf(fcode, "	addc	a, r1\n");
        	fprintf(fcode, "	mov	r1, a\n");
	
        	fprintf(fcode, "	mov	a, r4_2\n");
        	fprintf(fcode, "	mov	b, r6\n");
        	fprintf(fcode, "	mul     ab\n");
        	fprintf(fcode, "	add	a, r0\n");
        	fprintf(fcode, "	mov	r0, a\n");
        	fprintf(fcode, "	mov	a, b\n");
        	fprintf(fcode, "	addc	a, r1\n");
        	fprintf(fcode, "	mov	r1, a\n");

		// 4th byte
	
        	fprintf(fcode, "	mov	a, r4_2\n");
        	fprintf(fcode, "	mov	b, r7\n");
        	fprintf(fcode, "	mul     ab\n");
        	fprintf(fcode, "	add	a, r1\n");
        	fprintf(fcode, "	mov	r1, a\n");
		
        	fprintf(fcode, "	mov	a, r5_2\n");
        	fprintf(fcode, "	mov	b, r6\n");
        	fprintf(fcode, "	mul     ab\n");
        	fprintf(fcode, "	add	a, r1\n");
        	fprintf(fcode, "	mov	r1, a\n");
		
        	fprintf(fcode, "	mov	a, r6_2\n");
        	fprintf(fcode, "	mov	b, r5\n");
        	fprintf(fcode, "	mul     ab\n");
        	fprintf(fcode, "	add	a, r1\n");
        	fprintf(fcode, "	mov	r1, a\n");
		
        	fprintf(fcode, "	mov	a, r7_2\n");
        	fprintf(fcode, "	mov	b, r4\n");
        	fprintf(fcode, "	mul     ab\n");
        	fprintf(fcode, "	add	a, r1\n");
        	fprintf(fcode, "	mov	r1, a\n");

		//
		// now get the sign back

        	fprintf(fcode, "	mov	a, r4_3\n");
        	fprintf(fcode, "	jz	MUL_4_4\n");
		fprintf(fcode, "		mov	a, r2\n");
		fprintf(fcode, "		cpl	a\n");
		fprintf(fcode, "		add	a, #1\n");
		fprintf(fcode, "		mov	r2, a\n");
        	fprintf(fcode, "		mov	a, r3\n");
		fprintf(fcode, "		cpl	a\n");
		fprintf(fcode, "		addc	a, #0\n");
        	fprintf(fcode, "		mov	r3, a\n");
        	fprintf(fcode, "		mov	a, r0\n");
		fprintf(fcode, "		cpl	a\n");
		fprintf(fcode, "		addc	a, #0\n");
        	fprintf(fcode, "		mov	r0, a\n");
        	fprintf(fcode, "		mov	a, r1\n");
		fprintf(fcode, "		cpl	a\n");
		fprintf(fcode, "		addc	a, #0\n");
        	fprintf(fcode, "		mov	r1, a\n");

        	fprintf(fcode, "MUL_4_4:\n");
        	fprintf(fcode, "	ret\n");
	}
	if ((need_MUL|need_MULU)&1) {
		fprintf(fcode, "MUL_2:\n");
		fprintf(fcode, "MUL_2U:\n");
        	//Multiply the 32 bit OP with the 16 value supplied
        	//Generate the lowest byte of the result
        	fprintf(fcode, "	mov     b,r4\n");
        	fprintf(fcode, "	mov     a,r2\n");
        	fprintf(fcode, "	mul     ab\n");
        	fprintf(fcode, "	mov     r0,a\n");         //low-order result
        	fprintf(fcode, "	mov     r1,b\n");         //high_order result
        	//Now generate the next higher order byte
        	fprintf(fcode, "	mov     b,r5\n");
        	fprintf(fcode, "	mov     a,r2\n");
        	fprintf(fcode, "	mul     ab\n");
        	fprintf(fcode, "	add     a,r1\n");         //low-order result
        	fprintf(fcode, "	mov     r1,a\n");         // save
        	fprintf(fcode, "	mov     b,r4\n");
        	fprintf(fcode, "	mov     a,r3\n");
        	fprintf(fcode, "	mul     ab\n");
        	fprintf(fcode, "	add     a,r1\n");         //low-order result
        	fprintf(fcode, "	mov     r3,a\n");         // save
        	// Now we are all done, move the TMP values back into OP
        	fprintf(fcode, "	mov     r2,r0\n");
        	fprintf(fcode, "	ret\n");
	}
	if (need_DIVU&1) {
		need_DIV_2_core = 1;
		fprintf(fcode, "DIV_2U:\n");
		fprintf(fcode, "	mov	r4_3, #0\n");
		fprintf(fcode, "	mov     r7_2, r3\n");	// load divisor
		fprintf(fcode, "	mov     r6_2, r2\n");
		fprintf(fcode, "	mov     r5_2, r5\n");	// load divisor
		fprintf(fcode, "	mov     r4_2, r4\n");
		if (!(need_DIV&1))
			fprintf(fcode, "	sjmp	DIV_d\n");
			
	}
	if (need_DIV&1) {
		need_DIV_2_core = 1;
		fprintf(fcode, "DIV_2:\n");
        	//This divides the 16 bit r5:4 by r3:r2 register by the value supplied
		fprintf(fcode, "	mov     r1,#0\n");
		fprintf(fcode, "	mov     r0,#0\n");          	// zero out partial remainder

		fprintf(fcode, "	mov     a, r3\n");	// load divisor
		fprintf(fcode, "	mov     r4_3, a\n");
		fprintf(fcode, "	jb	acc.7, DIV_a\n");	// load divisor
		
		fprintf(fcode, "		mov     r7_2, a\n");	// load divisor
		fprintf(fcode, "		mov     r6_2, r2\n");
		fprintf(fcode, "		sjmp	DIV_b\n");
		fprintf(fcode, "DIV_a:\n");
		fprintf(fcode, "		mov     a, r2\n");
		fprintf(fcode, "		cpl     a\n");
		fprintf(fcode, "		add     a, #1\n");
		fprintf(fcode, "		mov     r6_2, a\n");
		fprintf(fcode, "		mov     a, r3\n");
		fprintf(fcode, "		cpl     a\n");
		fprintf(fcode, "		addc    a, #0\n");
		fprintf(fcode, "		mov     r7_2, a\n");
		fprintf(fcode, "DIV_b:\n");

		fprintf(fcode, "	mov     a, r5\n");	// load divisor
		fprintf(fcode, "	xrl     a, r4_3\n");	// load divisor
		fprintf(fcode, "	mov     r4_3, a\n");	// load divisor
		fprintf(fcode, "	mov     a, r5\n");	// load divisor
		fprintf(fcode, "	jb	acc.7, DIV_c\n");	// load divisor
		
		fprintf(fcode, "		mov     r5_2, a\n");	// load divisor
		fprintf(fcode, "		mov     r4_2, r4\n");
		fprintf(fcode, "		sjmp	DIV_d\n");
		fprintf(fcode, "DIV_c:\n");
		fprintf(fcode, "		mov     a, r4\n");
		fprintf(fcode, "		cpl     a\n");
		fprintf(fcode, "		add     a, #1\n");
		fprintf(fcode, "		mov     r4_2, a\n");
		fprintf(fcode, "		mov     a, r5\n");
		fprintf(fcode, "		cpl     a\n");
		fprintf(fcode, "		addc    a, #0\n");
		fprintf(fcode, "		mov     r5_2, a\n");
	}
	if (need_DIV_2_core) {
		fprintf(fcode, "DIV_d:\n");

		fprintf(fcode, "	mov     r5,#16\n");         	// loop count
		fprintf(fcode, "	mov     r2,#0\n");
		fprintf(fcode, "	mov     r3,#0\n");
        	// This begins the loop
		fprintf(fcode, "Div_loop:\n");
		fprintf(fcode, "	lcall    Shift_D\n");        	// shift the dividend and return MSB in C
		fprintf(fcode, "	mov     a,r0\n");           	// shift carry into LSB of partial remainder
		fprintf(fcode, "	rlc     a\n");
		fprintf(fcode, "	mov     r0,a\n");
		fprintf(fcode, "	mov     a,r1\n");
		fprintf(fcode, "	rlc     a\n");
		fprintf(fcode, "	mov     r1,a\n");
        	// now test to see if R7:R6 <= R1:R0
		fprintf(fcode, "	jc      Can_sub\n");
		fprintf(fcode, "	clr     c\n");
		fprintf(fcode, "	mov     a,r1\n");           	// subtract R7 from R1 to see if R7 < R1
		fprintf(fcode, "	subb    a,r7_2\n");           	//  A = R1 - R7, carry set if R1 < R7
		fprintf(fcode, "	jc      Cant_sub\n");
        	// at this point R7<R1 or R7=R1
		fprintf(fcode, "	jnz     Can_sub\n");        	// jump if R7>R1
        	// if R7 = R1, test for R6<=R0
		fprintf(fcode, "	clr     c\n");
		fprintf(fcode, "	mov     a,r0\n");
		fprintf(fcode, "	subb    a,r6_2\n");           	//  A = R0 - R6, carry set if R0 < R6
		fprintf(fcode, "	jc      Cant_sub\n");
		fprintf(fcode, "Can_sub:\n");
        	// subtract the divisor from the partial remainder
		fprintf(fcode, "	clr     c\n");
		fprintf(fcode, "	mov     a,r0\n");
		fprintf(fcode, "	subb    a,r6_2\n");           	//  A = R0 - R6
		fprintf(fcode, "	mov     r0,a\n");
		fprintf(fcode, "	mov     a,r1\n");
		fprintf(fcode, "	subb    a,r7_2\n");           	//  a = R1 - R7 - Borrow
		fprintf(fcode, "	mov     r1,a\n");
		fprintf(fcode, "	setb    c\n");              	//  shift a 1 into the quotient
		fprintf(fcode, "	sjmp     Quot\n");
		fprintf(fcode, "Cant_sub:\n");
        	// shift a 0 into the quotient
		fprintf(fcode, "	clr     c\n");
		fprintf(fcode, "Quot:\n");
        	// shift the carry bit into the quotient
		fprintf(fcode, "	lcall    Shift_Q\n");
        	//  Test for competion
		fprintf(fcode, "	djnz    r5,Div_loop\n");
        	//  Now we are all done, move the TMP values back into OP
	
		fprintf(fcode, "	mov	a, r4_3\n");		// get the sign back
		fprintf(fcode, "	jnb     acc.7, DIV_e\n");	
		fprintf(fcode, "		mov     a, r2\n");
		fprintf(fcode, "		cpl     a\n");
		fprintf(fcode, "		add     a, #1\n");
		fprintf(fcode, "		mov     r2, a\n");
		fprintf(fcode, "		mov     a, r3\n");
		fprintf(fcode, "		cpl     a\n");
		fprintf(fcode, "		addc    a, #0\n");
		fprintf(fcode, "		mov     r3, a\n");
		fprintf(fcode, "DIV_e:\n");
		fprintf(fcode, "	ret\n");

		fprintf(fcode, "Shift_D:\n");
        	// shift the dividend one bit to the left and return the MSB in C
		fprintf(fcode, "	clr     c\n");
		fprintf(fcode, "	mov     a,r4_2\n");
		fprintf(fcode, "	rlc     a\n");
		fprintf(fcode, "	mov     r4_2,a\n");
		fprintf(fcode, "	mov     a,r5_2\n");
		fprintf(fcode, "	rlc     a\n");
		fprintf(fcode, "	mov     r5_2,a\n");
		fprintf(fcode, "	ret\n");
 
		fprintf(fcode, "Shift_Q:\n");
        	// shift the quotent one bit to the left and shift the C into LSB
		fprintf(fcode, "	mov     a,r2\n");
		fprintf(fcode, "	rlc     a\n");
		fprintf(fcode, "	mov     r2,a\n");
		fprintf(fcode, "	mov     a,r3\n");
       		fprintf(fcode, "	rlc     a\n");
		fprintf(fcode, "        mov     r3,a\n");
		fprintf(fcode, "        ret\n");
	}
	if (need_DIVU&2) {	
		need_DIV_4_core = 1;
		fprintf(fcode, "DIV_4U:\n");
		fprintf(fcode, "	clr	0x21.0\n");
		fprintf(fcode, "	mov     r7_3, r1\n");	// load divisor
		fprintf(fcode, "	mov     r6_3, r0\n");
		fprintf(fcode, "	mov     r5_3, r3\n");
		fprintf(fcode, "	mov     r4_3, r2\n");
		fprintf(fcode, "	mov     r7_2, r7\n");	// load divisor
		fprintf(fcode, "	mov     r6_2, r6\n");
		fprintf(fcode, "	mov     r5_2, r5\n");
		fprintf(fcode, "	mov     r4_2, r4\n");
		if (!(need_DIV&2)) 
			fprintf(fcode, "	sjmp	DIV4_d\n");
	}
	return(0);
}
#ifdef MPW
#pragma segment postlude2
#endif
int
postlude2()
{
	if (need_DIV&2) {
		need_DIV_4_core = 1;
		fprintf(fcode, "DIV_4:\n");
        	//This divides the 32 bit r7:4 by r1:r0:r3:r2 register by the value supplied

		fprintf(fcode, "	mov     a, r1\n");	// load divisor
		fprintf(fcode, "	rlc	a\n");
		fprintf(fcode, "	mov	0x21.0, c\n");
		fprintf(fcode, "	jb	acc.7, DIV4_a\n");	// load divisor
		
		fprintf(fcode, "		mov     r7_3, a\n");	// load divisor
		fprintf(fcode, "		mov     r6_3, r0\n");
		fprintf(fcode, "		mov     r5_3, r3\n");
		fprintf(fcode, "		mov     r4_3, r2\n");
		fprintf(fcode, "		sjmp	DIV4_b\n");
		fprintf(fcode, "DIV4_a:\n");
		fprintf(fcode, "		mov     a, r2\n");
		fprintf(fcode, "		cpl     a\n");
		fprintf(fcode, "		add     a, #1\n");
		fprintf(fcode, "		mov     r4_3, a\n");
		fprintf(fcode, "		mov     a, r3\n");
		fprintf(fcode, "		cpl     a\n");
		fprintf(fcode, "		addc    a, #0\n");
		fprintf(fcode, "		mov     r5_3, a\n");
		fprintf(fcode, "		mov     a, r0\n");
		fprintf(fcode, "		cpl     a\n");
		fprintf(fcode, "		addc    a, #0\n");
		fprintf(fcode, "		mov     r6_3, a\n");
		fprintf(fcode, "		mov     a, r1\n");
		fprintf(fcode, "		cpl     a\n");
		fprintf(fcode, "		addc    a, #0\n");
		fprintf(fcode, "		mov     r7_3, a\n");
		fprintf(fcode, "DIV4_b:\n");

		fprintf(fcode, "	mov     a, r7\n");	// load divisor
		fprintf(fcode, "	jb	acc.7, DIV4_c\n");	// load divisor
		
		fprintf(fcode, "		mov     r7_2, a\n");	// load divisor
		fprintf(fcode, "		mov     r6_2, r6\n");
		fprintf(fcode, "		mov     r5_2, r5\n");
		fprintf(fcode, "		mov     r4_2, r4\n");
		fprintf(fcode, "		sjmp	DIV4_d\n");
		fprintf(fcode, "DIV4_c:\n");
		fprintf(fcode, "		cpl     0x21.0\n");
		fprintf(fcode, "		mov     a, r4\n");
		fprintf(fcode, "		cpl     a\n");
		fprintf(fcode, "		add     a, #1\n");
		fprintf(fcode, "		mov     r4_2, a\n");
		fprintf(fcode, "		mov     a, r5\n");
		fprintf(fcode, "		cpl     a\n");
		fprintf(fcode, "		addc    a, #0\n");
		fprintf(fcode, "		mov     r5_2, a\n");
		fprintf(fcode, "		mov     a, r6\n");
		fprintf(fcode, "		cpl     a\n");
		fprintf(fcode, "		addc    a, #0\n");
		fprintf(fcode, "		mov     r6_2, a\n");
		fprintf(fcode, "		mov     a, r7\n");
		fprintf(fcode, "		cpl     a\n");
		fprintf(fcode, "		addc    a, #0\n");
		fprintf(fcode, "		mov     r7_2, a\n");
	}
	if (need_DIV_4_core) {
		fprintf(fcode, "DIV4_d:\n");

		fprintf(fcode, "	mov     r2,#0\n");
		fprintf(fcode, "	mov     r3,#0\n");
		fprintf(fcode, "	mov     r1,#0\n");
		fprintf(fcode, "	mov     r0,#0\n");
		fprintf(fcode, "	mov     r4,#0\n");
		fprintf(fcode, "	mov     r5,#0\n");          	// zero out partial remainder
		fprintf(fcode, "	mov     r6,#0\n");
		fprintf(fcode, "	mov     r7,#0\n");
		fprintf(fcode, "	mov     scratch1,#32\n");         	// loop count
        	// This begins the loop
		fprintf(fcode, "Div_loop4:\n");
		fprintf(fcode, "	lcall    Shift_D4\n");        	// shift the dividend and return MSB in C
		fprintf(fcode, "	mov     a,r4\n");           	// shift carry into LSB of partial remainder
		fprintf(fcode, "	rlc     a\n");
		fprintf(fcode, "	mov     r4,a\n");
		fprintf(fcode, "	mov     a,r5\n");
		fprintf(fcode, "	rlc     a\n");
		fprintf(fcode, "	mov     r5,a\n");
		fprintf(fcode, "	mov     a,r6\n");
		fprintf(fcode, "	rlc     a\n");
		fprintf(fcode, "	mov     r6,a\n");
		fprintf(fcode, "	mov     a,r7\n");
		fprintf(fcode, "	rlc     a\n");
		fprintf(fcode, "	mov     r7,a\n");
        	// now test to see if R7:R6 <= R1:R0
		fprintf(fcode, "	jc	Can_sub4\n");
		fprintf(fcode, "	clr     c\n");
		fprintf(fcode, "	mov     a,r7\n");           	// subtract R7 from R1 to see if R7 < R1
		fprintf(fcode, "	subb    a,r7_3\n");           	//  A = R1 - R7, carry set if R1 < R7
		fprintf(fcode, "	jc      Cant_sub4\n");
        	// at this point R7<R1 or R7=R1
		fprintf(fcode, "	jnz     Can_sub4\n");        	// jump if R7>R1
        	// now test to see if R7:R6 <= R1:R0
		fprintf(fcode, "	clr     c\n");
		fprintf(fcode, "	mov     a,r6\n");           	// subtract R7 from R1 to see if R7 < R1
		fprintf(fcode, "	subb    a,r6_3\n");           	//  A = R1 - R7, carry set if R1 < R7
		fprintf(fcode, "	jc      Cant_sub4\n");
        	// at this point R7<R1 or R7=R1
		fprintf(fcode, "	jnz     Can_sub4\n");        	// jump if R7>R1
        	// now test to see if R7:R6 <= R1:R0
		fprintf(fcode, "	clr     c\n");
		fprintf(fcode, "	mov     a,r5\n");           	// subtract R7 from R1 to see if R7 < R1
		fprintf(fcode, "	subb    a,r5_3\n");           	//  A = R1 - R7, carry set if R1 < R7
		fprintf(fcode, "	jc      Cant_sub4\n");
        	// at this point R7<R1 or R7=R1
		fprintf(fcode, "	jnz     Can_sub4\n");        	// jump if R7>R1
        	// if R7 = R1, test for R6<=R0
		fprintf(fcode, "	clr     c\n");
		fprintf(fcode, "	mov     a,r4\n");
		fprintf(fcode, "	subb    a,r4_3\n");           	//  A = R0 - R6, carry set if R0 < R6
		fprintf(fcode, "	jc      Cant_sub4\n");
		fprintf(fcode, "Can_sub4:\n");
        	// subtract the divisor from the partial remainder
		fprintf(fcode, "	clr     c\n");
		fprintf(fcode, "	mov     a,r4\n");
		fprintf(fcode, "	subb    a,r4_3\n");           	//  A = R0 - R6
		fprintf(fcode, "	mov     r4,a\n");
		fprintf(fcode, "	mov     a,r5\n");
		fprintf(fcode, "	subb    a,r5_3\n");           	//  a = R1 - R7 - Borrow
		fprintf(fcode, "	mov     r5,a\n");
		fprintf(fcode, "	mov     a,r6\n");
		fprintf(fcode, "	subb    a,r6_3\n");           	//  a = R1 - R7 - Borrow
		fprintf(fcode, "	mov     r6,a\n");
		fprintf(fcode, "	mov     a,r7\n");
		fprintf(fcode, "	subb    a,r7_3\n");           	//  a = R1 - R7 - Borrow
		fprintf(fcode, "	mov     r7,a\n");
		fprintf(fcode, "	setb    c\n");              	//  shift a 1 into the quotient
		fprintf(fcode, "	sjmp     Quot4\n");
		fprintf(fcode, "Cant_sub4:\n");
        	// shift a 0 into the quotient
		fprintf(fcode, "	clr     c\n");
		fprintf(fcode, "Quot4:\n");
        	// shift the carry bit into the quotient
		fprintf(fcode, "	lcall    Shift_Q4\n");
        	//  Test for competion
		fprintf(fcode, "	djnz    scratch1,Div_loop4\n");
        	//  Now we are all done, move the TMP values back into OP
	
		fprintf(fcode, "	jnb     0x21.0, DIV4_e\n");	
		fprintf(fcode, "		mov     a, r2\n");
		fprintf(fcode, "		cpl     a\n");
		fprintf(fcode, "		add     a, #1\n");
		fprintf(fcode, "		mov     r2, a\n");
		fprintf(fcode, "		mov     a, r3\n");
		fprintf(fcode, "		cpl     a\n");
		fprintf(fcode, "		addc    a, #0\n");
		fprintf(fcode, "		mov     r3, a\n");
		fprintf(fcode, "		mov     a, r0\n");
		fprintf(fcode, "		cpl     a\n");
		fprintf(fcode, "		addc    a, #0\n");
		fprintf(fcode, "		mov     r0, a\n");
		fprintf(fcode, "		mov     a, r1\n");
		fprintf(fcode, "		cpl     a\n");
		fprintf(fcode, "		addc    a, #0\n");
		fprintf(fcode, "		mov     r1, a\n");
		fprintf(fcode, "DIV4_e:\n");
		fprintf(fcode, "	ret\n");

		fprintf(fcode, "Shift_D4:\n");
        	// shift the dividend one bit to the left and return the MSB in C
		fprintf(fcode, "	clr     c\n");
		fprintf(fcode, "	mov     a,r4_2\n");
		fprintf(fcode, "	rlc     a\n");
		fprintf(fcode, "	mov     r4_2,a\n");
		fprintf(fcode, "	mov     a,r5_2\n");
		fprintf(fcode, "	rlc     a\n");
		fprintf(fcode, "	mov     r5_2,a\n");
		fprintf(fcode, "	mov     a,r6_2\n");
		fprintf(fcode, "	rlc     a\n");
		fprintf(fcode, "	mov     r6_2,a\n");
		fprintf(fcode, "	mov     a,r7_2\n");
		fprintf(fcode, "	rlc     a\n");
		fprintf(fcode, "	mov     r7_2,a\n");
		fprintf(fcode, "	ret\n");
 
		fprintf(fcode, "Shift_Q4:\n");
        	// shift the quotent one bit to the left and shift the C into LSB
		fprintf(fcode, "	mov     a,r2\n");
		fprintf(fcode, "	rlc     a\n");
		fprintf(fcode, "	mov     r2,a\n");
		fprintf(fcode, "	mov     a,r3\n");
       		fprintf(fcode, "	rlc     a\n");
		fprintf(fcode, "        mov     r3,a\n");
		fprintf(fcode, "	mov     a,r0\n");
       		fprintf(fcode, "	rlc     a\n");
		fprintf(fcode, "        mov     r0,a\n");
		fprintf(fcode, "	mov     a,r1\n");
       		fprintf(fcode, "	rlc     a\n");
		fprintf(fcode, "        mov     r1,a\n");
		fprintf(fcode, "        ret\n");
	}
	if (need_INTR) {
		fprintf(fcode, "INTR:\n");
		fprintf(fcode, "	mov	a, pend_int\n");
		fprintf(fcode, "	anl	a, r2\n");
		fprintf(fcode, "	jz	INTR_1\n");
		fprintf(fcode, "		mov	a, r2\n");
		fprintf(fcode, "		cpl	a\n");
		fprintf(fcode, "		clr	EA\n");
		fprintf(fcode, "		anl	a, pend_int\n");
		fprintf(fcode, "		mov	pend_int, a\n");
		fprintf(fcode, "		setb	EA\n");
		fprintf(fcode, "INTR_1:\n");
		fprintf(fcode, "	mov	r2, a\n");
		fprintf(fcode, "	mov	r3, a\n");
		fprintf(fcode, "	ret\n");
	}
	if (need_SAVE_TIME) {
		fprintf(fcode, "SAVE_TIME:\n");	
		fprintf(fcode, "	mov	a, #0x10\n");	
		fprintf(fcode, "	orl	a, pend_int\n");	
		fprintf(fcode, "	mov	pend_int, a\n");	
		fprintf(fcode, "	clr	EA\n");
		fprintf(fcode, "	mov	gtime_2, 0x3e\n");	// save result ....
		fprintf(fcode, "	mov	gtime_1, 0x3d\n");
		fprintf(fcode, "	mov	gtime_0, 0x3c\n");
		fprintf(fcode, "	setb	EA\n");
		fprintf(fcode, "	mov	gtime_3, time_3\n");
		fprintf(fcode, "	mov	acc, time_2\n");		// calc high byte
		fprintf(fcode, "	jnb	acc.7, SAVE_TIME1\n");	
		fprintf(fcode, "	mov	acc, gtime_2\n");	
		fprintf(fcode, "	jb	acc.7, SAVE_TIME1\n");
		fprintf(fcode, "		inc	gtime_3\n");	
		fprintf(fcode, "SAVE_TIME1:\n");	
		fprintf(fcode, "	ret\n");
	}
	if (need_CMP_TIME) {
		int l=lab++;
		fprintf(fcode, "CMP_TIME:\n");
		fprintf(fcode, "	mov	a, pend_int\n");
		fprintf(fcode, "	jnb	acc.4, XY%04x\n", l);
		fprintf(fcode, "	mov	a, r2\n");
		fprintf(fcode, "	add	a, gtime_0\n");
		fprintf(fcode, "	mov	r2, a\n");
		fprintf(fcode, "	mov	a, r3\n");
		fprintf(fcode, "	addc	a, gtime_1\n");
		fprintf(fcode, "	mov	r3, a\n");
		fprintf(fcode, "	mov	a, r0\n");
		fprintf(fcode, "	addc	a, gtime_2\n");
		fprintf(fcode, "	mov	r0, a\n");
		fprintf(fcode, "	mov	a, r1\n");
		fprintf(fcode, "	addc	a, gtime_3\n");
		fprintf(fcode, "	mov	r1, a\n");


		fprintf(fcode, "	clr	c\n");
		fprintf(fcode, "	mov	a, r2\n");
		fprintf(fcode, "	subb	a, time_0\n");
		fprintf(fcode, "	mov	a, r3\n");
		fprintf(fcode, "	subb	a, time_1\n");
		fprintf(fcode, "	mov	a, r0\n");
		fprintf(fcode, "	subb	a, time_2\n");
		fprintf(fcode, "	mov	a, r1\n");
		fprintf(fcode, "	subb	a, time_3\n");
		fprintf(fcode, "	jb	acc.7, XX%04x\n", l);
		fprintf(fcode, "XY%04x:\n", l);
		fprintf(fcode, "	mov	r2, #0\n");
		fprintf(fcode, "	mov	r3, #0\n");
		fprintf(fcode, "	ret\n");
		fprintf(fcode, "XX%04x:\n", l);
		fprintf(fcode, "	mov	a, pend_int\n");	
		fprintf(fcode, "	anl	a, #0xef\n");	
		fprintf(fcode, "	mov	pend_int, a\n");	
		fprintf(fcode, "	mov	r2, #0xff\n");
		fprintf(fcode, "	mov	r3, #0xff\n");
		fprintf(fcode, "	ret\n");
	
	}
	return(0);
}
#ifdef MPW
#pragma segment postlude3
#endif
int
postlude3()
{
	int i;
	
	if (need_INPUT) {
		fprintf(fcode, "poll_vector=0x80\n");
		fprintf(fcode, "INPUT:\n");
		fprintf(fcode, "	mov	r0, #poll_vector\n");
		fprintf(fcode, "	mov	a, @r0\n");
		fprintf(fcode, "	mov	dpl, a\n");
		fprintf(fcode, "	inc	r0\n");
		fprintf(fcode, "	mov	a, @r0\n");
		fprintf(fcode, "	mov	dph, a\n");
		fprintf(fcode, "	clr	a\n");
		fprintf(fcode, "	jmp	@a+dptr\n");
	}
	if (need_SAFE) {
		fprintf(fcode, "SAFE:\n");
		if (logging)
			fprintf(fcode, "	mov	r4, r2\n");
		fprintf(fcode, "	setb	p3.2\n");
		if (logging) {
			// PUSH(pc);
			// PUSH(0);
			fprintf(fcode, "	pop	r1_0\n");
			fprintf(fcode, "	pop	r0_0\n");
			PUSH(1);
			// PUSH(tos);
			// PUSH(0x43);
			fprintf(fcode, "	mov	r0, r4\n");
			fprintf(fcode, "	mov	r1, #0\n");
			fprintf(fcode, "	mov	r2, #0x45\n");
			fprintf(fcode, "	mov	r3, #0\n");
			PUSH(1);
			fprintf(fcode, "	mov	r2, #(trampoline)&0xff\n");
			fprintf(fcode, "	mov	r3, #(trampoline>>8)&0xff\n");
			fprintf(fcode, "	ljmp	extra\n");
		} else {
			fprintf(fcode, "	ret\n");
		}
	}
	if (need_ARM) {
		fprintf(fcode, "ARM:\n");
		if (logging)
			fprintf(fcode, "	mov	r4, r2\n");
		fprintf(fcode, "	clr	p3.2\n");
		if (logging) {
			// PUSH(pc);
			// PUSH(0);
			fprintf(fcode, "	pop	r1_0\n");
			fprintf(fcode, "	pop	r0_0\n");
			PUSH(1);
			// PUSH(tos);
			// PUSH(0x43);
			fprintf(fcode, "	mov	r0, r4\n");
			fprintf(fcode, "	mov	r1, #0\n");
			fprintf(fcode, "	mov	r2, #0x44\n");
			fprintf(fcode, "	mov	r3, #0\n");
			PUSH(1);
			fprintf(fcode, "	mov	r2, #(trampoline)&0xff\n");
			fprintf(fcode, "	mov	r3, #(trampoline>>8)&0xff\n");
			fprintf(fcode, "	ljmp	extra\n");
		} else {
			fprintf(fcode, "	ret\n");
		}
	}
	if (need_FIRE) {
		fprintf(fcode, "FIRE:\n");
		fprintf(fcode, "	mov	a, r2\n");
		if (logging) 
			fprintf(fcode, "	mov	r4, a\n");
		fprintf(fcode, "	rrc	a\n");
		fprintf(fcode, "	mov	p3.3, c\n");
		fprintf(fcode, "	rrc	a\n");
		fprintf(fcode, "	mov	p3.4, c\n");
		fprintf(fcode, "	rrc	a\n");
		fprintf(fcode, "	mov	p3.5, c\n");
		if (logging) {
			// PUSH(pc);
			// PUSH(0);
			fprintf(fcode, "	pop	r1_0\n");
			fprintf(fcode, "	pop	r0_0\n");
			PUSH(1);
			// PUSH(tos);
			// PUSH(0x43);
			fprintf(fcode, "	mov	r0, r4\n");
			fprintf(fcode, "	mov	r1, #0\n");
			fprintf(fcode, "	mov	r2, #0x43\n");
			fprintf(fcode, "	mov	r3, #0\n");
			PUSH(1);
			fprintf(fcode, "	mov	r2, #(trampoline)&0xff\n");
			fprintf(fcode, "	mov	r3, #(trampoline>>8)&0xff\n");
			fprintf(fcode, "	ljmp	extra\n");
		} else {
			fprintf(fcode, "	ret\n");
		}
	}
	if (need_RTIME) {
		fprintf(fcode, "RTIME:\n");
		fprintf(fcode, "	clr	EA\n");
		fprintf(fcode, "	mov	r0, 0x3e\n");
		fprintf(fcode, "	mov	r3, 0x3d\n");
		fprintf(fcode, "	mov	r2, 0x3c\n");
		fprintf(fcode, "	setb	EA\n");
		fprintf(fcode, "	mov	r1, time_3\n");	// save result ....
		fprintf(fcode, "	mov	a, r0\n");
		fprintf(fcode, "	jb	acc.7, RTIME1\n");
		fprintf(fcode, "	mov	a, time_2\n");
		fprintf(fcode, "	jnb	acc.7, RTIME1\n");
		fprintf(fcode, "	inc	r1\n");
		fprintf(fcode, "RTIME1:\n");
		fprintf(fcode, "	ret\n");
	}
	if (need_TIME) {
		fprintf(fcode, "TIME:\n");
		fprintf(fcode, "	mov	r2, time_0\n");
		fprintf(fcode, "	mov	r3, time_1\n");
		fprintf(fcode, "	mov	r0, time_2\n");
		fprintf(fcode, "	mov	r1, time_3\n");
		fprintf(fcode, "	ret\n");
	}
	if (need_LTIME) {
		fprintf(fcode, "LTIME:\n");
		fprintf(fcode, "	mov	r2, ltime_0\n");
		fprintf(fcode, "	mov	r3, ltime_1\n");
		fprintf(fcode, "	mov	r0, ltime_2\n");
		fprintf(fcode, "	mov	r1, ltime_3\n");
		fprintf(fcode, "	ret\n");
	
	}
	if (need_POLL) {
		fprintf(fcode, "POLL:\n");
		fprintf(fcode, "	push	time_2\n");
		fprintf(fcode, "	clr	EA\n");
		fprintf(fcode, "	mov	a, 0x3e\n");	// save result ....
		fprintf(fcode, "	mov	time_1, 0x3d\n");
		fprintf(fcode, "	mov	time_0, 0x3c\n");
		fprintf(fcode, "	setb	EA\n");
		fprintf(fcode, "	mov	time_2, a\n");
		fprintf(fcode, "	jb	acc.7, POLL1\n");
		fprintf(fcode, "	pop	acc\n");
		fprintf(fcode, "	jnb	acc.7, POLL2\n");
		fprintf(fcode, "		inc	time_3\n");
		fprintf(fcode, "		sjmp	POLL2\n");
		fprintf(fcode, "POLL1:\n");
		fprintf(fcode, "	pop	acc\n");
		fprintf(fcode, "POLL2:\n");
		if (logging) {
			fprintf(fcode, "	pop	r3_0\n");
			fprintf(fcode, "	pop	r2_0\n");
			fprintf(fcode, "	ljmp	log_poll_addr\n");
		} else {
			fprintf(fcode, "	ret\n");
		}
	}	
	if (need_BEEP) {	
		fprintf(fcode, "BEEP:\n");
		fprintf(fcode, "	mov	a, r2\n");
		fprintf(fcode, "	cpl	a\n");
		fprintf(fcode, "	rrc	a\n");
		fprintf(fcode, "	mov	p1.7, c\n");
		fprintf(fcode, "	ret\n");
	}
	if (need_PSTR) {
		need_PCHR = 1;
		fprintf(fcode, "PSTR:\n");
		fprintf(fcode, "	mov	dpl, r2\n");
		fprintf(fcode, "	mov	dph, r3\n");
		fprintf(fcode, "PSTR_1:\n");
		fprintf(fcode, "		movx	a, @dptr\n");
		fprintf(fcode, "		jz	PSTR_2\n");
		fprintf(fcode, "		inc	dptr\n");
		fprintf(fcode, "		mov	r2, a\n");
		fprintf(fcode, "		push	dpl\n");
		fprintf(fcode, "		push	dph\n");
		fprintf(fcode, "		lcall	PCHR\n");
		fprintf(fcode, "		pop	dph\n");
		fprintf(fcode, "		pop	dpl\n");
		fprintf(fcode, "		sjmp	PSTR_1\n");
		fprintf(fcode, "PSTR_2:\n");
		fprintf(fcode, "	ret\n");
		
	}
	if (need_PHEXL) {
		need_PHEX = 1;
		fprintf(fcode, "PHEXL:\n");	
		fprintf(fcode, "	push	r3_0\n");
		fprintf(fcode, "	push	r2_0\n");
		fprintf(fcode, "	mov	r3, r1_0\n");
		fprintf(fcode, "	mov	r2, r0_0\n");
		fprintf(fcode, "	lcall	PHEX\n");
		fprintf(fcode, "	pop	r2_0\n");
		fprintf(fcode, "	pop	r3_0\n");
	}
	// insert nothing here!
	if (need_PHEX) {
		need_PCHR = 1;
		fprintf(fcode, "PHEX:\n");	
		fprintf(fcode, "	mov	a, r3\n");
		fprintf(fcode, "	lcall 	PHEX_1\n");
		fprintf(fcode, "	mov	a, r2\n");
		fprintf(fcode, "PHEX_1:\n");	
		fprintf(fcode, "	push	acc\n");
		fprintf(fcode, "	swap	a\n");
		fprintf(fcode, "	lcall	PHEX_2\n");
		fprintf(fcode, "	pop	acc\n");
		fprintf(fcode, "PHEX_2:\n");	
		fprintf(fcode, "	anl	a, #0xf\n");	
		fprintf(fcode, "	cjne	a, #0xa, PHEX_3\n");	
		fprintf(fcode, "PHEX_3:\n");	
		fprintf(fcode, "	jc	PHEX_4\n");	
		fprintf(fcode, "	add	a, #(('A'-10)-'0')\n");
		fprintf(fcode, "PHEX_4:\n");	
		fprintf(fcode, "	add	a, #'0'\n");
		fprintf(fcode, "	mov	r1, a\n");
		fprintf(fcode, "	sjmp	PCHR_1\n");
	}
	if (need_PVAL&2) {
		need_PVAL_core = 1;
		fprintf(fcode, "PVALU:\n");	
		fprintf(fcode, "	mov	a, r2\n");
		fprintf(fcode, "	orl	a, r3\n");
		fprintf(fcode, "	orl	a, r1\n");
		fprintf(fcode, "	orl	a, r0\n");
		fprintf(fcode, "	jnz	PVAL_2\n");
		fprintf(fcode, "		mov	r1, #'0'\n");
		fprintf(fcode, "		sjmp	PCHR_1\n");
	}
	if (need_PVAL&1) {
		need_PCHR = 1;
		need_PVAL_core = 1;
		fprintf(fcode, "PVAL:\n");	
		fprintf(fcode, "	mov	a, r2\n");
		fprintf(fcode, "	orl	a, r3\n");
		fprintf(fcode, "	orl	a, r1\n");
		fprintf(fcode, "	orl	a, r0\n");
		fprintf(fcode, "	jnz	PVAL_1\n");
		fprintf(fcode, "		mov	r1, #'0'\n");
		fprintf(fcode, "		sjmp	PCHR_1\n");
		fprintf(fcode, "PVAL_1:\n");	
		fprintf(fcode, "	mov	a, r1\n");
		fprintf(fcode, "	rlc	a\n");
		fprintf(fcode, "	jnc	PVAL_2\n");
		fprintf(fcode, "		mov	a, r2\n");
		fprintf(fcode, "		cpl	a\n");
		fprintf(fcode, "		add	a, #1\n");
		fprintf(fcode, "		mov	r2, a\n");
		fprintf(fcode, "		mov	a, r3\n");
		fprintf(fcode, "		cpl	a\n");
		fprintf(fcode, "		addc	a, #0\n");
		fprintf(fcode, "		mov	r3, a\n");
		fprintf(fcode, "		mov	a, r0\n");
		fprintf(fcode, "		cpl	a\n");
		fprintf(fcode, "		addc	a, #0\n");
		fprintf(fcode, "		mov	r0, a\n");
		fprintf(fcode, "		mov	a, r1\n");
		fprintf(fcode, "		cpl	a\n");
		fprintf(fcode, "		addc	a, #0\n");
		fprintf(fcode, "		mov	r1, a\n");
		fprintf(fcode, "		push	r3_0\n");
		fprintf(fcode, "		push	r2_0\n");
		fprintf(fcode, "		push	r1_0\n");
		fprintf(fcode, "		push	r0_0\n");
		fprintf(fcode, "		mov	r1, #'-'\n");
		fprintf(fcode, "		lcall	PCHR_1\n");
		fprintf(fcode, "		pop	r0_0\n");
		fprintf(fcode, "		pop	r1_0\n");
		fprintf(fcode, "		pop	r2_0\n");
		fprintf(fcode, "		pop	r3_0\n");
	}
	if (need_PVAL_core) {
		need_PCHR = 1;
		need_DIVU |= 2;
		fprintf(fcode, "PVAL_2:\n");	
		fprintf(fcode, "	mov	a, r3\n");
		fprintf(fcode, "	orl	a, r0\n");
		fprintf(fcode, "	orl	a, r1\n");
		fprintf(fcode, "	jnz	PVAL_3\n");
		fprintf(fcode, "	cjne	r2, #10, PVAL_4\n");
		fprintf(fcode, "PVAL_4:\n");	
		fprintf(fcode, "	jc	PVAL_5\n");
		fprintf(fcode, "PVAL_3:\n");	
		fprintf(fcode, "	mov	r5, r3\n");	
		fprintf(fcode, "	mov	r4, r2\n");	
		fprintf(fcode, "	mov	r6, r0\n");	
		fprintf(fcode, "	mov	r7, r1\n");	
		fprintf(fcode, "	mov	r2, #10\n");	
		fprintf(fcode, "	clr	a\n");	
		fprintf(fcode, "	mov	r3, a\n");	
		fprintf(fcode, "	mov	r1, a\n");	
		fprintf(fcode, "	mov	r0, a\n");	
		fprintf(fcode, "	lcall	DIV_4U\n");		// res in r1:r0:r3:r2 mod in r7:4
		fprintf(fcode, "	push	r4_0\n");	
		fprintf(fcode, "	lcall	PVAL_2\n");		// recurse
		fprintf(fcode, "	pop	acc\n");	
		fprintf(fcode, "	add	a, #'0'\n");		// and print mod
		fprintf(fcode, "	mov	r1, a\n");
		fprintf(fcode, "	sjmp	PCHR_1\n");
	

		fprintf(fcode, "PVAL_5:\n");	
		fprintf(fcode, "	mov	a, r2\n");
		fprintf(fcode, "	add	a, #'0'\n");
		fprintf(fcode, "	mov	r1, a\n");
		fprintf(fcode, "	sjmp	PCHR_1\n");
	}
	if (need_PCHR) {
		fprintf(fcode, "send_vector=0x86\n");
		fprintf(fcode, "PCHR:\n");
		fprintf(fcode, "	mov	r1, r2\n");
		fprintf(fcode, "	cjne	r1, #0xa, PCHR_1\n");
		fprintf(fcode, "	mov	r1, #0xd\n");
		fprintf(fcode, "	lcall	PCHR_1\n");
		fprintf(fcode, "	mov	r1, #0xa\n");
		fprintf(fcode, "PCHR_1:\n");
		fprintf(fcode, "	mov	r0, #send_vector\n");
		fprintf(fcode, "	mov	a, @r0\n");
		fprintf(fcode, "	mov	dpl, a\n");
		fprintf(fcode, "	inc	r0\n");
		fprintf(fcode, "	mov	a, @r0\n");
		fprintf(fcode, "	mov	dph, a\n");
		fprintf(fcode, "	clr	a\n");
		fprintf(fcode, "	jmp	@a+dptr\n");
	}
	if (need_EESAVE) {
		need_call_uv =1;
		fprintf(fcode, "EESAVE:\n");
		fprintf(fcode, "	mov	r4_2, r4\n");	// src (mem)
		fprintf(fcode, "	mov	r5_2, r5\n");
		fprintf(fcode, "	mov	r6_2, r2\n");	// dest (ee)
		fprintf(fcode, "	mov	r7_2, r3\n");
		fprintf(fcode, "	mov	r4_3, r0\n");	// count
		fprintf(fcode, "	mov	r5_3, r1\n");
		fprintf(fcode, "EESAVE_1:\n");			// all done?
		fprintf(fcode, "	mov	a, r4_3\n");
		fprintf(fcode, "	orl	a, r5_3\n");
		fprintf(fcode, "	jnz	EESAVE_2\n");
		fprintf(fcode, "		ret\n");
		fprintf(fcode, "EESAVE_2:\n");
		fprintf(fcode, "	mov	a, r6_2\n");
		fprintf(fcode, "	anl	a, #0xf\n");
		fprintf(fcode, "	mov	r0, a\n");
		fprintf(fcode, "	mov	a, #16\n");
		fprintf(fcode, "	clr	c\n");
		fprintf(fcode, "	subb	a, r0\n");	// count to move
		fprintf(fcode, "	mov	r3, a\n");	// count to move

		fprintf(fcode, "	mov	a, r5_3\n");	// see if it's > than the requested amount
		fprintf(fcode, "	jnz	EESAVE_5\n");
		fprintf(fcode, "	mov	a, r4_3\n");
		fprintf(fcode, "	clr	c\n");
		fprintf(fcode, "	subb	a, r3\n");
		fprintf(fcode, "	jnc	EESAVE_5\n");	
		fprintf(fcode, "		mov	r3, r4_3\n");
		fprintf(fcode, "		mov	r4_3, #0\n");
		fprintf(fcode, "		mov	r5_3, #0\n");
		fprintf(fcode, "		sjmp	EESAVE_3\n");	
		fprintf(fcode, "EESAVE_5:\n");
		fprintf(fcode, "		clr	c\n");
		fprintf(fcode, "		mov	a, r4_3\n");
		fprintf(fcode, "		subb	a, r3\n");
		fprintf(fcode, "		mov	r4_3, a\n");
		fprintf(fcode, "		mov	a, r5_3\n");
		fprintf(fcode, "		subb	a, #0\n");
		fprintf(fcode, "		mov	r5_3, a\n");
		fprintf(fcode, "EESAVE_3:\n");
		fprintf(fcode, "	push	r3_0\n");	
		fprintf(fcode, "	mov	r0, #0xf0\n");
		fprintf(fcode, "	mov	dpl, r4_2\n");
		fprintf(fcode, "	mov	dph, r5_2\n");
		fprintf(fcode, "EESAVE_4:\n");
		fprintf(fcode, "		movx	a, @dptr\n");
		fprintf(fcode, "		mov	@r0, a\n");	// copy it in
		fprintf(fcode, "		inc	dptr\n");
		fprintf(fcode, "		inc	r0\n");
		fprintf(fcode, "		djnz	r3, EESAVE_4\n");
		fprintf(fcode, "	mov	r4_2, dpl\n");
		fprintf(fcode, "	mov	r5_2, dph\n");
		fprintf(fcode, "EESAVE_3a:\n");
		fprintf(fcode, "		pop	r3_0\n");	
		fprintf(fcode, "		push	r3_0\n");	
		fprintf(fcode, "		mov	r0, #0xf0\n");	// do the read
		fprintf(fcode, "		mov	r7, r6_2\n");
		fprintf(fcode, "		mov	r6, r7_2\n");
		fprintf(fcode, "		mov	r2, #'W'\n");
		fprintf(fcode, "		lcall	call_uv\n");
		fprintf(fcode, "	jc	EESAVE_3a\n");
		fprintf(fcode, "	pop	r3_0\n");
		fprintf(fcode, "	mov	a, r6_2\n");	// update the dest pointer
		fprintf(fcode, "	add	a, r3\n");
		fprintf(fcode, "	mov	r6_2, a\n");
		fprintf(fcode, "	mov	a, r7_2\n");
		fprintf(fcode, "	addc	a, #0\n");
		fprintf(fcode, "	mov	r7_2, a\n");
		fprintf(fcode, "	sjmp	EESAVE_1\n");
	}
	if (need_EELOAD) {
		need_call_uv =1;
		fprintf(fcode, "EELOAD:\n");
		fprintf(fcode, "	mov	r4_2, r2\n");	// dest (mem)
		fprintf(fcode, "	mov	r5_2, r3\n");
		fprintf(fcode, "	mov	r6_2, r4\n");	// src (ee)
		fprintf(fcode, "	mov	r7_2, r5\n");
		fprintf(fcode, "	mov	r4_3, r0\n");	// count
		fprintf(fcode, "	mov	r5_3, r1\n");
		fprintf(fcode, "EELOAD_1:\n");			// all done?
		fprintf(fcode, "	mov	a, r5_3\n");
		fprintf(fcode, "	jnz	EELOAD_2\n");
		fprintf(fcode, "	mov	a, r4_3\n");
		fprintf(fcode, "	jnz	EELOAD_2\n");
		fprintf(fcode, "		ret\n");
		fprintf(fcode, "EELOAD_2:\n");
		fprintf(fcode, "	mov	a, r4_2\n");
		fprintf(fcode, "	anl	a, #0xf\n");
		fprintf(fcode, "	mov	r0, a\n");
		fprintf(fcode, "	mov	a, #16\n");
		fprintf(fcode, "	clr	c\n");
		fprintf(fcode, "	subb	a, r0\n");	// count to move
		fprintf(fcode, "	mov	r3, a\n");	// count to move

		fprintf(fcode, "	mov	a, r5_3\n");	// see if it's > than the requested amount
		fprintf(fcode, "	jnz	EELOAD_5\n");
		fprintf(fcode, "	mov	a, r4_3\n");
		fprintf(fcode, "	clr	c\n");
		fprintf(fcode, "	subb	a, r3\n");
		fprintf(fcode, "	jnc	EELOAD_5\n");	
		fprintf(fcode, "		mov	r3, r4_3\n");
		fprintf(fcode, "		mov	r4_3, #0\n");
		fprintf(fcode, "		mov	r5_3, #0\n");
		fprintf(fcode, "		sjmp	EELOAD_3\n");	
		fprintf(fcode, "EELOAD_5:\n");
		fprintf(fcode, "		clr	c\n");
		fprintf(fcode, "		mov	a, r4_3\n");
		fprintf(fcode, "		subb	a, r3\n");
		fprintf(fcode, "		mov	r4_3, a\n");
		fprintf(fcode, "		mov	a, r5_3\n");
		fprintf(fcode, "		subb	a, #0\n");
		fprintf(fcode, "		mov	r5_3, a\n");
		fprintf(fcode, "EELOAD_3:\n");
		fprintf(fcode, "		push	r3_0\n");	// do the read
		fprintf(fcode, "		mov	r0, #0xf0\n");
		fprintf(fcode, "		mov	r7, r6_2\n");
		fprintf(fcode, "		mov	r6, r7_2\n");
		fprintf(fcode, "		mov	r2, #'R'\n");
		fprintf(fcode, "		lcall	call_uv\n");
		fprintf(fcode, "		pop	r3_0\n");
		fprintf(fcode, "	jc	EELOAD_3\n");
		fprintf(fcode, "	mov	a, r6_2\n");	// update the source pointer
		fprintf(fcode, "	add	a, r3\n");
		fprintf(fcode, "	mov	r6_2, a\n");
		fprintf(fcode, "	mov	a, r7_2\n");
		fprintf(fcode, "	add	a, #0\n");
		fprintf(fcode, "	mov	r7_2, a\n");
		fprintf(fcode, "	mov	r0, #0xf0\n");
		fprintf(fcode, "	mov	dpl, r4_2\n");
		fprintf(fcode, "	mov	dph, r5_2\n");
		fprintf(fcode, "EELOAD_4:\n");
		fprintf(fcode, "		mov	a, @r0\n");	// copy it out
		fprintf(fcode, "		movx	@dptr, a\n");
		fprintf(fcode, "		inc	dptr\n");
		fprintf(fcode, "		inc	r0\n");
		fprintf(fcode, "		djnz	r3, EELOAD_4\n");
		fprintf(fcode, "	mov	r4_2, dpl\n");
		fprintf(fcode, "	mov	r5_2, dph\n");
		fprintf(fcode, "	sjmp	EELOAD_1\n");
	}
	if (need_GET) {
		need_call_uv =1;
		fprintf(fcode, "GET:\n");
		fprintf(fcode, "	mov	a, r2\n");
		fprintf(fcode, "	cjne	a, #8,  GET_1\n");
		fprintf(fcode, "GET_1:\n");
		fprintf(fcode, "	jnc	GET_2\n");
		fprintf(fcode, "	xrl	a, #3\n");
		fprintf(fcode, "	mov	r0, a\n");
		fprintf(fcode, "	mov	r2, #'A'\n");
		fprintf(fcode, "	lcall	call_uv\n");
		fprintf(fcode, "	clr	c\n");
		fprintf(fcode, "	mov	a, r1\n");
		fprintf(fcode, "	rrc	a\n");
		fprintf(fcode, "	mov	r3, a\n");
		fprintf(fcode, "	mov	a, r0\n");
		fprintf(fcode, "	rrc	a\n");
		fprintf(fcode, "	mov	r2, a\n");
		fprintf(fcode, "	ret\n");
		fprintf(fcode, "GET_2:\n");
		fprintf(fcode, "	mov	r3, #0\n");
		fprintf(fcode, "	clr	a\n");
		fprintf(fcode, "	cjne	r2, #8,  GET_3\n");
		fprintf(fcode, "		mov	c, p1.7\n");
		fprintf(fcode, "		rlc	a\n");
		fprintf(fcode, "		mov	r2, a\n");
		fprintf(fcode, "		ret\n");
		fprintf(fcode, "GET_3:\n");
		fprintf(fcode, "	cjne	r2, #9,  GET_4\n");
		fprintf(fcode, "		mov	c, p1.6\n");
		fprintf(fcode, "		rlc	a\n");
		fprintf(fcode, "		mov	r2, a\n");
		fprintf(fcode, "		ret\n");
		fprintf(fcode, "GET_4:\n");
		fprintf(fcode, "	cjne	r2, #10,  GET_5\n");
		fprintf(fcode, "		mov	c, p1.5\n");
		fprintf(fcode, "		rlc	a\n");
		fprintf(fcode, "GET_5:\n");
		fprintf(fcode, "		mov	r2, a\n");
		fprintf(fcode, "		ret\n");
	}
	if (need_SET) {
		fprintf(fcode, "SET:\n");
		if (logging)
			fprintf(fcode, "	mov	r7, r2\n");
		fprintf(fcode, "	mov	a, r4\n");
		fprintf(fcode, "	cjne	r2, #8,  SET_1\n");
		fprintf(fcode, "		rrc	a\n");
		fprintf(fcode, "		mov	p1.7, c\n");
		fprintf(fcode, "		ret\n");
		fprintf(fcode, "SET_1:\n");
		fprintf(fcode, "	cjne	r2, #9,  SET_2\n");
		fprintf(fcode, "		rrc	a\n");
		fprintf(fcode, "		mov	p1.6, c\n");
		fprintf(fcode, "		ret\n");
		fprintf(fcode, "SET_2:\n");
		fprintf(fcode, "	cjne	r2, #10,  SET_3\n");
		fprintf(fcode, "		rrc	a\n");
		fprintf(fcode, "		mov	p1.5, c\n");
		fprintf(fcode, "SET_3:\n");
		if (logging) {
			// PUSH(pc);
			// PUSH(v2);
			fprintf(fcode, "	pop	r1_0\n");
			fprintf(fcode, "	pop	r0_0\n");
			fprintf(fcode, "	mov	r2, r4\n");
			fprintf(fcode, "	mov	r3, #0\n");
			PUSH(1);
			// PUSH(v1);
			// PUSH(0x43);
			fprintf(fcode, "	mov	r0, r7\n");
			fprintf(fcode, "	mov	r1, #0\n");
			fprintf(fcode, "	mov	r2, #0x46\n");
			PUSH(1);
			fprintf(fcode, "	mov	r2, #(trampoline)&0xff\n");
			fprintf(fcode, "	mov	r3, #(trampoline>>8)&0xff\n");
			fprintf(fcode, "	ljmp	extra\n");
		} else {
			fprintf(fcode, "		ret\n");
		}
	}
	if (need_call_uv) {
		fprintf(fcode, "call_uv:\n");
		fprintf(fcode, "	mov	r1, #0x8a\n");
		fprintf(fcode, "	mov	a, @r1\n");
		fprintf(fcode, "	mov	dpl, a\n");
		fprintf(fcode, "	inc	r1\n");
		fprintf(fcode, "	mov	a, @r1\n");
		fprintf(fcode, "	mov	dph, a\n");
		fprintf(fcode, "	clr	a\n");
		fprintf(fcode, "	jmp	@a+dptr\n");
	} 
	if (need_LAUNCH) {
		int l=lab++;
		fprintf(fcode, "LAUNCH:\n");
		fprintf(fcode, "	mov	a, pend_int\n");
		fprintf(fcode, "	jnb	acc.5, X%04x\n", l);
		fprintf(fcode, "	clr	acc.5\n");
		fprintf(fcode, "	mov	pend_int, a\n");
		fprintf(fcode, "	mov	r2, #0xff\n");
		fprintf(fcode, "	sjmp	Y%04x\n",l);
		fprintf(fcode, "X%04x:\n", l);
		fprintf(fcode, "	mov	r2, #0\n");
		fprintf(fcode, "Y%04x:\n", l);
		fprintf(fcode, "	mov	r3, r2\n");
		fprintf(fcode, "	ret\n");
	}
	if (need_WIDEN) {
		fprintf(fcode, "WIDEN:\n");
		WIDEN();
		fprintf(fcode, "	ret\n");
	}
	if (need_PUSH&2) {
		fprintf(fcode, "PUSH_4:\n");
		PUSH(1);
		fprintf(fcode, "	ret\n");
	}
	if (need_PUSH&1) {
		fprintf(fcode, "PUSH_2:\n");
		PUSH(0);
		fprintf(fcode, "	ret\n");
	}
	fprintf(fcode, "LSTR:\n");
	for (i = 0; i < string_size; i++)
		fprintf(fcode, "	byte	0x%x\n", mem[i+strp]);
	fprintf(fcode, "LGP:\n");
	//for (i = 0; i < global_size; i++)
	//	fprintf(fcode, "	byte	0x0\n");
	fclose(fcode);
	return(0);
}



