/*
 *      Copyright (c) 1987 Paul Campbell
 *      All Rights Reserved
 *      THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Paul Campbell
 *      The copyright notice above does not evidence any
 *      actual or intended publication of such source code.
 */

#pragma segment lex
#include <stdio.h>
#include <stdlib.h>
#ifdef MPW
#include <string.h>
#include <osutils.h>
#endif
#ifdef _DOS
#include "cttab.h"
#else
#include "ctl.tab.h"
#endif
static FILE *fin;

extern int yydebug;
extern int nowarn;
extern int yylval;

extern int yydebug;
int yyerrcount;
unsigned long yyline;
static char *yyfile;
static char name[257];

struct keywords {
	int 	type;
	char 	*name;
};

struct keywords keywords[] = {
	t_channel,	"channel",
	t_input,	"input",
	t_interrupt,	"interrupt",
	t_timescale,	"timescale",
	0,		"\377",
};

#define next_char()	(getc(fin))
#define back_char(c) { ungetc(c, fin); }

void
yyinit()
{
/*	ptree(dict_head, 0);*/
}


int
yyopen(char *file)
{
	yyline = 1;
	yyfile = file;
	yyerrcount = 0;
	fin = fopen(file, "r");
	if (fin)
		return(0);
	return(1);
}

void
yyerror(char *s, long a, long b, long c, long d, long e, long f)
{
	fprintf(stderr, "File	\"%s\"; Line %d # ", yyfile, yyline);
	fprintf(stderr, s, a, b, c, d, e, f);
	fprintf(stderr, "\n");
	yyerrcount++;
}

void 
yywarnline(int err, char *s, long a, long b, long c, long d, long e, long f)
{
	long *x = (long *)&s;

	if (nowarn)
		return;
	fprintf(stderr, "File	\"%s\"; Line %d # Warning: ", yyfile, err);
	fprintf(stderr, s, a,b,c,d,e,f);
	fprintf(stderr, "\n");
}

void 
yyerrline(int err, char *s, long a, long b, long c, long d, long e, long f)
{
	int i = yyline;
	long *x = (long *)&s;
	
	yyline = err;
	yyerror(s, a,b,c,d,e,f);
	yyline = i;
}

void 
yyerrlinex(long err, char *s, long a, long b, long c, long d, long e, long f)
{
	int i = yyline;
	long *x = (long *)&s;
	
	yyline = err;
	yyerror(s, a,b,c,d,e,f);
	yyline = i;
}

void
yyclose()
{
	fclose(fin);
}

int
yylex()
{
	register long c, i, j, k;
	struct dict *dp;
	double f, d;
	char *cp;
	
	for (;;) {
again:	for (;;) {
			c = next_char();
			if (c == ' ' || c == '\t')
				continue;
			if (c == '\n') {
				yyline++;
				continue;
			}
			break;
		}
		if ((c >= 'a' && c <= 'z') ||
			(c >= 'A' && c <= 'Z') ||
			 c == '_') {
			name[0] = c;
			for (i = 1;;i++) {
				c = next_char();
				if ((c >= 'a' && c <= 'z') ||
					(c >= 'A' && c <= 'Z') ||
					(c >= '0' && c <= '9') ||
					 c == '$' ||
					 c == '_') {
					 name[i] = c;
					 continue;
				}
				name[i] = 0;
				break;
			}
names:
			back_char(c);
			for (j = 0; ;j++) {
				if ((k = strcmp(name, keywords[j].name)) == 0) {
					yylval = (long)yyline;
					return(keywords[j].type);
				}
				if (keywords[j].type==0)
					break;
			}
			return(t_symbol);
		} 
		if (c >= '0' && c <= '9') {
			i = 0;
			if (c == '0') {
				c = next_char();
				if (c == '.')
					goto do_float;
				if (c == 'x' || c == 'X') {
					c = next_char();
					while ((c >= '0' && c <= '9') || (c >= 'A' && c <= 'F') || (c >= 'a' && c <= 'f')) {
						if (c >= '0' && c <= '9') {
							i = (i<<4)+c-'0';
						} else
						if (c >= 'A' && c <= 'F') {
							i = (i<<4)+10+c-'A';
						} else {
							i = (i<<4)+10+c-'a';
						}
						c = next_char();
					}
				} else 
				if (c >= '0' || c <= '7') {
					while (c >= '0' && c <= '7') {
						i = (i<<3)+c-'0';
						c = next_char();
					}
				} 
				back_char(c);
				yylval = i;
				return(t_num);
			} else {
				while (c >= '0' && c <= '9') {
					i = i*10+c-'0';
					c = next_char();
				}
			}
do_float:
			if (c != '.') {
				back_char(c);
				yylval = i;
				return(t_num);
			}
			f = ((double)i)*1000.0;
			d = 100.0;
			for (;;) {
				c = next_char();
				if (c >= '0' && c <= '9') {
					f += (c-'0')*d;
					d = d/10.0;
					continue;
				}
				back_char(c);
                                yylval = (long)f;
                                return(t_float);
			}
		} 
		yylval = (long)yyline;
		switch (c&0xff) {
		case '\'':
				for (i = 0;;i++) {
					name[i] = c = next_char();
					if (c == '\n' || c == EOF) {
						yyerror("string overflowed line",0,0,0,0,0,0);
						return(t_num);
					}
					if (c == '\'') {
						break;
					}
					if (c == '\\') {
						c = next_char();
						switch (c) {
						case 'n':
							c = 0xa;
							break;
						case 'r':
							c = 0xd;
							break;
						case 't':
							c = '\t';
							break;
						case 'f':
							c = '\f';
							break;
						case 'b':
							c = '\b';
							break;
						}
						name[i] = c;
					}
					if (i >= 3) {
						yyerror("string > 2 chars",0,0,0,0,0,0);
						i = 2;
						break;
					}
				}
				if (i == 1) {
					yylval = name[0]&0xff;
				} else
				if (i == 2) {
					yylval = *(unsigned short *)name;
				} 
				return(t_num);
				
		case '/':
				c = next_char();
				if (c == '*') {
					i = yyline;
					for (;;) {
						c = next_char();
						while (c == '*') {
							c = next_char();
							if (c == '/')
								goto out;
						}
						if (c == '\n') {
							yyline++;
						} else
						if (c == EOF) 
							break;
					}
					k = yyline;
					yyline = j;
					yyerror("runaway comment",0,0,0,0,0,0);
					yyline = k;
	out:
					continue;
				} else
				if (c == '/') {
					for (;;) {
						c = next_char();
						if (c == '\n' || c == EOF) 
							break;
					}
					if (c == '\n')
						yyline++;
					continue;
				}
				back_char(c);
				c = '/';
				break;
			
		case '"':
				for (i = 0;;i++) {
					name[i] = c = next_char();
					if (c == '\n' || c == EOF) {
						yyerror("string overflowed line",0,0,0,0,0,0);
						return(t_string);
					}
					if (c == '"') {
						name[i] = 0;
						break;
					}
					if (c == '\\') {
						c = next_char();
						switch (c) {
						case 'n':
							c = 0xa;
							break;
						case 'r':
							c = 0xd;
							break;
						case 't':
							c = '\t';
							break;
						case 'f':
							c = '\f';
							break;
						case 'b':
							c = '\b';
							break;
						}
						name[i] = c;
					}
				}
				cp = (char *)malloc(strlen(name)+1);
				strcpy(cp, name);
				yylval = (long)cp;
				return(t_string);
		}
		return(c);
	}
}
