/*
 *      Copyright (c) 1991 Paul Campbell
 *      All Rights Reserved
 *      THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Paul Campbell
 *      The copyright notice above does not evidence any
 *      actual or intended publication of such source code.
 */
#define COMPILER 1
#pragma segment states
#include <stdio.h>
#include <stdlib.h>
#ifdef MPW
#include <osutils.h>
#include <string.h>
#endif
#include "lex.h"
#include "code.h"

static struct label *next_lab;
int got_states;
struct label *start_label;
static char sname1[25], sname2[25];
static struct dict *statep;
struct label *real_start=NULL;
extern FILE *fcode;
extern struct OP *constant();
extern void empty_stack();
extern struct OP *types();
extern int smallM, smallB;
int in_states = 0;
extern unsigned long yyline;
extern int need_log;

void
init_states()
{
	start_label = new_label();
	out_jmp(P_JMP, start_label);
}

void
test_states()
{
	int i = 0;
	struct label *x, *y;

	if (real_start == NULL) {
                yyerror("No state called 'start' defined", 0,0,0,0,0,0);
                return;
        }
	x = new_label();
	y = new_label();
	if (code_intrinsics()) {
		use_label(x);
		add_intrinsics(y);
		set_label(start_label, x);
		out_jmp(P_JMP, real_start);	
		use_label(y);
		out_const(P_CUTN, 3*2);
		out_const(P_RET, 0xffff);
	} else {
		set_label(start_label, real_start);
	}
	check_states();
}


void
next_state(struct dict *name)
{
	if (!in_states) {
                yyerror("next statements not allowed in subroutines", 0,0,0,0,0,0);
                return;
	}
	if (name->loc != LOC_STATE && name->loc != LOC_UNKNOWN) {
                yyerror("Duplicate variable declaration '%s'", (long)name->name,0,0,0,0,0);
                return;
        }
	if (name->loc == LOC_UNKNOWN) {
		name->loc = LOC_STATE;
		name->label = new_label();
	}
	out_jmp(P_JMP, name->label);
}

void
start_state(struct dict *name)
{
	in_states = 0;
	if (name->loc != LOC_STATE || name->label->state)
	if (name->loc != LOC_UNKNOWN) {
                yyerror("Duplicate variable declaration '%s'", (long)name->name,0,0,0,0,0);
                return;
        }
	if (name->loc == LOC_UNKNOWN) {
		name->loc = LOC_STATE;
		name->label = new_label();
	}
	if (strcmp(name->name, "start") == 0) {
		real_start = new_label();
		use_label(real_start);
	}
	log_code("state", name);
	name->label2 = new_label();
	name->val = pc;	
	statep = name;
	use_label(name->label);
	//fprintf(fcode, "	clr		0x%x.%d\n", (tr0>>8)&0xff, tr0&0xff);
	out(P_SAVE_TIME);
	next_lab = NULL;
	in_states = 1;
}

void
mid_state()
{
	if (statep == NULL)
		return;
	use_label(statep->label2);
	out(P_POLL);
}

void
end_halt()
{
	out(P_HALT);
}

void
end_state()
{
	if (next_lab)
		set_label(next_lab, statep->label2);
	in_states = 0;
	statep = 0;
}

void
event_int(int v)
{
	if (next_lab)
		use_label(next_lab);
	next_lab = new_label();
	out_const(P_INTERRUPT, v);
	out_jmp(P_J_EQ, next_lab);
}

void
event_exp(struct OP *p)
{
	if (next_lab)
		use_label(next_lab);
	next_lab = new_label();
	do_cond(0, p, next_lab);
}

void
event_timeout(struct OP *p)
{
	if (next_lab)
		use_label(next_lab);
	next_lab = new_label();
	if (p->op != O_CONST) {
		yyerror("timeout needs a constant time (in ticks)",0,0,0,0,0,0);
	} else {
		out_const4(P_CMP_TIME, p->o.c.val);
		out_jmp(P_J_EQ, next_lab);	
	}
	tree_free(p);
}

void
event_input(struct dict *dp)
{
	struct OP *p;
	struct label *l;
	
	if (next_lab)
		use_label(next_lab);
	next_lab = new_label();
	out(P_INPUT);
	out_jmp(P_J_EQ, next_lab);	
	if (dp == NULL || dp->loc != LOC_LOCAL && dp->loc != LOC_GLOBAL || !SCALAR_TYPE(dp->type)) {
                yyerror("invalid input destination '%s'", (long)dp->name,0,0,0,0,0);
		return;
	}
	if (LONG_TYPE(dp->type))
		out(P_WIDENU);
	if (dp->loc == LOC_GLOBAL) {
		if (CHAR_TYPE((dp->type))) {
			out_const(P_SBYTE_G, dp->val);
		} else
		if (WORD_TYPE((dp->type))) {
			out_const(P_SWORD_G, dp->val);
		} else {
			out_const(P_SLONG_G, dp->val);
		} 
	} else {
		if (CHAR_TYPE((dp->type))) {
			out_const(P_SBYTE_L, dp->val);
		} else
		if (WORD_TYPE((dp->type))) {
			out_const(P_SWORD_L, dp->val);
		} else {
			out_const(P_SLONG_L, dp->val);
		} 
	}
}

void
event_idle()
{
	if (next_lab)
		use_label(next_lab);
	next_lab = new_label();
}

void
event_output()
{
	if (next_lab)
		use_label(next_lab);
	next_lab = new_label();
	out(P_OUTPUT);
	out_jmp(P_J_EQ, next_lab);	
}

void
event_log_full()
{
	if (next_lab)
		use_label(next_lab);
	next_lab = new_label();
	out(P_LOG_FULL);
	out_jmp(P_J_EQ, next_lab);	
}

void
event_launch()
{
	if (next_lab)
		use_label(next_lab);
	next_lab = new_label();
	out(P_LAUNCH);
	out_jmp(P_J_EQ, next_lab);	
}

void
end_event()
{
	if (statep == NULL)
		return;
	out_jmp(P_JMP, statep->label2);	
}

