/*
 *      Copyright (c) 1987 Paul Campbell
 *      All Rights Reserved
 *      THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Paul Campbell
 *      The copyright notice above does not evidence any
 *      actual or intended publication of such source code.
 */
#define COMPILER 1
#pragma segment lex
#include <stdio.h>
#include <stdlib.h>
#include "lex.h"

extern char tree_commute[];

struct OP *
build0(unsigned short type, struct OP *ln)
{
	struct OP *p;

#ifdef DEBUG
	if (tree_size[type] != 0)
		printf("bad tree type %d\n", type);
#endif
	p = (struct OP *)malloc(sizeof(struct OP1) + HDR_SZ);
	if (p == NULL)
		err_space();
	p->op = type;
	p->sz = 0;
	p->tp = TYPE_UNKNOWN;
	p->line = (unsigned short)(long)ln;
	return(p);
}

struct OP *
build1(unsigned short type, struct OP *ln, struct OP *p1)
{
	struct OP *p;
	
#ifdef DEBUG
	if (tree_size[type] != 1)
		printf("bad tree type %d\n", type);
#endif
	p = (struct OP *)malloc(sizeof(struct OP1) + HDR_SZ);
	if (p == NULL)
		err_space();
	p->op = type;
	p->sz = 0;
	p->tp = TYPE_UNKNOWN;
	p->line = (unsigned short)(long)ln;
	p->op1 = p1;
	return(p);
}

struct OP *
build2(unsigned short type, struct OP *ln, struct OP *p1, struct OP *p2)
{
	struct OP *p;
	
#ifdef DEBUG
	if (tree_size[type] != 2)
		printf("bad tree type %d\n", type);
#endif
	p = (struct OP *)malloc(sizeof(struct OP2) + HDR_SZ);
	if (p == NULL)
		err_space();
	p->op = type;
	p->sz = 0;
	p->tp = TYPE_UNKNOWN;
	p->line = (unsigned short)(long)ln;
	p->op1 = p1;
	p->op2 = p2;
	return(p);
}

struct OP *
build3(unsigned short type, struct OP *ln, struct OP *p1, struct OP *p2, struct OP *p3)
{
	struct OP *p;
	
#ifdef DEBUG
	if (tree_size[type] != 3)
		printf("bad tree type %d\n", type);
#endif
	p = (struct OP *)malloc(sizeof(struct OP3) + HDR_SZ);
	if (p == NULL)
		err_space();
	p->op = type;
	p->sz = 0;
	p->tp = TYPE_UNKNOWN;
	p->line = (unsigned short)(long)ln;
	p->op1 = p1;
	p->op2 = p2;
	p->op3 = p3;
	return(p);
}

struct OP *
build4(unsigned short type, struct OP *ln, struct OP *p1, struct OP *p2, struct OP *p3, struct OP *p4)
{
	struct OP *p;
	
#ifdef DEBUG
	if (tree_size[type] != 4)
		printf("bad tree type %d\n", type);
#endif
	p = (struct OP *)malloc(sizeof(struct OP4) + HDR_SZ);
	if (p == NULL)
		err_space();
	p->op = type;
	p->sz = 0;
	p->tp = TYPE_UNKNOWN;
	p->line = (unsigned short)(long)ln;
	p->op1 = p1;
	p->op2 = p2;
	p->op3 = p3;
	p->op4 = p4;
	return(p);
}

struct OP *
build_name(struct dict *name)
{
	struct OP *p;
	
	p = (struct OP *)malloc(sizeof(struct OPN) + HDR_SZ);
	if (p == NULL)
		err_space();
	p->op = O_NAME;
	p->sz = 0;
	p->tp = TYPE_UNKNOWN;
	p->line = (unsigned short)yyline;
	p->o.n.d = name;
	return(p);
}

struct OP *
make_constant(long l)
{
	struct OP *p;
	
	p = (struct OP *)malloc(sizeof(struct OPC) + HDR_SZ);
	if (p == NULL)
		err_space();
	p->op = O_CONST;
	p->sz = 0;
	p->tp = TYPE_UNKNOWN;
	p->line = (unsigned short)yyline;
	p->o.c.val = l;
	return(p);
}

extern char  *sss;
extern int sss_ind;

struct OP *
make_string(char *str)
{
	struct OP *p;

	p = (struct OP *)malloc(sizeof(struct OPS) + HDR_SZ);
	if (p == NULL)
		err_space();
	p->op = O_STRING;
	p->sz = 0;
	p->tp = TYPE_UNKNOWN;
	p->line = (unsigned short)yyline;
	p->o.s.val = sss_ind;
	while (*str)
		sss[sss_ind++] = *str++;
	sss[sss_ind++] = 0;
	return(p);
}

void
err_space()
{
	yyerror("compiler ran out of space",0,0,0,0,0,0);
	yydone(1);
}

void
tree_free(struct OP *trp)
{
	int s;
	
	if (trp == NULL)
		return;
	s = tree_size[trp->op];
	if (s >= 1 && s < 128) {
		if (trp->op1) tree_free(trp->op1);
		if (s >= 2) {
			if (trp->op2) tree_free(trp->op2);
			if (s >= 3) {
				if (trp->op3) tree_free(trp->op3);
				if (s >= 4) {
					if (trp->op4) tree_free(trp->op4);
				}
			}
		}
	}
	free(trp);
}

struct OP *
dup_tree(struct OP *trp)
{
	struct OP *p;
	int s;
	if (trp == NULL)
		return(NULL);
	s = tree_size[trp->op];
	if (s < 0) {
		switch(trp->op) {
		case O_STRING:
			printf(" string: '%d'\n", trp->o.s.val);fflush(stdout);
			p = (struct OP *)malloc(sizeof(struct OPS) + HDR_SZ);
			if (p == NULL)
				err_space();
			p->o.s.val = sss_ind;
			break;
		case O_CONST:
			p = make_constant(trp->o.c.val);
			break;
		case O_NAME:
			p = build_name(trp->o.n.d);
			break;
		}
	} else {
		switch (s) {
		case 0:
			p = build0(trp->op, NULL);
			break;
		case 1:
			p = build1(trp->op, NULL, dup_tree(trp->op1));
			break;
		case 2:
			p = build2(trp->op, NULL, dup_tree(trp->op1), dup_tree(trp->op2));
			break;
		case 3:
			p = build3(trp->op, NULL, dup_tree(trp->op1), dup_tree(trp->op2), dup_tree(trp->op3));
			break;
		case 4:
			p = build4(trp->op, NULL, dup_tree(trp->op1), dup_tree(trp->op2), dup_tree(trp->op3), dup_tree(trp->op4));
			break;
		}
	}
	p->op = trp->op;
	p->sz = trp->sz;
	p->tp = trp->tp;
	p->line = trp->line;
	return(p);
}

void
tree_print(char *name, struct OP *trp, int ind)
{
	register int i, s;

	printf("%s ", name);
	for (i = 0; i < ind; i++)
		printf(".");
	if (trp == NULL) {
		printf(" NULL\n");
		return;
	}
	printf(" (%d,%c)", trp->sz, (trp->tp > TYPE_LONG_IND_IND ? '?':*("?CWLXYZcwlxyz124357"+trp->tp)));
	if (trp->op >= max_op) {
		printf(" INVALID - %d!!!\n", trp->op);fflush(stdout);
		return;
	}
	s = tree_size[trp->op];
	if (s < 0) {
		switch(trp->op) {
		case O_STRING:
			printf(" string: '%d'\n", trp->o.s.val);fflush(stdout);
			break;
		case O_CONST:
			printf(" const: %d\n", trp->o.c.val);fflush(stdout);
			break;

		case O_NAME:
			printf(" name: %s\n", trp->o.n.d->name);fflush(stdout);
			break;
		}
	} else {
		printf(" %s\n", tree_name[trp->op]);fflush(stdout);
		if (s >= 1) {
			ind++;
			tree_print(name, trp->op1, ind);
			if (s >= 2) {
				tree_print(name, trp->op2, ind);
				if (s >= 3) {
					tree_print(name, trp->op3, ind);
					if (s >= 4) {
						tree_print(name, trp->op4, ind);
					}
				}
			}
		}
	}
}
